/*
 *	Copyright  2008 George Weller
 *	
 *	This file is part of PathZilla.
 *	
 *	PathZilla is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 2 of the License, or
 *	(at your option) any later version.
 *	
 *	PathZilla is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with PathZilla.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * main.nut
 *
 * PathZilla - A networking AI. See readme.txt for details.
 * 
 * Author:  George Weller (Zutty)
 * Created: 16/05/2008
 * Updated: 01/11/2016
 * Version: 12
 */

class PathZilla extends AIController {
	// Constants - DO NOT change these!
	DIR_NORTH = 1;
	DIR_SOUTH = 2;
	DIR_EAST = 3;
	DIR_WEST = 4;
	TILE_LENGTH_KM = 429;

	// Info constants	
	PZ_IDENT = "ROADRUNNER"
	PZ_VERSION = 12;
	
	// Serialisation constants
	SRLZ_IDENT = 0;
	SRLZ_STOP = 1;
	SRLZ_COMPANY_NAME = 2;
	SRLZ_HOME_TOWN = 3;
	SRLZ_TICKER = 4;
	SRLZ_SCHEMA_IDX = 5;
	SRLZ_SCHEMAS = 6;
	SRLZ_SRVC_MANAGER = 7;
	SRLZ_TRAFFIC_BLACKSPOTS = 8;
	SRLZ_VEHICLES_TO_SELL = 9;
	SRLZ_REPLACE_LIST = 10;
			
	// Configurable constants
	PROCESSING_PRIORITY = 8000;     // Governs how often intensive processing tasks should wait
	MAX_TARGETS = 8;             // Maximum number of targets that can be in a single graph 
	MAX_TARGET_COVERAGE = 58;      // Maximum percentage of town houses to fall within combined station coverage area
	NEW_VEHICLE_SPREAD_DELAY = 25; // The delay in ms between launching new vehicles in a fleet.
	MAX_BRIDGE_LENGTH = 15;        // The maximum allowable bridge length - to prevent ridiculous bridges
	MAX_POTENTIAL_SERVICES = 300;  // The maximum allowable number of potential service descriptors  
	ARV_ACC_THRESHOLD = 50;        // Minimum percentage of acceptance via DTRSs before ARVs can be built
	ENGINE_SCORE_THRESHOLD = 80000;   // The minimum score for an engine to be randomly selected
	MAX_CONSTR_ATTEMPTS = 2;	   // The maximum number of attempts when trying to build something
	BRIBE_THRESHOLD = 800000;	   // Minimum funds available before a bribe will be considered
	MAX_TREE_SPEND = 10000;		   // Maximum we can spend on trees to improve rating
	MAX_TOWN_RADIUS = 11;		   // Maximum distance from a town centre that anything can be built
	MAX_REPATH_TRIES = 5;		   // Maximum number a times path can be re-found due to construction problems
	MAX_VEHICLES_PER_SVC = 500;	   // Maximum number of vehicles per service
	INDUSTRY_FLEET_MULTI = 4;	   // Fleet size multiplier for industrial services
	TARGET_FIX_RADIUS = 4;		   // Radius around a target we should look to fix a tile
	MAX_INITIAL_STATIONS = 1;	   // Maximum number of stations to start a service with
	PAX_SERVICE_CAP_BASE = 10000000;   // Base level for limit on number of passengers AI will aim to transport
	SERVICE_PROFIT_THRESHOLD = 0;  // Threshold at which to declare a service profitable
	
	// Member variables
	stop = false;
	loaded = false;
	companyName = null;
	homeTown = null;
	schemaIndex = 0;
	schemas = null;
	serviceManager = null;
	ticker = 0;
	MMM=0;
	stopspam=0;	
	FLOAT=5000;
	constructor() {
		require("graph/Edge.nut");
		require("graph/Graph.nut");
		require("graph/GraphPathNode.nut");
		require("graph/Triangle.nut");
		require("graph/Vertex.nut");
		require("graph/impl/MinimumSpanTree.nut");
		require("graph/impl/ShortestPathTree.nut");
		require("graph/impl/Triangulation.nut");
		require("manager/FinanceManager.nut");
		require("manager/LandManager.nut");
		require("manager/RoadManager.nut");
		require("manager/TownManager.nut");
		require("pathfinding/PathWrapper.nut");
		require("pathfinding/Road.nut");
		require("schema/Schema.nut");
		require("service/Service.nut");
		require("service/ServiceManager.nut");
		require("service/Target.nut");
		require("struct/Collection.nut");
		require("struct/BinaryHeap.nut");
		require("struct/Map.nut");
		require("struct/SortedSet.nut");
		require("Settings.nut");
		require("common.nut");

		// Some presets that must go here
		this.loaded = false;
		this.schemas = {};
		MMM=null;

		stopspam=0;		
		FLOAT=5000;
		// Set this as the singleton instance
		::pz <- this;
	}
}

/*
 * Start running. Most of the planning, including calculating the plan graph is
 * done before we start looping, though services are selected on the fly. The 
 * main loop manages the loan and events, maintains existing services, attempts
 * to find new services, and then finally builds one.   
 */
function PathZilla::Start() {
::trafficBlackSpots <- AIList();	
::vehiclesToSell <- AIList();	
::stmsg<-AIList();
::lastvehicle<-AIDate.GetCurrentDate()-30;
::lastservice<-AIDate.GetCurrentDate()-100;
foreach(vehicle,_ in AIVehicleList()){
if (AIVehicle.IsValidVehicle(vehicle)){
::lastvehicle=max(AIDate.GetCurrentDate()-AIVehicle.GetAge(vehicle)-50,::lastvehicle);
::lastservice=::lastvehicle-200;
}
}
::german<-false;
::vc<-AIVehicleList().Count();
::vi<-2222;
::c<-AICargoList();
::tt1<-0;
::tt2<-0;

::pfem<-(PathZilla.GetSetting("pathfinding")+(PathZilla.GetSetting("pathfinding")*min(4,sqrt(AICompany.GetCompanyValue(AICompany.COMPANY_SELF))/1500)/100)+1).tointeger();
::depotList<- AIList();
::tileList<- AIList();
::etarget<-{};
::mille<-0;
if (AICompany.GetLoanAmount()<1&&88888+AICompany.GetBankBalance(AICompany.COMPANY_SELF)>1000000)
::mille=((88888+AICompany.GetBankBalance(AICompany.COMPANY_SELF))/1000000).tointeger();
::upd<-AIDate.GetCurrentDate()-22;
::spd<-168;
::D<-true;
local vlist=AIVehicleList();
if (!vlist.IsEmpty()){
vlist.Valuate(AIVehicle.GetCurrentSpeed);
vlist.Sort(AIAbstractList.SORT_BY_VALUE, false);
::spd=max(::spd,(vlist.GetValue(vlist.Begin()))*3);
}
::report<-this.ticker%33;
this.ticker=(this.ticker/33).tointeger();
::hq<-PathZilla.GetSetting("hq");
AICompany.SetAutoRenewMoney(FLOAT);
AICompany.SetAutoRenewMonths(18);
AICompany.SetAutoRenewStatus(true);
this.stopspam=0;
if (PathZilla.GetSetting("language")==0){
foreach(e,_ in AIIndustryTypeList()){
local n=AIIndustryType.GetName(e);
local str="";
local kstr="";
local sstr="";
	for (local a=0;a<n.len();a++){
	if ((n[a]).tochar()=="B") str=""
	str=str+(n[a]).tochar();
	if ((n[a]).tochar()=="K") kstr=""
	kstr=kstr+(n[a]).tochar();
	if ((n[a]).tochar()=="S") sstr=""
	sstr=sstr+(n[a]).tochar();
	if (str=="Bauernhof"||sstr=="Stahl"||kstr=="Kohle")::german=true;
	}
if (::german==true)break;
}
}else if(PathZilla.GetSetting("language")==2){
::german=true;
}
(::german)?AILog.Info("  Miep! Miep!"):AILog.Info("  RoadRunner is on the road...");
::major<-((AIController.GetVersion()).tointeger()-(AIController.GetVersion()).tointeger()%268435456).tointeger()/268435456;
::minor<-(((AIController.GetVersion()).tointeger()-(AIController.GetVersion()).tointeger()%16777216).tointeger()-::major*268435456)/16777216;

	// Initialise the AI
this.Initialise();
	//Build headquarter
local stlist=AIList();
local searchRadius = PathZilla.MAX_TOWN_RADIUS+25;
		local tileList = AITileList();
		local targetTile=AITown.GetLocation(this.homeTown);
		tileList.AddRectangle(AIMap.GetTileIndex(max(AIMap.GetTileX(targetTile) - searchRadius,1),max(AIMap.GetTileY(targetTile) - searchRadius,1)),AIMap.GetTileIndex(min(AIMap.GetTileX(targetTile) + searchRadius,AIMap.GetMapSizeX()-2),min(AIMap.GetTileY(targetTile) + searchRadius,AIMap.GetMapSizeY()-2)));
		foreach(tile, _ in tileList) {
			local suitable = (AIMap.IsValidTile(tile)&&AITile.IsBuildable(tile) && AITile.GetSlope(tile)==AITile.SLOPE_FLAT&&AITile.IsBuildable(tile+AIMap.GetTileIndex(1,0)) && AITile.GetSlope(tile+AIMap.GetTileIndex(1,0))==AITile.SLOPE_FLAT&&AITile.IsBuildable(tile+AIMap.GetTileIndex(0,1)) && AITile.GetSlope(tile+AIMap.GetTileIndex(0,1))==AITile.SLOPE_FLAT&&AITile.IsBuildable(tile+AIMap.GetTileIndex(1,1)) && AITile.GetSlope(tile+AIMap.GetTileIndex(1,1))==AITile.SLOPE_FLAT);
			tileList.SetValue(tile, (suitable) ? 1 : 0);
		}
		tileList.RemoveValue(0);
		foreach(tile, _ in tileList) {
			local r = AITile.GetDistanceManhattanToTile(tile, AITown.GetLocation(this.homeTown)) + AIBase.RandRange(8) - 4;
			tileList.SetValue(tile, r);
		}
		tileList.Sort(AIAbstractList.SORT_BY_VALUE, true);
if (AICompany.GetCompanyHQ(AICompany.COMPANY_SELF)==AIMap.TILE_INVALID&&!tileList.IsEmpty()){
local tile=tileList.Begin();
while (!AICompany.BuildCompanyHQ(tile)&&hasnext(tileList))tile=tileList.Next();
}
(::german)?AILog.Info("  Mein Firmensitz ist in "+AITown.GetName(this.homeTown)):AILog.Info("  My home town is " + AITown.GetName(this.homeTown));
	// Initialise the main loop

	local noServices = true;
	local startDate=AIDate.GetCurrentDate();	
	local serlog=AIDate.GetCurrentDate()+::report*366;
	local sserlog=AIDate.GetDate(AIDate.GetYear(AIDate.GetCurrentDate())-1,9,1);

	// Load settings for loop latency
	local latency = Settings.GetLatency();
	local workInterval = max(10, latency * 20);
	local maintenanceInterval = max(40, workInterval * 2);
	local expansionInterval = max(20, workInterval * latency*2);

	// Start the main loop

	while(!this.stop) {
		// Try to keep the amount of funds available around FLOAT, by borrowing
		// or repaying the loan.
::vc=AIVehicleList().Count();
if (::hq==1&&!AISignList().IsEmpty())foreach(sign,_ in AISignList())AISign.RemoveSign(sign);
if (::hq==0&&::AICompany.GetLoanAmount()<1&&AICompany.GetBankBalance(AICompany.COMPANY_SELF)>1000000&&(::mille>0||AICompany.GetBankBalance(AICompany.COMPANY_SELF)<1500000)){
if (::mille==0){
::mille++;
(::german)?AILog.Error("  RoadRunners erste Million..."):AILog.Info("  RoadRunner earned his first Million. Hurray!!!");
(::german)?AILog.Error("  Auf nach Liechtenstein!"):0;
}else if (::mille<(AICompany.GetBankBalance(AICompany.COMPANY_SELF)/1000000).tointeger()){
local cpy=AICompany.ResolveCompanyID(AICompany.COMPANY_FIRST-1+::mille);
if (cpy!=AICompany.COMPANY_INVALID&&cpy!=AICompany.ResolveCompanyID(AICompany.COMPANY_SELF)){
local st=AICompany.GetCompanyHQ(cpy);
local st2=AIMap.GetTileIndex(AIMap.GetTileX(st)+1,AIMap.GetTileY(st)+1);
local st3=AIMap.GetTileIndex(AIMap.GetTileX(st)+2,AIMap.GetTileY(st)+2);
if (st!=AIMap.TILE_INVALID){
local f=AICompany.GetName(cpy);
local g=AICompany.GetPresidentName(cpy);
local z=f.len();
local t=AITown.GetName(AITile.GetClosestTown(st));
local fz=0;
while(fz++<2){
if (z>3&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()=="AIAI"){
(::german)?AISign.BuildSign(st,f+" Zentralbaracke"):AISign.BuildSign(st,f+" Barracks");
(::german)?AISign.BuildSign(st2,"Nur mit Schutzhelm betreten"):AISign.BuildSign(st2,"Only enter with helmet");break;}

if (z>3&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()=="Clue"){
(::german)?AISign.BuildSign(st,f+"-Firmenzentrale"):AISign.BuildSign(st,f+" Headquarter");
(::german)?AISign.BuildSign(st2,"Wo zum Teufel ist "+(34).tochar()+"0 T2 0 :)"+(34).tochar()+"?"):AISign.BuildSign(st2,"Where the hell is "+(34).tochar()+"0 T2 0:)"+(34).tochar()+"?");break;}

if (z>5&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()=="Convoy"){
(::german)?AISign.BuildSign(st,f+"'s Bauruine"):AISign.BuildSign(st,f+"'s Money Bin");
(::german)?AISign.BuildSign(st2,'"'+"Sitzt, wackelt und hat Luft"+'"'):AISign.BuildSign(st2,'"'+"We're always very bus(y)"+'"');break;}

if ((z>6&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()=="For the")||(z>9&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()+f[9].tochar()=="Revolution")||(z>6&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()=="Militia")||(z>10&&f[z-11].tochar()+f[z-10].tochar()+f[z-9].tochar()+f[z-8].tochar()+f[z-7].tochar()+f[z-6].tochar()+f[z-5].tochar()+f[z-4].tochar()+f[z-3].tochar()+f[z-2].tochar()+f[z-1].tochar()=="DictatorAI)")){
(::german)?AISign.BuildSign(st,"Diktatorenhauptquartier"):AISign.BuildSign(st,"Dictator's  Palace");
((z>9&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()+f[9].tochar()=="Revolution"))?((::german)?AISign.BuildSign(st2,"Bitte Schuhe abtreten"):AISign.BuildSign(st2,"Please wipe your feet")):((::german)?AISign.BuildSign(st2,"Kein Zutritt fuer Revoluzzer"):AISign.BuildSign(st2,"No access for rebels"));break;}

if (z>4&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()=="NoCAB"){
(::german)?AISign.BuildSign(st,f+"-Zentrale"):AISign.BuildSign(st,f+" Headquarter");
(::german)?AISign.BuildSign(st2,"Angestellte fuettern verboten"):AISign.BuildSign(st2,"Don't feed the employees");break;}

if (z>3&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()=="OTVI"){
(::german)?AISign.BuildSign(st,f+"-Stauzentrale"):AISign.BuildSign(st,f+" congestion office");
(::german)?AISign.BuildSign(st2,"ERROR: Can not build caravan"):AISign.BuildSign(st2,"ERROR: Can not build caravan");
if (st3!=AIMap.TILE_INVALID)(::german)?AISign.BuildSign(st3,"Please download kaeskopp.grf"):AISign.BuildSign(st3,"Please download kaeskopp.grf");break;}

if ((z>14&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()+f[9].tochar()+f[10].tochar()+f[11].tochar()+f[12].tochar()+f[13].tochar()+f[14].tochar()=="Brackenton Line")||(z>14&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()+f[9].tochar()+f[10].tochar()+f[11].tochar()+f[12].tochar()+f[13].tochar()+f[14].tochar()=="Awesome Express")||(z>23&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()+f[9].tochar()+f[10].tochar()+f[11].tochar()+f[12].tochar()+f[13].tochar()+f[14].tochar()+f[15].tochar()=="Advanced Capital")||(z>8&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()=="Acme Labs")||(z>16&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()+f[9].tochar()+f[10].tochar()+f[11].tochar()+f[12].tochar()+f[13].tochar()+f[14].tochar()+f[15].tochar()+f[16].tochar()=="Something Awesome")||(z>7&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()=="Hercules")||(z>10&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()+f[9].tochar()+f[10].tochar()=="Far Go Inc.")||(z>4&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()=="InoCo")||(z>5&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()=="Terron")){
(::german)?AISign.BuildSign(st,"Obdachlosenheim "+t ):AISign.BuildSign(st,"Homeless Accommodation");
(::german)?AISign.BuildSign(st2,"TerronAI: 2.Stock, 3.Tuer links"):AISign.BuildSign(st2,"TerronAI: 2nd floor, 3rd door");break;}

if (g=="Fanio Zilla"){
(::german)?AISign.BuildSign(st,"Bueroruine"):AISign.BuildSign(st,"Office Ruin");
(::german)?AISign.BuildSign(st2,"Betreten verboten"):AISign.BuildSign(st2,"Do not enter");
(st3!=AIMap.TILE_INVALID&&::german)?AISign.BuildSign(st3,"Eltern haften fuer ihre Kinder"):t=t;break;}

if (g=="Lord Aro"||g=="Lady Aro"){
(::german)?AISign.BuildSign(st,g+"'s Zweizimmervilla"):AISign.BuildSign(st,"Casa di Aro");
if (st3!=AIMap.TILE_INVALID)(::german)?AISign.BuildSign(st2,"Bitte nicht waehrend"):AISign.BuildSign(st2,"Do not disturb during teatime");
(st3!=AIMap.TILE_INVALID&&::german)?AISign.BuildSign(st3,"der Teestunde stoeren"):t=t;break;}


if (z>6&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()=="Admiral"){
(::german)?AISign.BuildSign(st,"AdmiralAI-Hauptverwaltung"):AISign.BuildSign(st,f+" Headquarter");
(::german)?AISign.BuildSign(st2,"Konkurs an Land, zur See..."):AISign.BuildSign(st2,"Bancrupty on land and at sea");
(st3!=AIMap.TILE_INVALID&&::german)?AISign.BuildSign(st3,"...und in der Luft"):t=t;break;}

if (z>3&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()=="Bork"){
(::german)?AISign.BuildSign(st,f+"-Sperrholzbungalow"):AISign.BuildSign(st,f+"'s plywood bungalow");
(::german)?AISign.BuildSign(st2,"Bitte Schuhe abtreten"):AISign.BuildSign(st2,"Please wipe your feet");break;}

if (z>7&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()=="ChooChoo"){
(::german)?AISign.BuildSign(st,f+"'s Betonbunker"):AISign.BuildSign(st,f+"'s concrete bunker ");
(::german)?AISign.BuildSign(st2,"Es faehrt kein Zug"):AISign.BuildSign(st2,"Oh no, it's ChooChoo!!!");
(st3!=AIMap.TILE_INVALID&&::german)?AISign.BuildSign(st3,"nach Eierbach"):t=t;break;}

if (z>6&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()=="Chopper"){
(::german)?AISign.BuildSign(st,"Seniorenstift "+t):AISign.BuildSign(st,"Rest home "+t);
if(st3!=AIMap.TILE_INVALID)(::german)?AISign.BuildSign(st2,"Unberechtigt abgestellte Hub-"):AISign.BuildSign(st2,"Unauthorized parked");
if(st3!=AIMap.TILE_INVALID)(::german)?AISign.BuildSign(st3,"schrauber werden abgeschleppt"):AISign.BuildSign(st3,"helicopters will be towed");break;}

if (z>5&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()=="Denver"){
(::german)?AISign.BuildSign(st,"Heimat des Denver-Clans"):AISign.BuildSign(st,"Home of the Denver clan");
(::german)?AISign.BuildSign(st2,"^Big Boss inside^"):AISign.BuildSign(st2,"^Big Boss inside^");break;}

if (z>5&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()=="gelign"){
(::german)?AISign.BuildSign(st,"Kindergarten "+t):AISign.BuildSign(st,"Kindergarten "+t);
if(st3!=AIMap.TILE_INVALID)(::german)?AISign.BuildSign(st2,(34).tochar()+"Schau was ich schon"):AISign.BuildSign(st2,(34).tochar()+"Look what I build already"+(34).tochar());
if(st3!=AIMap.TILE_INVALID)(::german)?AISign.BuildSign(st3,"alles gebaut habe"+(34).tochar()):0;break;}

if (z>3&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()=="Mail"){
(::german)?AISign.BuildSign(st,"Postministerium Openttdanien"):AISign.BuildSign(st,"Ministry of Postal Services");
(::german)?AISign.BuildSign(st2,"Traritrara die Post ist da"):AISign.BuildSign(st2,"of Openttdania");break;}

if (z>5&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()=="Moguls"){
(::german)?AISign.BuildSign(st,"Mogul's Hexenhaeusl"):AISign.BuildSign(st,"Mogul's haunted witch house");
(::german)?AISign.BuildSign(st2,"Vorsicht schwarze Katzen"):AISign.BuildSign(st2,"Beware of black cats");break;}

if (z>8&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()=="PathZilla"){
(::german)?AISign.BuildSign(st,"PathZilla's altes Haus"):AISign.BuildSign(st,"PathZilla's old house");
(::german)?AISign.BuildSign(st2,"laeuft und laeuft und laeuft"):AISign.BuildSign(st2,"it never stops running");break;}

if (z>6&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()=="PAXLink"){
(::german)?AISign.BuildSign(st,f+"-Zentrale"):AISign.BuildSign(st,f+" Headquarter");
(::german)?AISign.BuildSign(st2,"Linkin' PAX"):AISign.BuildSign(st2,"Linkin' PAX");break;}

if ((z>10&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()+f[9].tochar()+f[10].tochar()=="On Your Way")||(z>13&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()+f[9].tochar()+f[10].tochar()+f[11].tochar()+f[12].tochar()+f[13].tochar()=="MEGA Transport")){
(::german)?AISign.BuildSign(st,"RoadAI Hauptquartier"):AISign.BuildSign(st,f+"RoadAI headquarter");
(::german)?AISign.BuildSign(st2,"Vorsicht! Oelspur voraus!"):AISign.BuildSign(st2,"Caution! Oil trail ahead!");break;}

if (z>6&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()=="Rythorn"){
(::german)?AISign.BuildSign(st,"RythornAirline Chefbuero"):AISign.BuildSign(st,"RythornAirline headquarter");
(::german)?AISign.BuildSign(st2,"Haaalllloooo!"):AISign.BuildSign(st2,"Heeelllllooooo!");
(st3!=AIMap.TILE_INVALID&&::german)?AISign.BuildSign(st3,"Kann mir einer 10Mio cheaten?"):AISign.BuildSign(st3,"Can someone cheat me 10mil.?");break;}

if (z>7&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()=="Synaptic"){
(::german)?AISign.BuildSign(st,"Synaptic-Konzernzentrale"):AISign.BuildSign(st,f);
(::german)?AISign.BuildSign(st2,"Morgen geschlossen"):AISign.BuildSign(st2,"Corporate Headquarters");
(st3!=AIMap.TILE_INVALID&&::german)?AISign.BuildSign(st3,"wegen Abbrucharbeiten"):0;break;}

if (z>5&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()=="Rondje"){
(::german)?AISign.BuildSign(st,"Hinfort mit dir"):AISign.BuildSign(st,"You evil parasitic bastard");
(::german)?AISign.BuildSign(st2,"du schmarotzendes Scheusal"):AISign.BuildSign(st2,"Die! Die! Die!!!!!");break;}

if (z>4&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()=="Teshi"){
(::german)?AISign.BuildSign(st,f+" Hauptquartier"):AISign.BuildSign(st,f+" headquarters");
(::german)?AISign.BuildSign(st2,"Sei nett zu Teshi"):AISign.BuildSign(st2,"Closed tomorrow");
(st3!=AIMap.TILE_INVALID&&::german)?0:AISign.BuildSign(st3,"because of demolition works");break;}

if (z>5&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()=="trAIns"){
(::german)?AISign.BuildSign(st,"TrAIns AG"):AISign.BuildSign(st,f+" headquarter");
(::german)?AISign.BuildSign(st2,"Zugfahrten ueber Berg und Tal"):AISign.BuildSign(st2,"TrAIns for olympia");break;}

if (z>4&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()=="WmDOT"){
(::german)?AISign.BuildSign(st,f+" Strassenbauamt"):AISign.BuildSign(st,f+" Highway Department");
(::german)?AISign.BuildSign(st2,"^RoadRunner likes this^"):AISign.BuildSign(st2,"^RoadRunner likes this^");break;}

if (z>5&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()=="Wright"){
(::german)?AISign.BuildSign(st,"Klavierhandlung Wright"):AISign.BuildSign(st,"Wright Brothers headquarter");
(::german)?AISign.BuildSign(st2,"Verleiht Fluegel"):AISign.BuildSign(st2,"All Wright!");break;}

if (z>5&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()=="Rocket"){
(::german)?AISign.BuildSign(st,f+"-Klohaeuschen"):AISign.BuildSign(st,f+"'s outhouses");
(::german)?AISign.BuildSign(st2,"Marke Dixi"):AISign.BuildSign(st2,"Original Dixi");break;}

if (z>5&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()=="Simple"){
(::german)?AISign.BuildSign(st,"Gebrueder Simple"):AISign.BuildSign(st,f+ " headquarter");
(::german)?AISign.BuildSign(st2,"Internationale Transporte"):AISign.BuildSign(st2,"...when stupidity is the goal");break;}

if ((z>12&&f[z-13].tochar()+f[z-12].tochar()+f[z-11].tochar()+f[z-10].tochar()+f[z-9].tochar()+f[z-8].tochar()+f[z-7].tochar()+f[z-6].tochar()+f[z-5].tochar()+f[z-4].tochar()+f[z-3].tochar()+f[z-2].tochar()+f[z-1].tochar()=="Transport Inc.")||(z>16&&f[0].tochar()+f[1].tochar()+f[2].tochar()+f[3].tochar()+f[4].tochar()+f[5].tochar()+f[6].tochar()+f[7].tochar()+f[8].tochar()+f[9].tochar()+f[10].tochar()+f[11].tochar()+f[12].tochar()+f[13].tochar()+f[14].tochar()+f[15].tochar()+f[16].tochar()=="Fast Impersonator")){
(::german)?AISign.BuildSign(st,"FastPTP-Konkursverwaltung"):AISign.BuildSign(st,f+ " residence");
(::german)?AISign.BuildSign(st2,"Zu verkaufen:"):AISign.BuildSign(st2,"Fast into bancrupty!");
(st3!=AIMap.TILE_INVALID&&::german)?AISign.BuildSign(st3,"Zuege aller Art: 600,-/t"):t=t;break;}

if (z>8&&f[z-9].tochar()+f[z-8].tochar()+f[z-7].tochar()+f[z-6].tochar()+f[z-5].tochar()+f[z-4].tochar()+f[z-3].tochar()+f[z-2].tochar()+f[z-1].tochar()=="Transport"){
(::german)?AISign.BuildSign(st,"Haus des Schreckens"):AISign.BuildSign(st,"House of Fear");
(g.len()<=15&&st3!=AIMap.TILE_INVALID&&::german)?AISign.BuildSign(st2,"Nur hier sehen Sie den"):0;
(g.len()<=11&&st3!=AIMap.TILE_INVALID&&!::german)?AISign.BuildSign(st2,"Come in and see with your own"):0;
(g.len()<=15&&st3!=AIMap.TILE_INVALID&&::german)?AISign.BuildSign(st3,"leibhaftigen "+g):0;
(g.len()<=11&&st3!=AIMap.TILE_INVALID&&!::german)?AISign.BuildSign(st3,"eyes the fearsome "+g):0;break;}

/*if (==""){
(::german)?AISign.BuildSign(st,f+" "):AISign.BuildSign(st,f+" ");
(::german)?AISign.BuildSign(st2,""):AISign.BuildSign(st2,"");break;}
*/
}
}
}
::mille++;
}
}
		this.FLOAT = ((AICompany.GetMaxLoanAmount()/10+AICompany.GetCompanyValue(AICompany.COMPANY_SELF)*(::vc/10000))+((::major>1||(::major==1)&&::minor>=2)?AIInfrastructure.GetMonthlyInfrastructureCosts(AICompany.COMPANY_SELF,AIInfrastructure.INFRASTRUCTURE_ROAD):0)).tointeger();
		this.MMM = 0;

                 // Minimum amount of money to keep at all times
		AICompany.SetAutoRenewMoney(this.FLOAT*2);
		FinanceManager.MaintainFunds(this.FLOAT);
		
		// Check for events


		this.HandleEvents();

if (AIDate.GetCurrentDate()-::upd>27){
::upd=AIDate.GetCurrentDate();
this.CloneVehicles()
if(!::stmsg.IsEmpty())::stmsg.RemoveBelowValue(AIDate.GetCurrentDate()-27);
}
::hq=PathZilla.GetSetting("hq");
if (PathZilla.GetSetting("language")==1){
::german=false;
}else if (PathZilla.GetSetting("language")==2){
::german=true;
}
if (::hq==1&&!AISignList().IsEmpty()){
foreach(sign,_ in AISignList())AISign.RemoveSign(sign);
}else if(::hq==0&&!AISignList().IsEmpty()){
local czi=0;
local sgn=AISignList();
for (local cpy=AICompany.ResolveCompanyID(0);czi<255;cpy=AICompany.ResolveCompanyID(czi++)){
if (cpy!=AICompany.COMPANY_INVALID){
local chq=AICompany.GetCompanyHQ(cpy);
if (chq!=AIMap.TILE_INVALID){
foreach(sign,_ in AISignList()){
if (AISign.GetLocation(sign)==chq||AISign.GetLocation(sign)==AIMap.GetTileIndex(AIMap.GetTileX(chq)+1,AIMap.GetTileY(chq)+1)||AISign.GetLocation(sign)==AIMap.GetTileIndex(AIMap.GetTileX(chq)+2,AIMap.GetTileY(chq)+2)){
local ssgn=AIList();
 ssgn.AddItem(sign,0)
ssgn.RemoveList(ssgn);
}}}}}
foreach(sign,_ in sgn)AISign.RemoveSign(sign);
}
if (AIDate.GetCurrentDate()-sserlog>366&&AIDate.GetMonth(AIDate.GetCurrentDate())>7){
local inc=0;
foreach (vehicle,_ in AIVehicleList()){
inc+=AIVehicle.GetProfitLastYear(vehicle);
if (AIVehicle.IsStoppedInDepot(vehicle)){
AIVehicle.SellVehicle(vehicle);
continue;
}
if (AIVehicle.GetProfitLastYear(vehicle)<=::vi/8&&AIVehicle.GetAge(vehicle)>1000&&AIVehicle.GetProfitThisYear(vehicle)<=::vi/8){
AIVehicle.SendVehicleToDepot(vehicle);
if(!::vehiclesToSell.HasItem(vehicle)){
::vehiclesToSell.AddItem(vehicle, 0);
}else{
(::german)?AILog.Info(  "   Fahrzeugueberwachung meldet: Fahrzeug Nr. " +AIVehicle.GetUnitNumber(vehicle)+" ist unprofitabel"):AILog.Info("   Vehicle number "+AIVehicle.GetUnitNumber(vehicle)+" didn't make profit last year");
::vehiclesToSell.AddItem(vehicle, 0);
}
if ((AIOrder.GetOrderCount(vehicle)==0||!AIOrder.IsGotoDepotOrder(vehicle,0))){
AIOrder.UnshareOrders(vehicle);
AIOrder.InsertOrder(vehicle,0,AIVehicle.GetLocation(vehicle),AIOrder.AIOF_NON_STOP_INTERMEDIATE+AIOrder.AIOF_GOTO_NEAREST_DEPOT+AIOrder.AIOF_STOP_IN_DEPOT);
}else{
AIVehicle.ReverseVehicle(vehicle);
if (AIOrder.GetOrderFlags(vehicle,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)){
AIVehicle.SendVehicleToDepot(vehicle);
}
}}
}
sserlog=AIDate.GetDate(AIDate.GetYear(sserlog)+1,9,1);
::vi=(inc/(::vc+1)*2/3).tointeger();
}
if (AIDate.GetCurrentDate()-serlog>366){
local dsr=AIDate.GetCurrentDate();
local slist=this.serviceManager.GetServices();
local list=AIList();
local i=0;
foreach (service in slist){
local oserv=0;
local sell=0;
i++;
local profit=0;
if (service.GetActualFleetSize()>0){
local vz=0;
local maxprof=-1;
local maxa=0;
foreach (v,_ in service.GetVehicles()){
maxa=max(AIVehicle.GetAge(v),maxa);
maxprof=max(max(AIVehicle.GetProfitLastYear(v),AIVehicle.GetProfitThisYear(v)),maxprof);
vz++;
if (vz==service.GetVehicles().Count()&&maxprof<0){
local stvl=AIList();
stvl=AIStationList_Vehicle(v);
}
profit+=max(AIVehicle.GetProfitLastYear(v),AIVehicle.GetProfitThisYear(v));
if(AIVehicle.GetAge(v)>serlog-AIDate.GetDate(AIDate.GetYear(serlog)-1,1,1))oserv=1;
}
if (maxprof<=0&&maxa/2>max(100,service.GetDistance())){
(::german)?AILog.Info(  "Ein Zielpunkt existiert nicht mehr..."):AILog.Info("  Connection has an invalid target...");
this.serviceManager.SellVehicles(service,service.GetActualFleetSize());
this.serviceManager.DeleteService(service);
}
if (oserv==1)list.AddItem(i,profit);
}
}
list.Sort(AIAbstractList.SORT_BY_VALUE, false);
list.KeepTop(999);
list.Sort(AIAbstractList.SORT_BY_VALUE, true);

if (!list.IsEmpty())	((::german)?AILog.Error("   Gruppe   Profit  Fahrzeuge Entfernung"):AILog.Error("   Service   Profit  Vehicles  Distance"));
local iz=list.Count()+1;

::pfem=(PathZilla.GetSetting("pathfinding")+min(11,sqrt(AICompany.GetCompanyValue(AICompany.COMPANY_SELF))/900)+1).tointeger();
foreach(ii,profit in list){
for (profit=profit.tostring()+",-";profit.len()<10;profit+=" ");
iz--;
i=0;
foreach (service in slist){
local st=service+" ";
local vst=(service.GetActualFleetSize()).tostring();
for (;st.len()<31;st+=" ");
for (;vst.len()<10;vst+=" ");
i++;
if (i==ii){	      AILog.Warning(((iz>9)?((iz>99)?"":" "):"  ")+iz+"."+st+profit+vst+service.GetDistance());
break;
}
}
}
local vvlist=AIVehicleList();
			vvlist.Valuate(AIVehicle.GetProfitLastYear);
			vvlist.Sort(AIAbstractList.SORT_BY_VALUE, true);

		foreach (v,_ in vvlist){
					if (AIVehicle.IsValidVehicle(v)){
					if (AIVehicle.GetState(v)==AIVehicle.VS_STOPPED&&!AIVehicle.IsStoppedInDepot(v)){		
					AIVehicle.StartStopVehicle(v);
					continue;					
					}
					if (AIVehicle.IsStoppedInDepot(v)&&!(AIOrder.GetOrderCount(v)>0&&AIOrder.IsGotoDepotOrder(v,0))){
					local sl=false;
					if (AIOrder.GetOrderCount(v)>1){
					foreach(svc in this.serviceManager.GetServices()){					
					foreach(vs in svc.GetVehicles()){
					if (v==vs){
					sl=true;
					break;
					}
					}
					}					
					if (sl)break;
					}
					if ((AIOrder.GetOrderCount(v)>0&&AIOrder.IsGotoDepotOrder(v,0))&&(sl&&(AIVehicle.GetProfitLastYear(v)>0||AIVehicle.GetAge(v)<1000||AIVehicle.GetProfitThisYear(v)>0))){
					if(AIVehicle.GetState(v)==AIVehicle.VS_STOPPED)
if (AIVehicle.IsStoppedInDepot(v)){
AIVehicle.SellVehicle(v);
}else{
AIVehicle.StartStopVehicle(v);
}
					FinanceManager.MaintainFunds(this.FLOAT);
					
					}else if(AIVehicle.IsStoppedInDepot(v)&&((::vehiclesToSell.HasItem(v)&&::vehiclesToSell.GetValue(v)==0)||(AIVehicle.GetProfitThisYear(v)<=0&&AIVehicle.GetProfitLastYear(v)<=0&&AIVehicle.GetAge(v)>444))){
					AIVehicle.SellVehicle(v);
					FinanceManager.MaintainFunds(this.FLOAT);
					::vehiclesToSell.RemoveItem(v);
					}else{
//					if (AIOrder.IsGotoStationOrder(vh,AIOrder.ORDER_CURRENT))AIOrder.SkipToOrder(vh,(AIOrder.ORDER_CURRENT+1)%AIOrder.GetOrderCount(vh));
//					AIVehicle.ReverseVehicle(v);
//					AIVehicle.SendVehicleToDepot(v);
//					::vehiclesToSell.AddItem(v, 0);
					}
					}
					}
					}
			stlist.Clear();

				local staList=AIStationList(AIStation.STATION_BUS_STOP);
				staList.AddList(AIStationList(AIStation.STATION_TRUCK_STOP));
local vhhs=AIList();
				foreach (stdt,_ in staList){
				local vhz=0;
				local ves=-1;
local avke =AIVehicleList_Station(stdt);
local avkc=avke.Count();		
vhhs.Clear();
		foreach (vh,_ in avke){
				for(local orv=0;orv<AIOrder.GetOrderCount(vh);orv++)if (AIOrder.IsGotoStationOrder(vh,orv)&&AIOrder.GetOrderDestination(vh,orv)==AIStation.GetLocation(stdt)&&(AIOrder.GetOrderFlags(vh,orv)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)||AIOrder.GetOrderFlags(vh,orv)==AIOrder.AIOF_FULL_LOAD_ANY))ves=vh;
				if(AIMap.DistanceManhattan(AIStation.GetLocation(stdt),AIVehicle.GetLocation(vh))<6&&AIVehicle.GetCurrentSpeed(vh)*2<AIEngine.GetMaxSpeed(AIVehicle.GetEngineType(vh))){
				vhz++;
				if (ves>-1&&AIOrder.GetOrderFlags(ves,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)&&AIVehicle.GetCurrentSpeed(ves)<5){
if(vhz<=3+avkc/18){
vhhs.AddItem(ves,0);
}else{
if (!vhhs.IsEmpty()){
foreach(vfz,_ in vhhs){
if(!AIVehicle.IsInDepot(vfz)){
AIVehicle.ReverseVehicle(vfz);
if (AIOrder.GetOrderFlags(vfz,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)){
AIVehicle.SendVehicleToDepotForServicing(vfz);
}
}}
vhhs.Clear();
}
if(!AIVehicle.IsInDepot(ves)){
					AIVehicle.ReverseVehicle(ves);
if (AIOrder.GetOrderFlags(ves,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)){
AIVehicle.SendVehicleToDepotForServicing(ves);
}
}
if(AIVehicle.GetAge(ves)>222&&!::stmsg.HasItem(stdt)){
::stmsg.AddItem(stdt,AIDate.GetCurrentDate());
					(::german)?AILog.Info(  "   Fahrzeugueberwachung meldet: Stau bei "+AIStation.GetName(stdt)):AILog.Info("   Vehicles are jamming at "+AIStation.GetName(stdt));
}
if(AIVehicle.GetAge(ves)>222){
foreach(c,_ in ::c){
if (AIVehicle.GetCapacity(ves,c)>0){
if (AIStation.GetCargoWaiting(stdt,c)==0&&(AICargo.HasCargoClass(c,AICargo.CC_PASSENGERS)||AICargo.HasCargoClass(c,AICargo.CC_MAIL)||AICargo.GetCargoLabel(c)=="VALU"||AIVehicle.GetCargoLoad(ves,c)*5<AIVehicle.GetCapacity(ves,c)*3)){
if ((AIOrder.GetOrderCount(ves)==0||(!AIOrder.IsGotoDepotOrder(ves,0)))&&AIVehicle.GetCargoLoad(ves,c)*3<AIVehicle.GetCapacity(ves,c)*2){
if (AIOrder.GetOrderFlags(ves,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)){
		AIVehicle.SendVehicleToDepot(ves);	
}
}	
								if(!::vehiclesToSell.HasItem(ves))::vehiclesToSell.AddItem(ves, 0);
					this.serviceManager.LockThis(ves);

}
break;
}
}

}else{
foreach(c,_ in ::c){
if (AIVehicle.GetCapacity(ves,c)>0){
if (AIStation.GetCargoWaiting(stdt,c)==0&&AIVehicle.GetCargoLoad(ves,c)*5<AIVehicle.GetCapacity(ves,c)*3){
if ((AIOrder.GetOrderCount(ves)==0||(!AIOrder.IsGotoDepotOrder(ves,0)))&&AIVehicle.GetCargoLoad(ves,c)*3<AIVehicle.GetCapacity(ves,c)*2){
if (AIOrder.GetOrderFlags(ves,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)){
		AIVehicle.SendVehicleToDepotForServicing(ves);	
}
}	
								if(!::vehiclesToSell.HasItem(ves))::vehiclesToSell.AddItem(ves, 0);
					this.serviceManager.LockThis(ves);

}
break;
}
}

}}}}}			}
			local vlist=AIVehicleList();
			
			vlist.Valuate(AIVehicle.GetProfitLastYear);
			vlist.Sort(AIAbstractList.SORT_BY_VALUE, false);
				local dplist=AIDepotList(AITile.TRANSPORT_ROAD);
				local allst=AIStationList(AIStation.STATION_BUS_STOP);
				allst.AddList(AIStationList(AIStation.STATION_TRUCK_STOP));
			foreach (v,_ in vlist){
if(AIVehicle.IsValidVehicle(v)&&(::vehiclesToSell.GetValue(v)==1&&(AIOrder.GetOrderCount(v)>0&&AIOrder.IsGotoDepotOrder(v,0)))){
local lo=-1;
local c=-1;
local g=AIVehicle.GetGroupID(v);
	foreach(service in this.serviceManager.GetServices()) {
		if (!(service.GetVehicles()).IsEmpty()&&AIVehicle.GetGroupID(service.GetVehicles().Begin())==g){
			lo=service.GetEngine();	
			c=service.GetCargo();			
break;
		}
	}
AIOrder.UnshareOrders(v);
AIOrder.RemoveOrder(v,0);
if(c!=-1&&lo!=-1&&AIEngine.IsValidEngine(lo)){
FinanceManager.EnsureFundsAvailable(PathZilla.FLOAT+AIEngine.GetPrice(lo));
if (FinanceManager.CanAfford(AIEngine.GetPrice(lo)+100)){
local nv=AIVehicle.BuildVehicle(AIVehicle.GetLocation(v),lo);
if (AIVehicle.IsValidVehicle(nv)){
AIOrder.ShareOrders(nv,v);
if (AIEngine.GetCargoType(lo) != c) AIVehicle.RefitVehicle(nv, c);
AIVehicle.StartStopVehicle(nv);
AIGroup.MoveVehicle(g,nv);
AIVehicle.SellVehicle(v);
FinanceManager.MaintainFunds(PathZilla.FLOAT);
}}}
if (AIVehicle.IsValidVehicle(v)&&AIVehicle.GetState(v)==AIVehicle.VS_STOPPED&&!AIVehicle.IsStoppedInDepot(v))					AIVehicle.StartStopVehicle(v);
}
			if (!AIVehicle.IsValidVehicle(v)||AIVehicle.GetProfitLastYear(v)<1||AIEngine.GetPrice(AIVehicle.GetEngineType(v))*2>FinanceManager.GetAvailableFunds())continue;
			local unknown=1;			
			local vc=AIEngine.GetCargoType(AIVehicle.GetEngineType(v));
				local stloc=-1;
				local station=999999;
				local depot=999999;
				for (local o=0;o<AIOrder.GetOrderCount(v);o++){
				if (AIOrder.IsValidVehicleOrder(v,o)&&station==999999&&AIOrder.IsGotoStationOrder(v,o))station=AIOrder.GetOrderDestination(v,o);
				if (AIOrder.IsValidVehicleOrder(v,o)&&depot==999999&&AIOrder.IsGotoDepotOrder(v,o))depot=AIOrder.GetOrderDestination(v,o);
				}
				if (station==999999)continue;
				allst.Valuate(AIStation.GetDistanceManhattanToTile,station);
				allst.Sort(AIAbstractList.SORT_BY_VALUE, true);
				foreach(spi,_ in allst){
				if (AIStation.GetDistanceManhattanToTile(spi,station)<2){
				unknown=0;				
				stloc=station;
				station=spi;
				}
				break;
				}
				if (unknown==1||stloc==-1||stlist.HasItem(station))continue;
				stlist.AddItem(station,0);
				dplist.Valuate(AIMap.DistanceManhattan,stloc);
				dplist.Sort(AIAbstractList.SORT_BY_VALUE, true);
				foreach(spi,entf in dplist){
				if (!AIRoad.HasRoadType(spi,AIVehicle.GetRoadType(v))) continue;
				if (depot==999999){
				if (entf>15)break;
				depot=spi;				
				unknown=2;				
				break;
				}else{
				if (spi==depot){
				unknown=1;				
				break;
				}}}
				if (::vc >= AIGameSettings.GetValue("vehicle.max_roadveh")||unknown==0||AIStation.GetCargoRating(station,vc)>63||AIStation.GetCargoWaiting(station,vc)<AIEngine.GetCapacity(AIVehicle.GetEngineType(v))*2)continue;
				local vhz=0;
				local ves=-1;
local vpg=AIVehicleList_Station(station);
vpg.Valuate(AIVehicle.GetProfitLastYear);
vpg.Sort(AIAbstractList.SORT_BY_VALUE, false);

				foreach (vh,_ in vpg){
				for(local orv=0;orv<AIOrder.GetOrderCount(vh);orv++)if (AIOrder.IsGotoStationOrder(vh,orv)&&AIOrder.GetOrderDestination(vh,orv)==AIStation.GetLocation(station)&&(AIOrder.GetOrderFlags(vh,orv)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)||AIOrder.GetOrderFlags(vh,orv)==AIOrder.AIOF_FULL_LOAD_ANY)){
if (AIVehicle.GetCargoLoad(vh,vc)>0){
ves=vh;
}else{
if (ves==-1)ves=v;
}}
				if(AIMap.DistanceManhattan(AIStation.GetLocation(station),AIVehicle.GetLocation(vh))<6&&AIVehicle.GetCurrentSpeed(vh)*2<AIEngine.GetMaxSpeed(AIVehicle.GetEngineType(vh)))vhz++;
				}
				if ((ves>-1&&AIVehicle.GetProfitLastYear(ves)>::vi&&vhz<2+(AIVehicleList_Station(station).Count()/25).tointeger())&&(unknown==1||PathWrapper.FindPath(stloc,depot, AIVehicle.GetRoadType(v), [], false, [PathWrapper.FEAT_DEPOT_ALIGN]))){
local iwh=0;
local biwa=2;
if(AIStation.GetCargoRating(station,vc)<53){
local slv=AIStationList_Vehicle(ves);
if (slv.Count()>1){
local stt1=slv.Begin();
local stt2=slv.Next();
local stei=AIVehicleList_Station(stt1);
local stzw=AIVehicleList_Station(stt2);
local iwh=0;
local bil1=AIVehicleList_Group(AIVehicle.GetGroupID(ves));
bil1.KeepList(stei);
if (stt2==station){
if (AIStation.GetCargoWaiting(stt1,vc)<55&&AIStation.GetCargoRating(stt1,vc)>55&&AIStation.GetCargoRating(stt1,vc)!=69){
biwa=0
}else if(AIStation.GetCargoRating(stt1,vc)==69){
stei.Valuate(function(b,a){return AIMap.DistanceManhattan(AIVehicle.GetLocation(b),a)},AIStation.GetLocation(stt1));
stei.KeepBelowValue(2)
if(stei.Count()>1){
biwa=0
}}
}else{
if (AIStation.GetCargoWaiting(stt2,vc)<55&&AIStation.GetCargoRating(stt2,vc)>55&&AIStation.GetCargoRating(stt2,vc)!=69){
biwa=0
}else if(AIStation.GetCargoRating(stt2,vc)==69){
stzw.Valuate(function(b,a){return AIMap.DistanceManhattan(AIVehicle.GetLocation(b),a)},AIStation.GetLocation(stt1));
stzw.KeepBelowValue(2)
if(stzw.Count()>1){
biwa=0
}}
}
if (biwa>0&&!bil1.IsEmpty()){
bil1.KeepList(stzw);
biwa=(bil1.Count()/11+2).tointeger();
if (biwa>0){
				(::german)?AILog.Info("   Fahrzeugueberwachung meldet: Brauche mehr Fahrzeuge fuer "+AIStation.GetName(station)):AILog.Info("   Need more vehicles at "+AIStation.GetName(station));
FinanceManager.EnsureFundsAvailable(AIEngine.GetPrice(AIVehicle.GetEngineType(ves))+this.FLOAT/100);
}
}}}
while (iwh<biwa){
iwh++;
			local newv=AIVehicle.CloneVehicle(depot,ves,true);
if(!AIVehicle.IsValidVehicle(newv)&&FinanceManager.GetAvailableFunds()>=this.FLOAT){
local g=AIVehicle.GetGroupID(ves);
	foreach(service in this.serviceManager.GetServices()) {
		if (!(service.GetVehicles()).IsEmpty()&&AIVehicle.GetGroupID(service.GetVehicles().Begin())==g){
local car=service.GetCargo();
local eng=this.serviceManager.SelectEngine(service.GetTargets(),car,service.GetTransportType(),service.GetSubType(),false);
if (eng!=null&&AIEngine.IsValidEngine(eng)){
newv=AIVehicle.BuildVehicle(depot,eng);
if (AIVehicle.IsValidVehicle(newv)){
if (AIEngine.GetCargoType(eng) != car)AIVehicle.RefitVehicle(newv,car);
AIOrder.ShareOrders(newv,ves);
service.AddVehicle(newv);
ves=newv;
biwa=((AICargo.GetTownEffect(car)==AICargo.TE_MAIL)?0:max(biwa,3));
break;
}}}}}

//if(AIDate.GetYear(AIDate.GetCurrentDate())-AIGameSettings.GetValue("game_creation.starting_year")<33)this.Sleep(PathZilla.NEW_VEHICLE_SPREAD_DELAY+(5-PathZilla.GetSetting("latency"))*(5-PathZilla.GetSetting("latency"))*100);
				if (AIVehicle.IsStoppedInDepot(newv))AIVehicle.StartStopVehicle(newv);
		}		}
				stlist.AddItem(station,0);
			}
		

local lser=serlog;
serlog=AIDate.GetDate(AIDate.GetYear(serlog+((AIDate.GetCurrentDate()-dsr)*15).tointeger())+1,12,31);
::report=max(0,AIDate.GetYear(serlog)-AIDate.GetYear(AIDate.GetCurrentDate()));
if (AIDate.GetYear(serlog)-AIDate.GetYear(AIDate.GetCurrentDate())>2)(::german)?AILog.Error("   Naechster Firmenbericht: "+AIDate.GetYear(serlog)):AILog.Error("   Next company report in: "+AIDate.GetYear(serlog));
}
		

		// Look for some new services that we can implement
if(AIDate.GetCurrentDate()-::lastservice>280||AIDate.GetCurrentDate()-::lastvehicle>max(88,(((::c.Count()*8)*AIMap.GetMapSize())/200000).tointeger())){
	this.schemaIndex = -1;
	this.schemas = null;
	this.schemas = {};
	this.BuildSchemas();
::lastvehicle=AIDate.GetCurrentDate();
::lastservice=AIDate.GetCurrentDate();
(::german)?AILog.Info("   Brauche neue Ziele..."):AILog.Info("   Need new targets...");
this.serviceManager.FindNewServices(3);
if (AICompany.GetMaxLoanAmount()-AICompany.GetLoanAmount()>40000)this.serviceManager.ImplementService();
}
if(::vc<6){
this.serviceManager.FindNewServices(8);
}else{
		if (this.serviceManager.potentialServices.Len()<=12||(this.serviceManager.potentialServices.Begin()).GetRawIncome()<40000||AICompany.GetMaxLoanAmount()-AICompany.GetLoanAmount()<PathZilla.FLOAT/2){
this.serviceManager.FindNewServices(4);
}}
::tt1=::tt1+5555;
		// Wait until we have a fair bit of cash before building a new line
		if((AIDate.GetCurrentDate()-startDate>88&&::vc<45)||((((ticker>60||this.serviceManager.potentialServices.Len()>240)))&&(noServices || ((AIDate.GetCurrentDate()%2==1||(AIDate.GetCurrentDate()%9<8&&AICompany.GetLoanAmount()<1)) && FinanceManager.GetAvailableFunds() >= max(80000,AICompany.GetMaxLoanAmount() / 3))))) {

		
			{
				
			local sok=false;
if (FinanceManager.GetAvailableFunds() >= max(80000,AICompany.GetMaxLoanAmount() / 3)){
			for (;!sok&&this.serviceManager.potentialServices.Len()>0;){

sok=this.serviceManager.ImplementService();
if (!sok){
this.serviceManager.FindNewServices(6);
}
AICompany.SetAutoRenewMoney(FLOAT*2);
}			if (sok)noServices = false;
		}		
		}
}
		// Advance the ticker
// Maintain existing services

if(ticker%(workInterval*(4+max(0,::report-1)*10))<=workInterval)this.serviceManager.MaintainServices();
//AILog.Info("ticker:"+ticker);
		ticker += workInterval;
if(::vc<300)		this.Sleep(1);

	}
}

/*
 * Load state and data structures from a table. This method checks a signature
 * and version number before loading, to ensure that the data being loaded is
 * compatible with this AI. The method also relies on the classes that are used
 * as data structures implementing the Unserialize method.
 */
function PathZilla::Load(version, data) {
	local dataValid = false;
::german <- false;
::tt1 <- 10000;
::tt2 <- 8888;
::stmsg<-AIList();
::D<-true;
::hq<-PathZilla.GetSetting("hq");

::pfem<-(PathZilla.GetSetting("pathfinding")+min(11,sqrt(AICompany.GetCompanyValue(AICompany.COMPANY_SELF))/900)+1).tointeger();
::mille<-0;
::upd<-AIDate.GetCurrentDate()-22;
/*::vc<-AIVehicleList().Count();
local inc=0;
foreach(v,_ in AIVehicleList())inc+=AIVehicle.GetProfitLastYear(v);
::vi<-((inc==0)?(1111):((inc/(::vc+1)*2/3).tointeger()));
::spd<-168;

local vlist=AIVehicleList();
if (!vlist.IsEmpty()){
vlist.Valuate(AIVehicle.GetCurrentSpeed);
vlist.Sort(AIAbstractList.SORT_BY_VALUE, false);
::spd=max(::spd,(vlist.GetValue(vlist.Begin()))*3);
}
*/
	
	// First check that the data is for this AI, and this version
	if(SRLZ_IDENT in data) {
		if(typeof data[SRLZ_IDENT] == typeof PZ_IDENT) {
			dataValid = (data[SRLZ_IDENT] == PZ_IDENT) && (version <= PZ_VERSION);
		}
	}
	
	// If the data is not valid, do not try to load
	if(!dataValid) {
(::german)?AILog.Error("Spielstand benoetigt Version "+ version+" zum Laden."):AILog.Error("Save data was created with version "+version);
		return false;
	}

	this.loaded = true;
	::loadData <- data;
::report<-this.ticker%33;
::major<-((AIController.GetVersion()).tointeger()-(AIController.GetVersion()).tointeger()%268435456).tointeger()/268435456;
::minor<-(((AIController.GetVersion()).tointeger()-(AIController.GetVersion()).tointeger()%16777216).tointeger()-::major*268435456)/16777216;
::depotList<- AIList();
::tileList<- AIList();
::etarget<-{};
}

/*
 * Save state and data structures to a table for the game to persist. This 
 * method relies on the classes that are used as data structures implementing
 * the Serialize method.
 */
function PathZilla::Save() {
	local data = {};
	
	// Store the ident
	data[SRLZ_IDENT] <- PZ_IDENT;
	
	// Store the global variables
data[SRLZ_TRAFFIC_BLACKSPOTS] <- ListToArray(::trafficBlackSpots);
data[SRLZ_VEHICLES_TO_SELL] <- ListToArray(::vehiclesToSell); 

	// Store the basic data
	data[SRLZ_STOP] <- this.stop;
	data[SRLZ_COMPANY_NAME] <- this.companyName;
	data[SRLZ_HOME_TOWN] <- this.homeTown;
	data[SRLZ_TICKER] <- this.ticker*33+::report;
	
	// Store the schemas
	data[SRLZ_SCHEMA_IDX] <- this.schemaIndex;
	data[SRLZ_SCHEMAS] <- {};
	foreach(idx, schema in this.schemas) {
		data[SRLZ_SCHEMAS][idx] <- schema.Serialize();
	}

	// Store the service manager, if it has been set
	if(this.serviceManager != null) {
		data[SRLZ_SRVC_MANAGER] <- this.serviceManager.Serialize();
	}

	
	return data;
}

/*
 * Initialise the state of the AI, either from saved state or from scratch.
 */
function PathZilla::Initialise() {
	// Enable auto-renew
	AICompany.SetAutoRenewStatus(true);
	
	// Set the service manager
	this.serviceManager = ServiceManager();

	// If there is data to load then use it, otherwise start from scratch
	if(this.loaded) {
		// Load some global variables
		::trafficBlackSpots <- ArrayToList(::loadData[SRLZ_TRAFFIC_BLACKSPOTS]); 
		::vehiclesToSell <- ArrayToList(::loadData[SRLZ_VEHICLES_TO_SELL]); 

		// Load the basic data
		this.stop = ::loadData[SRLZ_STOP];
		this.homeTown = ::loadData[SRLZ_HOME_TOWN];
		this.companyName = ::loadData[SRLZ_COMPANY_NAME];

		// Load the schemas
		this.schemaIndex = ::loadData[SRLZ_SCHEMA_IDX];
		foreach(idx, schemaData in ::loadData[SRLZ_SCHEMAS]) {
			this.schemas[idx] <- Schema.instance();
			this.schemas[idx].Unserialize(schemaData);
		}
/*
		this.schemaIndex = -1;
		this.BuildSchemas();
*/
		// Load the service manager, if it was saved
		if(SRLZ_SRVC_MANAGER in ::loadData) {
			this.serviceManager.Unserialize(::loadData[SRLZ_SRVC_MANAGER]);
		}

		// Load the vehicles into their groups
		this.serviceManager.PostLoad();

	} else {
		// Initialise some global variables
//		::trafficBlackSpots <- AIList();
//		::vehiclesToSell <- AIList();

		// Set the basic data
		this.stop = false;
		this.homeTown = this.SelectHomeTown();
		this.companyName = this.ChooseName();

		// Build the schemas
		this.schemaIndex = -1;
		this.BuildSchemas();
	
	}
	
	// Set the company name
	AICompany.SetName(trnc(this.companyName));
}

/*
 * Build a series of schemas based on the cargos, towns, and industries 
 * available in the map.
 */
function PathZilla::BuildSchemas(z=false) {

	// Add passenger schemas by road and tram
	local last=0;
	local townList = AIList();
	local tramList = AIList();
	// Check each available cargo
	foreach(cargo, _ in AICargoList()) {
		// Get the amount of this cargo produced in towns
		local townprod = 0;
local lim=0;
foreach(town, _ in AITownList()) {
	townprod += AITown.GetMaxProduction(town, cargo);
if (lim++>100)break;
		}
		
		// Check if there are any trams that can carry the cargo
		local tramable = false;
		foreach(engine, _ in AIEngineList(AIVehicle.VT_ROAD)) {
			if(AIEngine.GetRoadType(engine) == AIRoad.ROADTYPE_TRAM && AIEngine.CanRefitCargo(engine, cargo)) {
				tramable = true;
				break;
			}
		}
		
		// If the cargo is produced in towns and has a town effect, use it in 
		// the town schema
		if(townprod > 0 && (AICargo.HasCargoClass(cargo, AICargo.CC_PASSENGERS)||AICargo.GetTownEffect(cargo) != AICargo.TE_NONE)) {
			townList.AddItem(cargo, 0);
		
}
		
		// If a cargo can be carried by tram and has is of the passenger class,
		// add it to the tram schema
		if(tramable && AICargo.HasCargoClass(cargo, AICargo.CC_PASSENGERS)) {
			tramList.AddItem(cargo, 0);
		}
	}
	
	// Add the town schema
local add=AIList();
townList.Valuate(AICargo.GetCargoIncome,100,50);
			townList.Sort(AIAbstractList.SORT_BY_VALUE, false);
	foreach(c,_ in townList){
			
	add.AddItem(c,0);	
	
	}
last++;	
if (!z) this.AddSchema(Schema(this.homeTown, add, AITile.TRANSPORT_ROAD, AIRoad.ROADTYPE_ROAD));
	add=null;
	// Add the tram schema, if they are supported
	if(AIRoad.IsRoadTypeAvailable(AIRoad.ROADTYPE_TRAM)){
	 if (!z)this.AddSchema(Schema(this.homeTown, tramList, AITile.TRANSPORT_ROAD, AIRoad.ROADTYPE_TRAM));
	last++;
	}
	// Check each available industry type
	foreach(type, _ in AIIndustryTypeList()) {

		// Only add support raw industries taht are not on water
		if(/*AIIndustryType.IsRawIndustry(type) &&*/ !AIIndustryType.IsBuiltOnWater(type)) {
			// Only transport those cargos from this industry that have no town
			// effect, i.e. dont carry passengers from oil rigs, etc...
			local cargos = AIIndustryType.GetProducedCargo(type);
			cargos.Valuate(AICargo.GetCargoIncome,100,50);
			cargos.Sort(AIAbstractList.SORT_BY_VALUE, false);
			
			// Add the schema
	foreach(c,_ in cargos){
local na=true;
local cst=-1;
local d=true;
for(local sc=this.GetNextSchema();;){
if (cst==sc.GetId())break;
if (cst==-1)cst=sc.GetId();
foreach(cg,_ in sc.cargos){
if (cg==c) na=false;
}
}
if (na){
	local add=AIList();
	add.AddItem(c,0);	
	if (!z)this.AddSchema(Schema(this.homeTown, add, AITile.TRANSPORT_ROAD, AIRoad.ROADTYPE_ROAD));
	last++;
	add=null;
	}
	}		

	}
	}
return last;
}

/*
 * Chooses a company name that does not already exist and returns it. The name
 * must be applied in exec mode separately.
 */
function PathZilla::ChooseName() {
	{
local n=AICompany.GetName(AICompany.COMPANY_SELF);
local str="";
for (local a=0;a<min(n.len(),10);a++){
str=str+(n[a]).tochar();
}
		local _ = AITestMode();
if (str=="RoadRunner") return n;
		local i = 1;
		local name = "";
		
		do {
			if (i==1){
			name = "RoadRunner";
}else{
			name = "RoadRunner #" + i;
}
			i++;
		} while(!AICompany.SetName(trnc(name)));
		
		return name;
	}
}

/*
 * Randomly choose a large town from the top 10 percentile by popuation.
 */
function PathZilla::SelectHomeTown() {
	// Get a list of towns by population
	local towns = AITownList();
	towns.Valuate(AITown.GetPopulation);

	// Remove all but the larges
	local upperLimit = AITown.GetPopulation(towns.Begin());
	local lowerLimit = (upperLimit * 5) / 10;
	towns.RemoveBelowValue(lowerLimit);
	
	// Find towns that have no competitors in them
	foreach(town, _ in towns) {
		// Get a list of tiles to search in
		local townTile = AITown.GetLocation(town);
		local searchRadius = min(AIMap.DistanceFromEdge(townTile) - 1, PathZilla.MAX_TOWN_RADIUS);
		local offset = AIMap.GetTileIndex(searchRadius, searchRadius);
		local tileList = AITileList();
		tileList.AddRectangle(townTile - offset, townTile + offset);
		tileList.Valuate(AITile.IsStationTile);
		tileList.RemoveValue(0);
		towns.SetValue(town, (tileList.IsEmpty()) ? 1 : 0);
	}
	towns.RemoveValue(0);
	
	// If there are no empty towns, just reset the list
	if(towns.IsEmpty()) {
		towns = AITownList();
		towns.Valuate(AITown.GetPopulation);
		towns.RemoveBelowValue(lowerLimit);
	}

	// Select a random town from remaining ones
	towns.Valuate(AIBase.RandItem);
	return towns.Begin();
}

/*
 * Handle any waiting events. This is a place-holder implementation for now!
 */
function PathZilla::HandleEvents(a=false) {
local evt=0;
local oz=0;
local evtz=0;
	while(AIEventController.IsEventWaiting()/*&&evtz++<99*/) {
		local event = AIEventController.GetNextEvent();
		switch(event.GetEventType()) {
			case AIEvent.AI_ET_INDUSTRY_OPEN:
				if (AICompany.GetLoanAmount()<=AICompany.GetMaxLoanAmount()-100000&&::vc>0&&oz==0&&!a){
				this.serviceManager.targetsConsidered.Clear();
				oz=1;
				local open=(AIEventIndustryOpen.Convert(event)).GetIndustryID();
				if (AIIndustryType.IsValidIndustryType(open)&&!AIIndustryType.IsBuiltOnWater(AIIndustry.GetIndustryType(open))){
				local log=0
				local ez=0;
				for(;ez<this.schemas.len()-1;ez++) {
				local appschema=GetSchema(ez);
					if (AIIndustryType.GetProducedCargo(AIIndustry.GetIndustryType(open)).Count()!=0){					
						foreach(c,_ in AIIndustryType.GetProducedCargo(AIIndustry.GetIndustryType(open))) {
						foreach(cargo, _ in appschema.GetCargos()) {
						if (cargo==c) {
						if (log==0)(::german)?AILog.Info(AIIndustry.GetName(open)+" zur Industrieliste hinzugefuegt"):AILog.Info(AIIndustry.GetName(open)+" added to the target list.");
						log=1;
						appschema.InitialiseTargets();
						appschema.Initialise();
						}
						}
						}
					if (AIIndustryType.GetAcceptedCargo(AIIndustry.GetIndustryType(open)).Count()!=0){					
					foreach(c,_ in AIIndustryType.GetAcceptedCargo(AIIndustry.GetIndustryType(open))) {
						foreach(cargo, _ in appschema.GetCargos()) {
						if (cargo==c) {
						if (log==0)(::german)?AILog.Info(AIIndustry.GetName(open)+" zur Industrieliste hinzugefuegt"):AILog.Info(AIIndustry.GetName(open)+" added to the target list.");						log=1;
						appschema.InitialiseTargets();
						appschema.Initialise();
						}
						}
					}
					}
					}
					}
					}
				}
			break;
			case AIEvent.AI_ET_INDUSTRY_CLOSE:
				if (::vc==0) break;
				local close=(AIEventIndustryClose.Convert(event)).GetIndustryID();
				local ez=0;
				local services=this.serviceManager.GetServices();
				foreach(service in services) {					
					local tz=0;					
					foreach(target in service.GetTargets()) {					
					if ((!target.IsValid()||(!target.IsTown()&&!AIIndustry.IsValidIndustry(target.GetId())))&&service.GetActualFleetSize()>0){
					this.serviceManager.SellVehicles(service,service.GetActualFleetSize());
					this.serviceManager.DeleteService(service);
					break;
					}
					}
				}
				
				for(ez=0;ez<this.schemas.len()-1;ez++) {
				local appschema=GetSchema(ez);
				local cargo=appschema.GetCargos().Begin();
					if (AIIndustryType.IsValidIndustryType(AIIndustry.GetIndustryType(close))){	
					foreach(c,_ in AIIndustryType.GetProducedCargo(AIIndustry.GetIndustryType(close))) {
					foreach(cargo, _ in appschema.GetCargos()) {
						if (cargo==c) {
					foreach(target in appschema.GetTargets()){
					if (!target.IsValid()){
					this.serviceManager.TargetClosed(target);
						}}}}}
					
					}
					if (AIIndustryType.IsValidIndustryType(AIIndustry.GetIndustryType(close))){
					foreach(c,_ in AIIndustryType.GetAcceptedCargo(AIIndustry.GetIndustryType(close))) {
						foreach(cargo, _ in appschema.GetCargos()) {
						if (cargo==c) {
					foreach(target in appschema.GetTargets()){
					if (!target.IsValid()){
					this.serviceManager.TargetClosed(target);
						}}}}}}
				}
				break;
			case AIEvent.AI_ET_ENGINE_PREVIEW:
				evt = AIEventEnginePreview.Convert(event);
				evt.AcceptPreview();
				break;
			case AIEvent.AI_ET_ENGINE_AVAILABLE:
				local log=0;
				evt=(AIEventEngineAvailable.Convert(event)).GetEngineID();
				local slist=this.serviceManager.GetServices();
				if (AIEngine.GetVehicleType(evt)==AIVehicle.VT_ROAD){
				local speed=AIEngine.GetMaxSpeed(evt);
				::spd=max(::spd,speed*3);
				foreach (service in slist){
				if (service.IsValid()&&(service.GetCargo()==AIEngine.GetCargoType(evt)||AIEngine.CanRefitCargo(evt,service.GetCargo()))&&service.GetSubType()==AIEngine.GetRoadType(evt)){
				foreach (vehicle,_ in service.GetVehicles()){
				if (((AIVehicle.IsValidVehicle(vehicle)&&AIEngine.GetMaxSpeed(AIVehicle.GetEngineType(vehicle))<speed&&AIEngine.GetMaxSpeed(AIVehicle.GetEngineType(vehicle))<speed*AIEngine.GetCapacity(evt)/AIEngine.GetCapacity(AIVehicle.GetEngineType(vehicle)))&&AIEngine.GetCapacity(evt)*3>AIEngine.GetCapacity(AIVehicle.GetEngineType(vehicle))*2)&&this.serviceManager.SelectEngine(service.GetTargets(), service.GetCargo(), service.GetTransportType(), service.GetSubType(), false,true)==evt){
				if (log==0){
				(::german)?AILog.Warning("  Fahrzeugtyp "+AIEngine.GetName(AIVehicle.GetEngineType(vehicle))+" wird durch "+AIEngine.GetName(evt)+" ersetzt."):AILog.Warning("  Replace vehicle type "+AIEngine.GetName(AIVehicle.GetEngineType(vehicle))+" with "+AIEngine.GetName(evt)+".");
				log=1;
				}

local zns=0;
service.SetEngine(evt);
local aivl=AIList();
local aisl=AIList();
foreach (vhcl,_ in service.GetVehicles())if (AIVehicle.GetEngineType(vhcl)==AIVehicle.GetEngineType(vehicle))aivl.AddItem(vhcl,AIVehicle.GetProfitLastYear(vhcl)+AIVehicle.GetProfitThisYear(vhcl));
local need=1+max(2,(aivl.Count()*AIEngine.GetCapacity(AIVehicle.GetEngineType(vehicle))/AIEngine.GetCapacity(evt)*AIEngine.GetMaxSpeed(AIVehicle.GetEngineType(vehicle))/AIEngine.GetMaxSpeed(evt)).tointeger());
FinanceManager.EnsureFundsAvailable(need*AIEngine.GetPrice(evt)+1111);
local can=max(0,(min(need,(FinanceManager.GetAvailableFunds()/AIEngine.GetPrice(evt)).tointeger()-1)));
aivl.Sort(AIAbstractList.SORT_BY_VALUE, false);
aisl.AddList(aivl);
aisl.KeepBottom(aivl.Count()-can-((need-can)*aivl.Count()/need).tointeger());
aivl.KeepTop(can);
if (aivl.Count()==0)break;
foreach(v,_ in aivl){
if (AIOrder.GetOrderCount(v)==0||!AIOrder.IsGotoDepotOrder(v,0)){
AIOrder.UnshareOrders(v);
AIOrder.InsertOrder(v,0,AIVehicle.GetLocation(v),AIOrder.AIOF_NON_STOP_INTERMEDIATE+AIOrder.AIOF_GOTO_NEAREST_DEPOT+AIOrder.AIOF_STOP_IN_DEPOT);
}
		::vehiclesToSell.AddItem(v, 1);
}
foreach(vehicle,_ in aisl){

		AIVehicle.SendVehicleToDepot(vehicle);
		AIVehicle.ReverseVehicle(vehicle);
						if(!::vehiclesToSell.HasItem(vehicle))::vehiclesToSell.AddItem(vehicle, 0);
}
break;

/*				local stations=0;
				foreach(target in service.GetTargets()) {
				stations+=(RoadManager.GetStations(target, service.GetCargo(), service.GetSubType())).Count();
				}
				service.SetEngine(evt);
				local px=service.GetActualFleetSize();
if (stations==0) stations=1;
				local pnum=max(1,((2*px)/((stations>2)?4:1)/stations).tointeger());
				this.serviceManager.SellVehicles(service,px,false,true);
				for(local pp=0;pp<px;pp+=pnum)this.serviceManager.CreateFleet(service,false,pnum);
				break;				
*/


				}
				}
				}
				}
				}
			break;
			case AIEvent.AI_ET_COMPANY_IN_TROUBLE:
				if (a) break;
				local com = AIEventCompanyInTrouble.Convert(event).GetCompanyID();
				if (com==AICompany.COMPANY_SELF){
				this.serviceManager.SaveMoney();
				}
			break;
			case AIEvent.AI_ET_VEHICLE_WAITING_IN_DEPOT:
				local evt = AIEventVehicleWaitingInDepot.Convert(event);
				local vehicle = evt.GetVehicleID();
				
				// If the vehicle exists and need to be sold, sell it
				if(::vehiclesToSell.HasItem(vehicle)&&::vehiclesToSell.GetValue(vehicle)==0) {
					AIVehicle.SellVehicle(vehicle);
					FinanceManager.MaintainFunds(PathZilla.FLOAT);
					::vehiclesToSell.RemoveItem(vehicle);
								}else if(::vehiclesToSell.GetValue(vehicle)==1&&(AIVehicle.IsValidVehicle(vehicle)&&AIOrder.GetOrderCount(vehicle)>0&&AIOrder.IsGotoDepotOrder(vehicle,0))){
local lo=-1;
local c=-1;
local g=AIVehicle.GetGroupID(vehicle);
	foreach(service in this.serviceManager.GetServices()) {
		if (!(service.GetVehicles()).IsEmpty()&&AIVehicle.GetGroupID(service.GetVehicles().Begin())==g){
			lo=service.GetEngine();	
			c=service.GetCargo();			
break;
		}
	}
AIOrder.UnshareOrders(vehicle);
AIOrder.RemoveOrder(vehicle,0);
if(c!=-1&&lo!=-1&&AIEngine.IsValidEngine(lo)){
FinanceManager.EnsureFundsAvailable(PathZilla.FLOAT+AIEngine.GetPrice(lo));
if (FinanceManager.CanAfford(AIEngine.GetPrice(lo)+100)){
local nv=AIVehicle.BuildVehicle(AIVehicle.GetLocation(vehicle),lo);
if (AIVehicle.IsValidVehicle(nv)){
AIOrder.ShareOrders(nv,vehicle);
if (AIEngine.GetCargoType(lo) != c) AIVehicle.RefitVehicle(nv, c);
AIVehicle.StartStopVehicle(nv);
AIGroup.MoveVehicle(g,nv);
AIVehicle.SellVehicle(vehicle);
FinanceManager.MaintainFunds(PathZilla.FLOAT);
}}}
if (AIVehicle.IsValidVehicle(vehicle))					AIVehicle.StartStopVehicle(vehicle);
::vehiclesToSell.RemoveItem(vehicle);
if(AIVehicle.IsStoppedInDepot(vehicle))AIVehicle.SellVehicle(vehicle);

			break;
		}}
	}
}

/*
 * Get the network schema with the specified id.
 */
function PathZilla::GetSchema(schemaId) {
	return this.schemas[schemaId];
}

/*
 * Increment the internal schema counter and return the schema with that
 * index. This is used to cycle through schemas in a stateless fashion.
 */
function PathZilla::GetNextSchema() {
	if(++this.schemaIndex >= this.schemas.len()) this.schemaIndex = 1; 
	return this.schemas[this.schemaIndex];
}


function PathZilla::CloneVehicles(fast=false) {
if (fast){
if (AIDate.GetCurrentDate()-::upd<11)return false;
::upd=AIDate.GetCurrentDate();
}
			local vlist=AIVehicleList();
			vlist.Valuate(AIVehicle.GetProfitLastYear);
			vlist.Sort(AIAbstractList.SORT_BY_VALUE, false);

				local dplist=AIDepotList(AITile.TRANSPORT_ROAD);
				local allst=AIStationList(AIStation.STATION_BUS_STOP);
				allst.AddList(AIStationList(AIStation.STATION_TRUCK_STOP));
			
if(::vc < AIGameSettings.GetValue("vehicle.max_roadveh")){
local stlist=AIList();
			foreach (v,_ in vlist){
			if (!AIVehicle.IsValidVehicle(v)||AIVehicle.GetProfitLastYear(v)<1||AIEngine.GetPrice(AIVehicle.GetEngineType(v))*2>FinanceManager.GetAvailableFunds())continue;
			local unknown=1;			
			local vc=AIEngine.GetCargoType(AIVehicle.GetEngineType(v));
				local station=999999;
				local depot=999999;
				local stloc=-1;
				for (local o=0;o<AIOrder.GetOrderCount(v);o++){
				if (AIOrder.IsValidVehicleOrder(v,o)&&station==999999&&AIOrder.IsGotoStationOrder(v,o))station=AIOrder.GetOrderDestination(v,o);
				if (AIOrder.IsValidVehicleOrder(v,o)&&AIOrder.IsGotoDepotOrder(v,o))depot=AIOrder.GetOrderDestination(v,o);
				}
				if (station==999999)continue;
				allst.Valuate(AIStation.GetDistanceManhattanToTile,station);
				allst.Sort(AIAbstractList.SORT_BY_VALUE, true);
				foreach(spi,_ in allst){
				if (AIStation.GetDistanceManhattanToTile(spi,station)<2){
				unknown=0;				
				stloc=station;
				station=spi;
				}
				break;
				}
				if (unknown==1||stloc==-1||stlist.HasItem(station))continue;
				stlist.AddItem(station,0);
				dplist.Valuate(AIMap.DistanceManhattan,stloc);
				dplist.Sort(AIAbstractList.SORT_BY_VALUE, true);
				foreach(spi,entf in dplist){
				if (!AIRoad.HasRoadType(spi,AIVehicle.GetRoadType(v))) continue;
				if (depot==999999){
				if (entf>15)break;
				depot=spi;				
				break;
				unknown=2;				
				}else{
				if (spi==depot){
				unknown=1;				
				break;
				}}}
				if (unknown==0||AIStation.GetCargoRating(station,vc)>63||AIStation.GetCargoWaiting(station,vc)<AIEngine.GetCapacity(AIVehicle.GetEngineType(v))*2)continue;
				local vhz=0;
				local ves=-1;
local vpg=AIVehicleList_Station(station);
vpg.Valuate(AIVehicle.GetProfitLastYear);
vpg.Sort(AIAbstractList.SORT_BY_VALUE, false);

				foreach (vh,_ in vpg){
				for(local orv=0;orv<AIOrder.GetOrderCount(vh);orv++)if (AIOrder.IsGotoStationOrder(vh,orv)&&AIOrder.GetOrderDestination(vh,orv)==AIStation.GetLocation(station)&&(AIOrder.GetOrderFlags(vh,orv)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)||AIOrder.GetOrderFlags(vh,orv)==AIOrder.AIOF_FULL_LOAD_ANY)){
if (AIVehicle.GetCargoLoad(vh,vc)>0){
ves=vh;
}else{
if (ves==-1)ves=v;
}}
				if(AIMap.DistanceManhattan(AIStation.GetLocation(station),AIVehicle.GetLocation(vh))<6&&AIVehicle.GetCurrentSpeed(vh)*2<AIEngine.GetMaxSpeed(AIVehicle.GetEngineType(vh)))vhz++;
				}
				if ((ves>-1&&AIVehicle.GetProfitLastYear(ves)>::vi&&vhz<2+(AIVehicleList_Station(station).Count()/25).tointeger())&&(unknown==1||PathWrapper.FindPath(stloc,depot, AIVehicle.GetRoadType(v), [], false, [PathWrapper.FEAT_DEPOT_ALIGN]))){
local biwa=2;
local iwh=0;
if(AIStation.GetCargoRating(station,vc)<53){
local slv=AIStationList_Vehicle(ves);
if (slv.Count()>1){
local stt1=slv.Begin();
local stt2=slv.Next();
local stei=AIVehicleList_Station(stt1);
local stzw=AIVehicleList_Station(stt2);
local bil1=AIVehicleList_Group(AIVehicle.GetGroupID(ves));
bil1.KeepList(stei);
if (stt2==station){
if (AIStation.GetCargoWaiting(stt1,vc)<55&&AIStation.GetCargoRating(stt1,vc)>55&&AIStation.GetCargoRating(stt1,vc)!=69){
biwa=0
}else if(AIStation.GetCargoRating(stt1,vc)==69){
stei.Valuate(function(b,a){return AIMap.DistanceManhattan(AIVehicle.GetLocation(b),a)},AIStation.GetLocation(stt1));
stei.KeepBelowValue(2)
if(stei.Count()>1){
biwa=0
}}
}else{
if (AIStation.GetCargoWaiting(stt2,vc)<55&&AIStation.GetCargoRating(stt2,vc)>55&&AIStation.GetCargoRating(stt2,vc)!=69){
biwa=0
}else if(AIStation.GetCargoRating(stt2,vc)==69){
stzw.Valuate(function(b,a){return AIMap.DistanceManhattan(AIVehicle.GetLocation(b),a)},AIStation.GetLocation(stt1));
stzw.KeepBelowValue(2)
if(stzw.Count()>1){
biwa=0
}}
}
if (biwa>0&&!bil1.IsEmpty()){
bil1.KeepList(stzw);
biwa=(bil1.Count()/11+2).tointeger();
}}}
if (biwa>0){
				(::german)?AILog.Info("   Fahrzeugueberwachung meldet: Brauche mehr Fahrzeuge fuer "+AIStation.GetName(station)):AILog.Info("   Need more vehicles at "+AIStation.GetName(station));
FinanceManager.EnsureFundsAvailable(AIEngine.GetPrice(AIVehicle.GetEngineType(ves)*3)+this.FLOAT+9999);
}
while (iwh<biwa){
iwh++;

			local newv=AIVehicle.CloneVehicle(depot,ves,true);
if(!AIVehicle.IsValidVehicle(newv)&&FinanceManager.GetAvailableFunds()>=this.FLOAT){
local g=AIVehicle.GetGroupID(ves);
	foreach(service in this.serviceManager.GetServices()) {
		if (!(service.GetVehicles()).IsEmpty()&&AIVehicle.GetGroupID(service.GetVehicles().Begin())==g){
local car=service.GetCargo();
local eng=this.serviceManager.SelectEngine(service.GetTargets(),car,service.GetTransportType(),service.GetSubType(),false);
if (eng!=null&&AIEngine.IsValidEngine(eng)){
newv=AIVehicle.BuildVehicle(depot,eng);
if (AIVehicle.IsValidVehicle(newv)){
if (AIEngine.GetCargoType(eng) != car)AIVehicle.RefitVehicle(newv,car);
AIOrder.ShareOrders(newv,ves);
service.AddVehicle(newv);
ves=newv;
biwa=((AICargo.GetTownEffect(car)==AICargo.TE_MAIL)?0:max(biwa,3));
break;
}}}}}

if(AIDate.GetYear(AIDate.GetCurrentDate())-AIGameSettings.GetValue("game_creation.starting_year")<33)this.Sleep(PathZilla.NEW_VEHICLE_SPREAD_DELAY+(5-PathZilla.GetSetting("latency"))*(5-PathZilla.GetSetting("latency"))*100);
				if (AIVehicle.IsStoppedInDepot(newv))AIVehicle.StartStopVehicle(newv);
		}		}
				stlist.AddItem(station,0);
			}}
}


/*
 * Add a new network schema to them main table and give it an id.
 */
function PathZilla::AddSchema(schema,prov=1) {
	local schemaId = this.schemas.len();
if (schemaId==0){
	schema.SetId(schemaId);
	this.schemas[schemaId] <- schema;
schemaId++;
	schema.SetId(schemaId);
	return this.schemas[schemaId]<-this.schemas[0];
	return schemaId;
}
	if (prov==0)schemaId = 0;
	schema.SetId(schemaId);
	return this.schemas[schemaId] <- schema;
	return schemaId;
}

