/*
 *	Copyright  2008 George Weller
 *	
 *	This file is part of PathZilla.
 *	
 *	PathZilla is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 2 of the License, or
 *	(at your option) any later version.
 *	
 *	PathZilla is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Publ<ic License
 *	along with PathZilla.  If not, see <http://www.gnu.org/licenses/>.
 *
 * RoadManager.nut
 * 
 * Handles all road-based construction functions.
 * 
 * Author:  George Weller (Zutty)
 * Created: 27/07/2008
 * Version: 1.1
 */

class RoadManager {
	constructor() {
	}
}

/*
 * Build the required infrastructure for the specified service in the specified
 * schema. Stations will be built if necessary, then a road found between the 
 * stations, and finally depots will be built if necessary. The supplied set 
 * targetsUpdated will be updated with targets that were modified in the 
 * operation.
 */
function RoadManager::BuildInfrastructure(service, schema, targetsUpdated,station=true,ind=false,tg=-1,tgg=-1) {


station=true;
if (!service.IsValid())return false;
if (tg==-1) {
tg=service.GetTargets()[0];
tgg=service.GetTargets()[1];
}

		//sub pathfinder:
local stowns=AIList();
local fl=true;
local owater=80;
local subs=null;
local subb=false;
local pathb=null;
(::pz.schemas[0]).targets=null;			
::pz.AddSchema(Schema(::pz.homeTown, (pz.GetSchema(service.GetSchemaId())).GetCargos(), AITile.TRANSPORT_ROAD, AIRoad.ROADTYPE_ROAD),0);
local subschema=schema;
if (station){
subschema=::pz.schemas[0];
subschema.AddTarget(tg);
subschema.AddTarget(tgg);
}
/*local fromTile=(service.GetTargets()[0]).GetTile();
local toTile=(service.GetTargets()[1]).GetTile();
*/
local floc=(service.GetTargets()[0]).GetLocation();
local tloc=(service.GetTargets()[1]).GetLocation();

local success = true;
local qba=false;
local aw=(3+((AIMap.DistanceManhattan(floc,tloc)-((AIMap.DistanceManhattan(floc,tloc)*min(abs(AIMap.GetTileX(floc)-AIMap.GetTileX(tloc)),abs(AIMap.GetTileY(floc)-AIMap.GetTileY(tloc))))/(max(abs(AIMap.GetTileX(floc)-AIMap.GetTileX(tloc)),abs(AIMap.GetTileY(floc)-AIMap.GetTileY(tloc)))+1))))/12).tointeger();
local sub=0;
	subs=false;
if (station){

	local xmin=max(0,min(AIMap.GetTileX(floc),AIMap.GetTileX(tloc))-aw);
	local ymin=max(0,min(AIMap.GetTileY(floc),AIMap.GetTileY(tloc))-aw);
	local xmax=min(AIMap.GetMapSizeX()-2,max(AIMap.GetTileX(floc),AIMap.GetTileX(tloc))+aw);
	local ymax=min(AIMap.GetMapSizeY()-2,max(AIMap.GetTileY(floc),AIMap.GetTileY(tloc))+aw);
	local subtowns=AITownList();
	foreach(t,_ in subtowns) subtowns.SetValue(t,AIMap.GetTileX(AITown.GetLocation(t)));
	subtowns.KeepBelowValue(xmax);
	subtowns.KeepAboveValue(xmin);
	foreach(t,_ in subtowns) subtowns.SetValue(t,AIMap.GetTileY(AITown.GetLocation(t)));
	subtowns.KeepBelowValue(ymax);
	subtowns.KeepAboveValue(ymin);
local ssubtowns=AIList();
if ((service.GetTargets()[0]).GetId()>1000000)ssubtowns.AddItem((service.GetTargets()[0]).GetId()-1000000,0);
if ((service.GetTargets()[1]).GetId()>1000000)ssubtowns.AddItem((service.GetTargets()[1]).GetId()-1000000,0);
ssubtowns.RemoveList(ssubtowns);

local water=50;
local stpo=max(abs(AIMap.GetTileX(floc)-AIMap.GetTileX(tloc)),abs(AIMap.GetTileY(floc)-AIMap.GetTileY(tloc)));
local wz=1;
for (local i=2;i<=stpo&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(floc)-(AIMap.GetTileX(floc)-AIMap.GetTileX(tloc))*i/stpo).tointeger();
local wy=(AIMap.GetTileY(floc)-(AIMap.GetTileY(floc)-AIMap.GetTileY(tloc))*i/stpo).tointeger();
//if (i%10==0)AILog.Info(wx+"/"+wy+"|"+wz);
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) water=water+wz;
wz=0;
}
}
water=water+wz;
wz=0;
local wa=50;
local wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(floc,tloc)&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(floc)-((AIMap.GetTileX(floc)>AIMap.GetTileX(tloc))?min((AIMap.GetTileX(floc)-AIMap.GetTileX(tloc)),i):max((AIMap.GetTileX(floc)-AIMap.GetTileX(tloc)),0-i)));
local wy=(AIMap.GetTileY(floc)-((AIMap.GetTileY(floc)>AIMap.GetTileY(tloc))?min((AIMap.GetTileY(floc)-AIMap.GetTileY(tloc)),max(0,i-abs(AIMap.GetTileX(floc)-AIMap.GetTileX(tloc)))):max((AIMap.GetTileY(floc)-AIMap.GetTileY(tloc)),0-max(0,i-abs(AIMap.GetTileX(floc)-AIMap.GetTileX(tloc))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) wa=wa+wz;
wz=0;
}
}
wa=wa+wz;
wz=0;
water=min(water,wa);
wa=50;
wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(floc,tloc)&&wz<=10000000;i++){
local wy=(AIMap.GetTileY(floc)-((AIMap.GetTileY(floc)>AIMap.GetTileY(tloc))?min((AIMap.GetTileY(floc)-AIMap.GetTileY(tloc)),i):max((AIMap.GetTileY(floc)-AIMap.GetTileY(tloc)),0-i)));
local wx=(AIMap.GetTileX(floc)-((AIMap.GetTileX(floc)>AIMap.GetTileX(tloc))?min((AIMap.GetTileX(floc)-AIMap.GetTileX(tloc)),max(0,i-abs(AIMap.GetTileY(floc)-AIMap.GetTileY(tloc)))):max((AIMap.GetTileX(floc)-AIMap.GetTileX(tloc)),0-max(0,i-abs(AIMap.GetTileY(floc)-AIMap.GetTileY(tloc))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) wa=wa+wz;
wz=0;
}
}
wa=wa+wz;
wz=0;

owater=min(water,wa)+30;
::pz.MMM=min(30,sqrt(sqrt(owater)).tointeger());
stowns.AddList(subtowns);
foreach(t,_ in subtowns){
local tl=AITown.GetLocation(t);
local water=50;
local stpo=max(abs(AIMap.GetTileX(floc)-AIMap.GetTileX(tl)),abs(AIMap.GetTileY(floc)-AIMap.GetTileY(tl)));
local wz=1;
for (local i=2;i<=stpo&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(floc)-(AIMap.GetTileX(floc)-AIMap.GetTileX(tl))*i/stpo).tointeger();
local wy=(AIMap.GetTileY(floc)-(AIMap.GetTileY(floc)-AIMap.GetTileY(tl))*i/stpo).tointeger();
//if (i%10==0)AILog.Info(wx+"/"+wy+"|"+wz);
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) water=water+wz;
wz=0;
}
}
water=water+wz;
wz=0;
if (water<=owater)continue;
local wa=50;
local wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(floc,tl)&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(floc)-((AIMap.GetTileX(floc)>AIMap.GetTileX(tl))?min((AIMap.GetTileX(floc)-AIMap.GetTileX(tl)),i):max((AIMap.GetTileX(floc)-AIMap.GetTileX(tl)),0-i)));
local wy=(AIMap.GetTileY(floc)-((AIMap.GetTileY(floc)>AIMap.GetTileY(tl))?min((AIMap.GetTileY(floc)-AIMap.GetTileY(tl)),max(0,i-abs(AIMap.GetTileX(floc)-AIMap.GetTileX(tl)))):max((AIMap.GetTileY(floc)-AIMap.GetTileY(tl)),0-max(0,i-abs(AIMap.GetTileX(floc)-AIMap.GetTileX(tl))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) wa=wa+wz;
wz=0;
}
}
wa=wa+wz;
wz=0;
if (wa<=owater)continue;
wa=50;
wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(floc,tl)&&wz<=10000000;i++){
local wy=(AIMap.GetTileY(floc)-((AIMap.GetTileY(floc)>AIMap.GetTileY(tl))?min((AIMap.GetTileY(floc)-AIMap.GetTileY(tl)),i):max((AIMap.GetTileY(floc)-AIMap.GetTileY(tl)),0-i)));
local wx=(AIMap.GetTileX(floc)-((AIMap.GetTileX(floc)>AIMap.GetTileX(tl))?min((AIMap.GetTileX(floc)-AIMap.GetTileX(tl)),max(0,i-abs(AIMap.GetTileY(floc)-AIMap.GetTileY(tl)))):max((AIMap.GetTileX(floc)-AIMap.GetTileX(tl)),0-max(0,i-abs(AIMap.GetTileY(floc)-AIMap.GetTileY(tl))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) wa=wa+wz;
wz=0;
}
}
wa=wa+wz;
wz=0;
if (wa<=owater)continue;
stowns.RemoveItem(t);
}
subtowns.Clear();
subtowns.AddList(stowns);

foreach(t,_ in subtowns){
local tl=AITown.GetLocation(t);
local water=50;
local stpo=max(abs(AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)),abs(AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)));
local wz=1;
for (local i=2;i<=stpo&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(tl)-(AIMap.GetTileX(tl)-AIMap.GetTileX(tloc))*i/stpo).tointeger();
local wy=(AIMap.GetTileY(tl)-(AIMap.GetTileY(tl)-AIMap.GetTileY(tloc))*i/stpo).tointeger();
//if (i%10==0)AILog.Info(wx+"/"+wy+"|"+wz);
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) water=water+wz;
wz=0;
}
}
water=water+wz;
wz=0;
if (water<=owater)continue;
local wa=50;
local wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(tl,tloc)&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(tl)-((AIMap.GetTileX(tl)>AIMap.GetTileX(tloc))?min((AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)),i):max((AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)),0-i)));
local wy=(AIMap.GetTileY(tl)-((AIMap.GetTileY(tl)>AIMap.GetTileY(tloc))?min((AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)),max(0,i-abs(AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)))):max((AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)),0-max(0,i-abs(AIMap.GetTileX(tl)-AIMap.GetTileX(tloc))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) wa=wa+wz;
wz=0;
}
}
if (wa<=owater)continue;
wa=50;
wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(tl,tloc)&&wz<=10000000;i++){
local wy=(AIMap.GetTileY(tl)-((AIMap.GetTileY(tl)>AIMap.GetTileY(tloc))?min((AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)),i):max((AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)),0-i)));
local wx=(AIMap.GetTileX(tl)-((AIMap.GetTileX(tl)>AIMap.GetTileX(tloc))?min((AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)),max(0,i-abs(AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)))):max((AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)),0-max(0,i-abs(AIMap.GetTileY(tl)-AIMap.GetTileY(tloc))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) wa=wa+wz;
wz=0;
}
}
wa=wa+wz;
wz=0;
if (wa<=owater)continue;
stowns.RemoveItem(t);
}
if ((service.GetTargets()[0].IsTown()||PathZilla.GetSetting("rt_cargo_towns"))&&!stowns.IsEmpty()){
(::german)?AILog.Info(" Route fuehrt durch:"):AILog.Info(" Planing route through this cities:");
foreach (t,_ in stowns){
AILog.Info(AITown.GetName(t));
subschema.AddTarget(Target(Target.TYPE_TOWN, t+1000000));
}}}

//if (AIMap.DistanceManhattan((service.GetTargets()[0]).GetTile(),(service.GetTargets()[1]).GetTile())>45)
{
/*sub=1;
subschema.Initialise();
subs=RoadManager.BuildInfrastructure(Service(subschema.GetId(), [service.GetTargets()[0].GetId(),service.GetTargets()[1].GetId()], service.GetCargo(),service.GetTransportType(), service.GetSubType(), service.GetEngine(), service.GetDistance(), service.GetRawIncome(), service.GetCoverageTarget()),subschema, targetsUpdated,false,false,tg,tgg);
if (subs==null||subs==false||subs.GetParent()==null){
if (::pz.schemas.len()-1>=::lastschema)(::pz.schemas[::lastschema]).targets=null;
 return false;
}if (!subs){
 subs=PathWrapper.FindPath((service.GetTargets()[0]).GetTile(), (service.GetTargets()[1]).GetTile(), service.GetSubType(), [], false, [PathWrapper.FEAT_DEPOT_ALIGN]);
if (subs!=null&&subs!=false&&subs.GetParent()!=null){
 subs=PathWrapper.OptimizePath(subs,(service.GetTargets()[0]).GetTile(), (service.GetTargets()[1]).GetTile(), service.GetSubType(), [], false, [PathWrapper.FEAT_DEPOT_ALIGN]);
}
if (subs==null||subs==false||subs.GetParent()==null){
if (::pz.schemas.len()-1>=::lastschema)(::pz.schemas[::lastschema]).targets=null;
 return false;
}
subb=PathWrapper.TryBuildPath(subs, (service.GetTargets()[0]).GetTile(), (service.GetTargets()[1]).GetTile(), service.GetSubType(),[], false, [PathWrapper.FEAT_DEPOT_ALIGN]);
if (!subb||subs==null||subs==false||subs.GetParent()==null){
if (::pz.schemas.len()-1>=::lastschema)(::pz.schemas[::lastschema]).targets=null;
return false;
}
}
success=subs;
}else{
*/
	if (station){
	local xmin=max(0,min(AIMap.GetTileX(floc),AIMap.GetTileX(tloc))-aw);
	local ymin=max(0,min(AIMap.GetTileY(floc),AIMap.GetTileY(tloc))-aw);
	local xmax=min(AIMap.GetMapSizeX()-2,max(AIMap.GetTileX(floc),AIMap.GetTileX(tloc))+aw);
	local ymax=min(AIMap.GetMapSizeY()-2,max(AIMap.GetTileY(floc),AIMap.GetTileY(tloc))+aw);
	local subtowns=AIIndustryList();
	foreach(t,_ in subtowns)((AIIndustryType.IsBuiltOnWater(AIIndustry.GetIndustryType(t)))?subtowns.SetValue(t,xmax+3):subtowns.SetValue(t,AIMap.GetTileX(AIIndustry.GetLocation(t))));
	subtowns.KeepBelowValue(xmax);
	subtowns.KeepAboveValue(xmin);
	foreach(t,_ in subtowns) subtowns.SetValue(t,AIMap.GetTileY(AIIndustry.GetLocation(t)));
	subtowns.KeepBelowValue(ymax);
	subtowns.KeepAboveValue(ymin);
local ssubtowns=AIList();
	ssubtowns.AddItem((service.GetTargets()[0]).GetId(),0);
	ssubtowns.AddItem((service.GetTargets()[1]).GetId(),0);
subtowns.RemoveList(ssubtowns);
stowns.Clear();
stowns.AddList(subtowns);

foreach(t,_ in subtowns){
local tl=AIIndustry.GetLocation(t);
local water=50;
local stpo=max(abs(AIMap.GetTileX(floc)-AIMap.GetTileX(tl)),abs(AIMap.GetTileY(floc)-AIMap.GetTileY(tl)));
local wz=1;
for (local i=2;i<=stpo&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(floc)-(AIMap.GetTileX(floc)-AIMap.GetTileX(tl))*i/stpo).tointeger();
local wy=(AIMap.GetTileY(floc)-(AIMap.GetTileY(floc)-AIMap.GetTileY(tl))*i/stpo).tointeger();
//if (i%10==0)AILog.Info(wx+"/"+wy+"|"+wz);
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) water=water+wz;
wz=0;
}
}
water=water+wz;
wz=0;
if (water<=owater)continue;
local wa=50;
local wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(floc,tl)&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(floc)-((AIMap.GetTileX(floc)>AIMap.GetTileX(tl))?min((AIMap.GetTileX(floc)-AIMap.GetTileX(tl)),i):max((AIMap.GetTileX(floc)-AIMap.GetTileX(tl)),0-i)));
local wy=(AIMap.GetTileY(floc)-((AIMap.GetTileY(floc)>AIMap.GetTileY(tl))?min((AIMap.GetTileY(floc)-AIMap.GetTileY(tl)),max(0,i-abs(AIMap.GetTileX(floc)-AIMap.GetTileX(tl)))):max((AIMap.GetTileY(floc)-AIMap.GetTileY(tl)),0-max(0,i-abs(AIMap.GetTileX(floc)-AIMap.GetTileX(tl))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) wa=wa+wz;
wz=0;
}
}
if (wa<=owater)continue;
wa=50;
wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(floc,tl)&&wz<=10000000;i++){
local wy=(AIMap.GetTileY(floc)-((AIMap.GetTileY(floc)>AIMap.GetTileY(tl))?min((AIMap.GetTileY(floc)-AIMap.GetTileY(tl)),i):max((AIMap.GetTileY(floc)-AIMap.GetTileY(tl)),0-i)));
local wx=(AIMap.GetTileX(floc)-((AIMap.GetTileX(floc)>AIMap.GetTileX(tl))?min((AIMap.GetTileX(floc)-AIMap.GetTileX(tl)),max(0,i-abs(AIMap.GetTileY(floc)-AIMap.GetTileY(tl)))):max((AIMap.GetTileX(floc)-AIMap.GetTileX(tl)),0-max(0,i-abs(AIMap.GetTileY(floc)-AIMap.GetTileY(tl))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) wa=wa+wz;
wz=0;
}
}
wa=wa+wz;
wz=0;
if (wa<=owater)continue;
stowns.RemoveItem(t);
}
subtowns.Clear();
subtowns.AddList(stowns);

foreach(t,_ in subtowns){
local tl=AIIndustry.GetLocation(t);
local water=50;
local stpo=max(abs(AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)),abs(AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)));
local wz=1;
for (local i=2;i<=stpo&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(tl)-(AIMap.GetTileX(tl)-AIMap.GetTileX(tloc))*i/stpo).tointeger();
local wy=(AIMap.GetTileY(tl)-(AIMap.GetTileY(tl)-AIMap.GetTileY(tloc))*i/stpo).tointeger();
//if (i%10==0)AILog.Info(wx+"/"+wy+"|"+wz);
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) water=water+wz;
wz=0;
}
}
water=water+wz;
wz=0;
if (water<=owater)continue;
local wa=50;
local wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(tl,tloc)&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(tl)-((AIMap.GetTileX(tl)>AIMap.GetTileX(tloc))?min((AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)),i):max((AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)),0-i)));
local wy=(AIMap.GetTileY(tl)-((AIMap.GetTileY(tl)>AIMap.GetTileY(tloc))?min((AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)),max(0,i-abs(AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)))):max((AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)),0-max(0,i-abs(AIMap.GetTileX(tl)-AIMap.GetTileX(tloc))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) wa=wa+wz;
wz=0;
}
}
wa=wa+wz;
if (wa<=owater)continue;
wa=50;
wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(tl,tloc)&&wz<=10000000;i++){
local wy=(AIMap.GetTileY(tl)-((AIMap.GetTileY(tl)>AIMap.GetTileY(tloc))?min((AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)),i):max((AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)),0-i)));
local wx=(AIMap.GetTileX(tl)-((AIMap.GetTileX(tl)>AIMap.GetTileX(tloc))?min((AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)),max(0,i-abs(AIMap.GetTileY(tl)-AIMap.GetTileY(tloc)))):max((AIMap.GetTileX(tl)-AIMap.GetTileX(tloc)),0-max(0,i-abs(AIMap.GetTileY(tl)-AIMap.GetTileY(tloc))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
if (wz>0) wa=wa+wz;
wz=0;
}
}
wa=wa+wz;
wz=0;
if (wa<=owater)continue;
stowns.RemoveItem(t);
}

if (!stowns.IsEmpty()){
(::german)?AILog.Info(" Route fuehrt ueber:"):AILog.Info(" Planing route near this industries:");
foreach (t,_ in stowns){
AILog.Info(AIIndustry.GetName(t));
subschema.AddTarget(Target(Target.TYPE_INDUSTRY, t));
}
/*sub=1;
subschema.Initialise();
subs=RoadManager.BuildInfrastructure(Service(subschema.GetId(), [service.GetTargets()[0].GetId(),service.GetTargets()[1].GetId()], service.GetCargo(), service.GetTransportType(), service.GetSubType(), service.GetEngine(), service.GetDistance(), service.GetRawIncome(), service.GetCoverageTarget()), subschema, targetsUpdated,false,false,tg,tgg);
if (subs==null||subs==false||subs.GetParent()==null){
if (::pz.schemas.len()-1>=::lastschema)(::pz.schemas[::lastschema]).targets=null;
 return false;
}
if (!subs){
 subs=PathWrapper.FindPath((service.GetTargets()[0]).GetTile(), (service.GetTargets()[1]).GetTile(), service.GetSubType(), [], false, [PathWrapper.FEAT_DEPOT_ALIGN]);
if (subs!=null&&subs!=false&&subs.GetParent()!=null) {
subs=PathWrapper.OptimizePath(subs,(service.GetTargets()[0]).GetTile(), (service.GetTargets()[1]).GetTile(), service.GetSubType(), [], false, [PathWrapper.FEAT_DEPOT_ALIGN]);
}
if (subs==null||subs==false||subs.GetParent()==null){
if (::pz.schemas.len()-1>=::lastschema)(::pz.schemas[::lastschema]).targets=null;
 return false;
}
subb=PathWrapper.TryBuildPath(subs, (service.GetTargets()[0]).GetTile(), (service.GetTargets()[1]).GetTile(), service.GetSubType(),[], false, [PathWrapper.FEAT_DEPOT_ALIGN]);
if (!subb||subs==null||subs==false||subs.GetParent()==null){
if (::pz.schemas.len()-1>=::lastschema)(::pz.schemas[::lastschema]).targets=null;
 return false;
}}
success=subs;
*/
}}}

//	subschema.Initialise();

	// Set the correcy road type before starting

	AIRoad.SetCurrentRoadType(subschema.GetSubType());

local noway=0;
{{


foreach(cargo,_ in AICargoList()){
if (ServiceManager.ProvidesService(service.GetTargetIds(),cargo,service.GetTransportType(),service.GetSubType())){
noway=1;
break;}
}



/*if(AICargo.HasCargoClass(service.GetCargo(), AICargo.CC_MAIL)) {

foreach(cargo,_ in AICargoList()){

if (AICargo.HasCargoClass(cargo, AICargo.CC_PASSENGERS)){

if (ServiceManager.ProvidesService(service.GetTargetIds(),cargo,service.GetTransportType(),service.GetSubType())){
if (::pz.schemas.len()-1>=::lastschema)(::pz.schemas[::lastschema]).targets=null;
return true;
}

break;
}}}
if(AICargo.HasCargoClass(service.GetCargo(), AICargo.CC_PASSENGERS)) {

foreach(cargo,_ in AICargoList()){

if (AICargo.HasCargoClass(cargo, AICargo.CC_MAIL)){

if (ServiceManager.ProvidesService(service.GetTargetIds(),cargo,service.GetTransportType(),service.GetSubType())){
if (::pz.schemas.len()-1>=::lastschema)(::pz.schemas[::lastschema]).targets=null;
return true;
}

break;
}}}	
*/
	// Ensure the targets are connected by road

	local prev = 0;

	for(local next = 1; next < service.GetTargets().len(); next++) {
		local from = service.GetTargets()[prev];
		local to = service.GetTargets()[next];

		// Find a path through the graph
//if (station==true) subschema=pz.GetSchema(service.GetSchemaId());
((service.GetTargets()[0]).IsTown())?subschema.Initialise():subschema.Initialise((service.GetTargets()[0]).GetId());
	
local path = subschema.GetPlanGraph().FindPath(from.GetVertex(), to.GetVertex(),0);
		if(path == null) {

(::german)?AILog.Error("Kann Wegpunkte nicht miteinander verbinden!"):AILog.Error("No path could be found");
::pz.MMM=0;
return false;
		} 

				if(!from.IsValid()||!to.IsValid()) {

(::german)?AILog.Error("Ziele sind nicht erreichbar!"):AILog.Error("Targets can't be reached");
::pz.MMM=0;
return false;
		} 
		
		// Walk along the path and ensure the nodes are connected by roads
local wwg=1;
local ww=0;
local aTarget=0;
local bTarget=0;
local jp=0;
local a=0;		
local b=0;		
for(local walk = path; walk.GetParent() != null; walk = walk.GetParent()) {
fl=false;
if (jp==3){
(::german)?AILog.Error("Verbindung nicht moeglich!"):AILog.Error("Could not link");
::pz.MMM=0;
			return false;
}
			 a = ((jp>0)?a:walk.GetVertex());
			 b = (jp>1)?b:walk.GetParent().GetVertex();
			local edge = Edge(a, b);
if (jp==1)jp=0;
			// If the nodes are not connected in the actual graph a road needs to be built
if (jp==2)jp=3;

			if(ww==0||walk.GetParent()==null||!subschema.GetActualGraph().GetEdges().Contains(edge)||(subschema.GetTarget(a.GetTargetId(),true)).GetName()==(service.GetTargets()[1]).GetName()||(subschema.GetTarget(b.GetTargetId(),true)).GetName()==(service.GetTargets()[0]).GetName()) {
				// Get the towns on this edges
ww++;
if (ww<2){		aTarget = subschema.GetTarget(a.GetTargetId(),true);
}else{			aTarget = bTarget;
}

			 bTarget = subschema.GetTarget(b.GetTargetId(),true);
if (!aTarget.IsValid()||!(service.GetTargets()[0].IsValid())) {
::pz.MMM=0;
return false
}
				// If the tile is not yet fixed, find one				
if(!bTarget.IsValid()||(bTarget.GetName()!=service.GetTargets()[0].GetName()&&(AIMap.DistanceManhattan(bTarget.GetLocation(),service.GetTargets()[0].GetLocation())<26||AIMap.DistanceManhattan(bTarget.GetLocation(),aTarget.GetLocation())<22))){
bTarget=aTarget;
jp=1;
fl=true;
continue;
}
if (wwg==1){
wwg=0;
	foreach(target in service.GetTargets()) {

		if(target.GetType() == Target.TYPE_TOWN) {
			// Ensure that the source town has stations

			local added = RoadManager.BuildTownStations(target, service.GetCargo(), service.GetSubType(), service.GetCoverageTarget(), PathZilla.MAX_INITIAL_STATIONS);

			if(added > 0) {
				targetsUpdated.Insert(target);

			}else if(RoadManager.GetStations(target, service.GetCargo(), service.GetSubType()).Count()<1){
::pz.MMM=0;
return false;
}

		} else {

			// Ensure there is a station at the target

			if(!RoadManager.BuildIndustryStation(target, service.GetCargo(), service.GetSubType())) {

(::german)?AILog.Error("Bauarbeiten abgebrochen!"):AILog.Error("Could not complete infrastructure");
::pz.MMM=0;
return false;
			}
		}
	}}
if (noway==1){
fl=true;
continue;
}
local stations=AIAbstractList();
stations.AddList(RoadManager.GetStations(aTarget, service.GetCargo(), service.GetSubType()));
if (!stations.IsEmpty())aTarget.FixTile(AIStation.GetLocation(stations.Begin()));
stations.Clear();
stations.AddList(RoadManager.GetStations(bTarget, service.GetCargo(), service.GetSubType()));
if (!stations.IsEmpty())bTarget.FixTile(AIStation.GetLocation(stations.Begin()));
				if(aTarget.IsTileUnfixed()) RoadManager.PreFixTarget(bTarget, aTarget, walk, subschema);	
				if(bTarget.IsTileUnfixed()) RoadManager.PreFixTarget(aTarget, bTarget, walk, subschema);
	
				// Ensure we can afford to do some construction				
				FinanceManager.EnsureFundsAvailable(PathZilla.FLOAT);
				// Try to build a link between the towns
{

(::german)?AILog.Info(" Baue eine Strasse von " + aTarget.GetName() + " nach " + bTarget.GetName() + "..."):AILog.Info(" Building a road between " + aTarget.GetName() + " and " + bTarget.GetName() + "...");
local feat = [PathWrapper.FEAT_DEPOT_ALIGN,PathWrapper.FEAT_SEPARATE_ROAD_TYPES];
				if(!bTarget.IsTileFixed()){
				RoadManager.PreFixTarget(aTarget, bTarget, walk, subschema);
				pathb = PathWrapper.FindPath(aTarget.GetTile(), bTarget.GetTile(), service.GetSubType(), [], true, feat);
if (pathb==null||pathb==false||pathb.GetParent()==null) {
if (jp==3||ww<2||aTarget.GetTile()==bTarget.GetTile()){
(::german)?AILog.Error("Verbindung nicht moeglich!"):AILog.Error("Could not link");
::pz.MMM=0;
			return false;
}
if (bTarget.GetName()!=(service.GetTargets()[0]).GetName()&&bTarget.GetName()!=(service.GetTargets()[1]).GetName()){
a=path.GetVertex();
aTarget=subschema.GetTarget(a.GetTargetId(),true)
bTarget=aTarget;
jp=1;
fl=true;
continue;
}else{
a=path.GetVertex();
aTarget=subschema.GetTarget(a.GetTargetId(),true)
bTarget=aTarget;
walk=path;
jp=2;
fl=true;
continue;
}}				
				
				RoadManager.PostFixTarget(bTarget, clone pathb, true);
				}
				pathb = PathWrapper.FindPath(aTarget.GetTile(), bTarget.GetTile(), service.GetSubType(), [], true, feat);
if (aTarget.GetTile()!=bTarget.GetTile()){
if (pathb!=null&&pathb!=false&&pathb.GetParent()!=null) pathb=PathWrapper.OptimizePath(pathb,aTarget.GetTile(), bTarget.GetTile(), service.GetSubType(), [], true, feat);

if (pathb==null||pathb==false||pathb.GetParent()==null) {
if (jp==3||ww<2||aTarget.GetTile()==bTarget.GetTile()){
(::german)?AILog.Error("Verbindung nicht moeglich!"):AILog.Error("Could not link");
::pz.MMM=0;
			return false;
}
if (bTarget.GetName()!=service.GetTargets()[0].GetName()){
a=path.GetVertex();
aTarget=subschema.GetTarget(a.GetTargetId(),true)
bTarget=aTarget;
jp=1;
fl=true;
continue;
}else{
a=path.GetVertex();
aTarget=subschema.GetTarget(a.GetTargetId(),true)
bTarget=aTarget;
walk=path;
jp=2;
fl=true;
continue;
}}				

if (fl||pathb==null||pathb==false||pathb.GetParent()==null){
(::german)?AILog.Error("Verbindung nicht moeglich!"):AILog.Error("Could not link");
::pz.MMM=0;
			return false;
}

success = PathWrapper.TryBuildPath(pathb, aTarget.GetTile(), bTarget.GetTile(), service.GetSubType(),[], true, feat);
}else{
success=true;
qba=true;
}
				// Only proceed if we were able to build the link
				if((success)&&(qba||pathb!=null)) {
					// Firmly fix tiles to better suit what has been built
if(!qba&&aTarget.IsTileSemiFixed()) RoadManager.PostFixTarget(aTarget, clone pathb, false);
					// Add the edge to the actual graph
					qba=false;
					subschema.GetActualGraph().AddEdge(edge);
				} else {
(::german)?AILog.Error("Verbindung nicht moeglich!"):AILog.Error("Could not link");
::pz.MMM=0;
			return false;

				}
			}
		}

		if(!success) {
(::german)?AILog.Error("Keine Verbindung gefunden!"):AILog.Error("No path found!");
		
::pz.MMM=0;
			return false;
		}
		}
		prev = next;
	}

	// Also ensure depots are available for each target
	//  - We do this after for a reason!
}}
if (station){

local target= service.GetTargets()[0];
local stations=AIAbstractList();
stations.AddList(RoadManager.GetStations(target, service.GetCargo(), service.GetSubType()));
local targett= service.GetTargets()[1];
local stationst=AIAbstractList();
stationst.AddList(RoadManager.GetStations(targett, service.GetCargo(), service.GetSubType()));
local direction=(abs(AIMap.GetTileX(AIStation.GetLocation(stations.Begin()))-AIMap.GetTileX(AIStation.GetLocation(stationst.Begin())))>abs(AIMap.GetTileY(AIStation.GetLocation(stations.Begin()))-AIMap.GetTileY(AIStation.GetLocation(stationst.Begin()))))?((AIMap.GetTileX(AIStation.GetLocation(stations.Begin()))>AIMap.GetTileX(AIStation.GetLocation(stationst.Begin())))?1:3):((AIMap.GetTileY(AIStation.GetLocation(stations.Begin()))>AIMap.GetTileY(AIStation.GetLocation(stationst.Begin())))?0:2);
foreach (stationq,_ in stations)RoadManager.BuildDepot(stationq, service.GetSubType(),direction);	
direction=(direction+2)%4;
foreach (stationq,_ in stationst)RoadManager.BuildDepot(stationq, service.GetSubType(),direction);	
}

::pz.MMM=0;
	return true;
}

/*
 * Fix a buildable tile before station construction based on distance to  
 * neighboring targets.
 */
function RoadManager::PreFixTarget(aTarget, bTarget, walk, schema) {


	local aTile = aTarget.GetLocation();
	local bTile = bTarget.GetLocation();
	local cTile = bTile;
	if (walk.GetParent().GetParent() != null) {
		local tid = walk.GetParent().GetParent().GetVertex().GetTargetId(); 
		cTile = schema.GetTarget(tid,true).GetLocation();
	}
/*	if (walk.GetParent().GetParent() != null) {
		local tid = walk.GetParent().GetParent().GetVertex().GetTargetId(); 
		foreach (target in schema.GetTargets()){
		if (target.GetId()==tid&&target.IsValid()){
		cTile = target.GetLocation();		
		break;
		}
		}		
	}
*/	
	// Get a list of tiles around the target
	local rad = PathZilla.TARGET_FIX_RADIUS;
	local offset = AIMap.GetTileIndex(rad, rad);
	local tileList = AITileList();
	tileList.AddRectangle(bTile - offset, bTile + offset);

	// Find a tile that is roughly equidistant from the other 
	// targets and has the most buildable tiles around it
	local sqDist = sqrt(AITile.GetDistanceSquareToTile(aTile, cTile));
	foreach(tile, _ in tileList) {
		local cDist = AITile.GetDistanceSquareToTile(cTile, tile);
		local score = sqDist - sqrt(cDist);
		
		tileList.SetValue(tile, (AITile.IsBuildable(tile)) ? score.tointeger() : 0);
	}
	tileList.Sort(AIAbstractList.SORT_BY_VALUE, false);
	
	bTarget.SemiFixTile(tileList.Begin());
}

/*
 * Fix a buildable tile after station construction based on a path.
 */
function RoadManager::PostFixTarget(target, path, rev) {


if (target.IsValid()){
	local ftile = target.GetTile();
local pathb=path;
	while (path != null) {
		ftile = path.GetTile(); 


		if((AITile.GetSlope(ftile)==AITile.SLOPE_FLAT||AITile.GetSlope(ftile)==AITile.SLOPE_NWS||AITile.GetSlope(ftile)==AITile.SLOPE_WSE||AITile.GetSlope(ftile)==AITile.SLOPE_SEN||AITile.GetSlope(ftile)==AITile.SLOPE_ENW)&&(!rev && (AITile.IsBuildable(ftile)||AIRoad.IsRoadTile(ftile))&&AITile.GetDistanceManhattanToTile(target.GetTile(), ftile) < max(min((AITile.GetDistanceManhattanToTile(target.GetTile(), ftile)/2-5).tointeger(),3),25))) break;
		if((AITile.GetSlope(ftile)==AITile.SLOPE_FLAT||AITile.GetSlope(ftile)==AITile.SLOPE_NWS||AITile.GetSlope(ftile)==AITile.SLOPE_WSE||AITile.GetSlope(ftile)==AITile.SLOPE_SEN||AITile.GetSlope(ftile)==AITile.SLOPE_ENW)&&(rev && (AITile.IsBuildable(ftile)||AIRoad.IsRoadTile(ftile))&&AITile.GetDistanceManhattanToTile(target.GetTile(), ftile) > max(min((AITile.GetDistanceManhattanToTile(target.GetTile(), ftile)/2-5).tointeger(),3),25))) break;
		path = path.GetParent();
	}

if (path==null){
ftile = target.GetTile();
path=pathb;
	while (path != null) {
		ftile = path.GetTile(); 


		if(!rev && (AITile.IsBuildable(ftile)||AIRoad.IsRoadTile(ftile))&&AITile.GetDistanceManhattanToTile(target.GetTile(), ftile) < max(min((AITile.GetDistanceManhattanToTile(target.GetTile(), ftile)/2-5).tointeger(),3),25)) break;
		if(rev && (AITile.IsBuildable(ftile)||AIRoad.IsRoadTile(ftile))&&AITile.GetDistanceManhattanToTile(target.GetTile(), ftile) > max(min((AITile.GetDistanceManhattanToTile(target.GetTile(), ftile)/2-5).tointeger(),3),25)) break;
		path = path.GetParent();
}	}

	target.FixTile(ftile);
}
}

/*
 * Maintain the infrastructure for the specified service, by ensuring that 
 * enough stations have been built. The supplied set targetsUpdated will be
 * updated with targets that were modified in the operation.
 */
function RoadManager::MaintainInfrastructure(service, targetsTried, targetsUpdated) {

	foreach(target in service.GetTargets()) {
		if(target.GetType() == Target.TYPE_TOWN) {
			local completeTram = (service.GetSubType() == AIRoad.ROADTYPE_TRAM) && (RoadManager.GetStations(target, service.GetCargo(), service.GetSubType()).Count() > 0);
			if(!targetsTried.Contains(target.GetId()) && !completeTram) {
				targetsTried.Insert(target.GetId());
				local added = RoadManager.BuildTownStations(target, service.GetCargo(), service.GetSubType(), service.GetCoverageTarget(), 1);
				
				if(added > 0) {
					targetsUpdated.Insert(target);
				}
			}
		} else if(target.GetType() == Target.TYPE_INDUSTRY) {
			// Ensure a station can be found at the target
			RoadManager.BuildIndustryStation(target, service.GetCargo(), service.GetSubType());
		}
	}
}

/*
 * Get a list of all the road stations in a town for a specified cargo
 */
function RoadManager::GetStations(target, cargo, roadType) {


AIRoad.SetCurrentRoadType(roadType);
	local truckStation = !AICargo.HasCargoClass(cargo, AICargo.CC_PASSENGERS);
	local stationType = (truckStation) ? AIStation.STATION_TRUCK_STOP : AIStation.STATION_BUS_STOP;
	local radius = AIStation.GetCoverageRadius(stationType);
	local townid=0;
	if (target.IsTown()) townid=1000000;
	// Ensure we get the right type of station
	local stationList = AIList();
	if(target.IsTown()) {
		 stationList.AddList(((truckStation) ? (AIStationList(AIStation.STATION_TRUCK_STOP)) : (AIStationList(AIStation.STATION_BUS_STOP))));
foreach (st,_ in stationList){
	stationList.SetValue(st, (AITile.GetCargoAcceptance(AIStation.GetLocation(st),cargo,1,1,radius)>=8&&AIStation.IsWithinTownInfluence(st,target.GetId()-1000000)
) ? 1 : 0);
}
stationList.RemoveValue(0);

	} else {
		local coveredTiles = (target.ProducesCargo(cargo)) ? AITileList_IndustryProducing(target.GetId()-townid, radius) : AITileList_IndustryAccepting(target.GetId()-townid, radius);
		foreach(tile, _ in coveredTiles) {
			local st = AIStation.GetStationID(tile);
			if(AIStation.IsValidStation(st)&&AIStation.HasStationType(st,stationType)) {

			stationList.AddItem(st, 0);
			}
		}
	}
	
	// Ensure the stations have the correct road type
	foreach(station, _ in stationList) {
		local correctRt = (AIRoad.HasRoadType(AIStation.GetLocation(station), roadType));
		stationList.SetValue(station, (correctRt) ? 1 : 0);
	}
	stationList.RemoveValue(0);
	foreach(station, _ in stationList) {
local vstl=AIVehicleList_Station(station);
vstl.Valuate(AIVehicle.GetRoadType)
	vstl.RemoveValue(roadType);
		stationList.SetValue(station, (vstl.IsEmpty()) ? 1 : 0);
}
	stationList.RemoveValue(0);
	return stationList;
}

/*
 * Get the combined coverage area of all stations in a town for a specified
 * cargo, as a parcentage of all houses in that town. This helps determine how
 * many stations can be placed in a town. If the AI is set not to be agressive
 * it will count competitor's stations in the total coverage.
 */
function RoadManager::GetTownCoverage(town, cargo, roadType) {


	// Initialise a few details
AIRoad.SetCurrentRoadType(roadType);
local townid=0;
if (town>=1000000) townid=1000000;
	local truckStation = !AICargo.HasCargoClass(cargo, AICargo.CC_PASSENGERS);
	local stationType = (truckStation) ? AIStation.STATION_TRUCK_STOP : AIStation.STATION_BUS_STOP;
	local radius = AIStation.GetCoverageRadius(stationType);
	local offset = AIMap.GetTileIndex(radius, radius);
	// Get a list of our stations in the town	
	local stationList = ((truckStation) ? (AIStationList(AIStation.STATION_TRUCK_STOP)) : (AIStationList(AIStation.STATION_BUS_STOP)));
	stationList.Valuate(AIStation.IsWithinTownInfluence, town-townid);
	stationList.RemoveValue(0);
	// Ensure the stations have the correct road type
	foreach(station, _ in stationList) {
		stationList.SetValue(station, (AIRoad.HasRoadType(AIStation.GetLocation(station), roadType)) ? 1 : 0);
	}
	stationList.RemoveValue(0);
	
	
	// Get a list of tiles that fall within the coverage area of those stations
	local coveredTiles = AITileList();
	foreach(station, _ in stationList) {
		local tile = AIStation.GetLocation(station);
		coveredTiles.AddRectangle(tile - offset, tile + offset);
	}
	
	// Include competitors stations if we are not agressive
	if(!Settings.IsAggressive()) {
		// Get a large area around the town
		local townTile = AITown.GetLocation(town-townid);
		local searchRadius = min(AIMap.DistanceFromEdge(townTile) - 1, PathZilla.MAX_TOWN_RADIUS+5);
		local off = AIMap.GetTileIndex(searchRadius, searchRadius);
		local tileList = AITileList();
		tileList.AddRectangle(townTile - off, townTile + off);		

		// Find those tiles that are controlled by competitors
		foreach(tile, _ in tileList) {
			local owner = AITile.GetOwner(tile);
			local isCompetitors = (owner != AICompany.ResolveCompanyID(AICompany.COMPANY_SELF) && owner != AICompany.ResolveCompanyID(AICompany.COMPANY_INVALID));
			
			// If its a station tile and not ours then look into it
			if(AITown.IsWithinTownInfluence(town-townid, tile) && isCompetitors && AITile.IsStationTile(tile)) {
				// Identify the station type
				local stRadius = 0;
				if(LandManager.IsRoadStationAny(tile)) {
					stRadius = (AIStation.GetCoverageRadius(AIStation.STATION_BUS_STOP)/2).tointeger();
				} else if(AITile.HasTransportType(tile, AITile.TRANSPORT_RAIL)) {
					stRadius = (AIStation.GetCoverageRadius(AIStation.STATION_TRAIN)/2).tointeger()+1;
				} else if(AIMarine.IsDockTile(tile)) {
					stRadius = (AIStation.GetCoverageRadius(AIStation.STATION_DOCK)/2).tointeger();
				} else if(AIAirport.IsAirportTile(tile)) {
					// TODO - This doesn't work - yet!
					stRadius = (AIAirport.GetAirportCoverageRadius(AIAirport.GetAirportType(tile))/2).tointeger();
				}
				
				// Add the station's coverage radius to the list
				if(stRadius > 0) {
					local offs = AIMap.GetTileIndex(stRadius, stRadius);
					coveredTiles.AddRectangle(tile - offs, tile + offs);
				}
			}
		}
	}

	// Reinstate the following after OpenTTD 0.7.2 si released
	coveredTiles.Valuate(AITile.GetCargoAcceptance, cargo, 1, 1, 0);
	coveredTiles.Valuate(LandManager.CargoAcceptanceOnTile, cargo);
	coveredTiles.RemoveBelowValue(1);

//	AILog.Info(AITown.GetName(town-townid) + " has " + AITown.GetHouseCount(town-townid) + " houses");
//	AILog.Info(coveredTiles.Count() + " tiles covered");
//	AILog.Info("COVERAGE"+(coveredTiles.Count() * 100) / AITown.GetHouseCount(town-townid));	
	return ((coveredTiles.Count() * 100) / AITown.GetHouseCount(town-townid))*((truckStation)?2:1);
}

/*
 * Build enough stations in a town such that the combined coverage meets or
 * exceeds the target coverage percentage.
 * 
 * The function returns the number of stations that were added.
 */
function RoadManager::BuildTownStations(target, cargo, roadType, coverageTarget, maxAdd = 100) {
if (!target.IsTown()||AICargo.GetTownEffect(cargo)==AICargo.TE_NONE)return 0;
local town = target.GetId();
	local truckStation = !AICargo.HasCargoClass(cargo, AICargo.CC_PASSENGERS);
	local stList = ((truckStation) ? (AIStationList(AIStation.STATION_TRUCK_STOP)) : (AIStationList(AIStation.STATION_BUS_STOP)));
	stList.Valuate(AIStation.IsWithinTownInfluence, town-1000000);
	stList.RemoveValue(0);

	if (stList.Count()*((truckStation)?3500:1800)>AITown.GetPopulation(town-1000000))return 0;
AIRoad.SetCurrentRoadType(roadType);

	local numStationsBuilt = 0;

	// Set the correct road type before starting
	AIRoad.SetCurrentRoadType(roadType);

	// Get the type of station that is needed	
	local stationType = (truckStation) ? AIStation.STATION_TRUCK_STOP : AIStation.STATION_BUS_STOP;

	// Get the stations already built in the town
	local stationList = ((truckStation) ? (AIStationList(AIStation.STATION_TRUCK_STOP)) : (AIStationList(AIStation.STATION_BUS_STOP)));
;	stationList.Valuate(AIStation.IsWithinTownInfluence, town-1000000);
	stationList.RemoveValue(0);
	
	// Build new stations if there are none or until the coverage exceeds the target
	local stationID = 0;
local iz=0;
	while(((stationList.Count() + numStationsBuilt == 0) || RoadManager.GetTownCoverage(town-1000000, cargo, roadType) <= coverageTarget) && stationID >= 0 && numStationsBuilt < maxAdd&&iz<100) {
iz++;
if (iz%10==9&&AICompany.GetBankBalance(AICompany.COMPANY_SELF)<=0){
SaveMoney();
if(AICompany.GetBankBalance(AICompany.COMPANY_SELF)<88888)		PathZilla.Sleep(1);
::pz.HandleEvents();
}
		stationID = RoadManager.BuildStation(target, cargo, roadType);		
		if(stationID >= 0) {
			numStationsBuilt++;

if (!stationList.IsEmpty()){
stationList.Valuate(AIStation.GetDistanceManhattanToTile, AITown.GetLocation(town-1000000));
stationList.Sort(AIAbstractList.SORT_BY_VALUE, true);
local newdst=AIStation.GetDistanceManhattanToTile(stationID,AITown.GetLocation(town-1000000));
foreach (sttd,stdst in stationList){
if (!AIRoad.HasRoadType(AIStation.GetLocation(sttd),roadType))continue;
if (stdst>=newdst)break;

	local	path = PathWrapper.FindPath(AIStation.GetLocation(stationID), AIStation.GetLocation(sttd), roadType, [], true, [PathWrapper.FEAT_DEPOT_ALIGN]);

if(path == null) {
			stationID=stationList.Begin();
			break;			
			}else if(path.GetParent() == null){
			stationID=stationList.Begin();
			break;
			}else{
local tile=null;
local par=null;
local xpath=path
local ptiles=AIList();
while (xpath != null&&xpath!=false) {
		tile = xpath.GetTile();
		par = xpath.GetParent();
if(!AIRoad.IsRoadTile(tile))ptiles.AddItem(tile,0);
xpath=par;
}
if(PathWrapper.BuildPath(path, roadType) != 0){
if (AIVehicleList_Station(stationID).IsEmpty()){
AIRoad.RemoveRoadStation(AIStation.GetLocation(stationID));
if (ptiles.Count()>0){
foreach(tl,_ in ptiles){
if(AIRoad.IsRoadTile(tl))AITile.DemolishTile(tl);
}}}

			stationID=stationList.Begin();
}}
break;
}


			}

}			}
if(numStationsBuilt>0){
local strType =((::german)?(roadType == AIRoad.ROADTYPE_ROAD) ?((truckStation)?((numStationsBuilt>1)?(numStationsBuilt).tostring()+" Lkw-Ladeplaetze":"Einen Lkw-Ladeplatz"):((numStationsBuilt>1)?(numStationsBuilt).tostring()+" Bushaltestellen":"Eine Bushaltestelle")): ((numStationsBuilt>1)?(numStationsBuilt).tostring()+" Strassenbahnhaltestellen":"Eine Strassenbahnhaltestelle"):(roadType == AIRoad.ROADTYPE_ROAD) ? " road" : " tram");
(::german)?AILog.Info("" + strType + " in " + target.GetName() + " eingerichtet..."):AILog.Info(((numStationsBuilt==1)?"A":(numStationsBuilt).tostring())+strType + " station"+((numStationsBuilt>1)?"s were":" was")+" built in " + target.GetName() + "...");
}
if (stationList.Count()>2&&AICompany.GetBankBalance(AICompany.COMPANY_SELF)>PathZilla.FLOAT*15) TownManager.BuildStatue(town-1000000);
	return numStationsBuilt;
}

/*
 * Check that a station has been built to serivce the specified industry and 
 * cargo. If not one will be built and the target tile semi-fixed.
 */
function RoadManager::BuildIndustryStation(target, cargo, roadType,fleet=0) {

if (!target.IsValid()||target.IsTown()||!AIIndustry.IsValidIndustry(target.GetId()))return false;

AIRoad.SetCurrentRoadType(roadType);
	local stations = RoadManager.GetStations(target, cargo, roadType);
	local station = null;
	local bc=0;
	if(stations.IsEmpty()) {
		station = RoadManager.BuildStation(target, cargo, roadType);
	}else {
local trucks=fleet;
foreach (service in ServiceManager.GetServices()){
foreach (station , _ in stations){
local tnam=target.GetName();
if (service.GetDistance()>1&&AIVehicle.IsValidVehicle(service.GetVehicles().Begin())&&((service.GetTargets()[0]).GetName()==tnam||(service.GetTargets()[1]).GetName()==tnam)){
trucks=trucks+((service.GetActualFleetSize()*123)/service.GetDistance()).tointeger();
break;
}
}
}
bc=stations.Count();
if (trucks>123*bc){
local stamt=AIIndustry.GetAmountOfStationsAround(target.GetId());
		station = RoadManager.BuildStation(target, cargo, roadType,true);

if (AIIndustry.GetAmountOfStationsAround(target.GetId())<=stamt||station < 0||station==null) {
station=stations.Begin();
}else{

		local path = PathWrapper.FindPath(AIStation.GetLocation(station), AIStation.GetLocation(stations.Begin()), roadType, [], true, [PathWrapper.FEAT_DEPOT_ALIGN]);
if(path == null) {
			station=stations.Begin();
			}else if(path.GetParent() == null){
			 station=stations.Begin();

			}else{
local tile=null;
local par=null;
local xpath=path
local ptiles=AIList();
while (xpath != null&&xpath!=false) {
		tile = xpath.GetTile();
		par = xpath.GetParent();
if(!AIRoad.IsRoadTile(tile))ptiles.AddItem(tile,0);
xpath=par;
}
 if(PathWrapper.BuildPath(path, roadType) != 0){
if (AIVehicleList_Station(station).IsEmpty()){
AIRoad.RemoveRoadStation(AIStation.GetLocation(station));
if (ptiles.Count()>0){
foreach(tl,_ in ptiles){
if(AIRoad.IsRoadTile(tl))AITile.DemolishTile(tl);
}}}

			station=stations.Begin();
			}}

if (bc>=RoadManager.GetStations(target, cargo, roadType).Count()||!AIStation.IsValidStation(station)) return false;
local direction=(abs(AIMap.GetTileX(AIStation.GetLocation(station))-AIMap.GetTileX(target.GetLocation()))>abs(AIMap.GetTileY(AIStation.GetLocation(station))-AIMap.GetTileY(target.GetLocation())))?((AIMap.GetTileX(AIStation.GetLocation(station))>AIMap.GetTileX(target.GetLocation()))?3:1):((AIMap.GetTileY(AIStation.GetLocation(station))>AIMap.GetTileY(target.GetLocation()))?2:0);
RoadManager.BuildDepot(station,roadType,direction,false,true);
}
}else{
		station = stations.Begin();
	}
}
	if(!target.IsTileFixed() && station != null && station > -1) {
		local tile = AIRoad.GetRoadStationFrontTile(AIStation.GetLocation(station));
		target.SemiFixTile(tile);
	}
	
	return (station > -1);
}

/*
 * Build a single station in the specified town to accept the specified cargo.
 * The position of the station will be selected based on the maximum level
 * of acceptance.
 */
function RoadManager::BuildStation(target, cargo, roadType,nst=false) {
AIRoad.SetCurrentRoadType(roadType);
	if (!target.IsValid())return -1;
	local targetLocation = target.GetLocation();
	local targetTile = target.GetTile();
	local townid=0;
	if (target.IsTown()) townid=1000000;
	// Get a list of tiles to search in
	local searchRadius = min(AIMap.DistanceFromEdge(targetLocation) - 1, PathZilla.MAX_TOWN_RADIUS+12);
	local offset = AIMap.GetTileIndex(searchRadius, searchRadius);

	// Before we do anything, check the local authority rating
	local nearestTown = TownManager.FindNearestTown(targetLocation)
	
	// Try to improve the local authority rating if necessary
	TownManager.HandleRating(nearestTown);

	// Check if we are allowed to build in town
	if(!TownManager.CanBuildInTown(nearestTown)) {
(::german)?AILog.Error("Stadtverwaltung von "+AITown.GetName(nearestTown) + " lehnt unser Bauvorhaben ab..."):AILog.Error(AITown.GetName(nearestTown) + " local authority refuses construction");
		return -1;
	}

	
	// Get the type of station we should build and its radius	
	local truckStation = !AICargo.HasCargoClass(cargo, AICargo.CC_PASSENGERS);
	local stationType = (truckStation) ? AIStation.STATION_TRUCK_STOP : AIStation.STATION_BUS_STOP;
if (!truckStation&&!target.AcceptsCargo(cargo))return -1;
	local radius = AIStation.GetCoverageRadius(stationType);

	// Get a list of tiles
	local tileList = AITileList();
	if(target.IsTown()) {
		tileList.AddRectangle(targetLocation - offset, targetLocation + offset);
	} else {
		if(target.ProducesCargo(cargo)) {
			tileList = AITileList_IndustryProducing(target.GetId()-townid, radius);
		} else {
			tileList = AITileList_IndustryAccepting(target.GetId()-townid, radius);
		}
	}
	
	// Get a list of existing stations - INCOMPATIBLE WITH MULTIPLE TRANSPORT TYPES
	local stationList = AIList();
	if(target.IsTown()) {
		stationList = ((truckStation) ? (AIStationList(AIStation.STATION_TRUCK_STOP)) : (AIStationList(AIStation.STATION_BUS_STOP)));
		stationList.Valuate(AIStation.IsWithinTownInfluence, target.GetId()-1000000);
		stationList.RemoveValue(0);
	} else {
		local coveredTiles = (target.ProducesCargo(cargo)) ? AITileList_IndustryProducing(target.GetId(), radius) : AITileList_IndustryAccepting(target.GetId(), radius);
		foreach(tile, _ in coveredTiles) {
			local st = AIStation.GetStationID(tile);
			stationList.AddItem(st, 0);
		}
	}
	
	// Remove tiles surrounging our stations, to ensure they aren't built too close

	local stationSpacing = (radius * 3) / 2;
	local first=true;
	foreach(station, _ in stationList) {
if((target.IsTown()&&AIStation.HasStationType(station,stationType)&&AIStation.IsValidStation(station))){
first=false;
offset = AIMap.GetTileIndex(5,5)
}else{
offset = AIMap.GetTileIndex(1,1);
}
		local tile = AIStation.GetLocation(station);
		tileList.RemoveRectangle(tile - offset, tile + offset);
	}

	// Calculate the station spacing
	local comptSpacing = (nst||(target.IsTown() && (Settings.IsAggressive() || stationList.Count() == 0))) ? 1 : stationSpacing;

	// Find a list of tiles that are controlled by competitors
	foreach(tile, _ in tileList) {
		local owner = AITile.GetOwner(tile);
		local isCompetitors = (owner != AICompany.ResolveCompanyID(AICompany.COMPANY_SELF) && owner != AICompany.ResolveCompanyID(AICompany.COMPANY_INVALID));

		if(!target.IsTown()&&AITile.IsStationTile(tile)&& isCompetitors) {
			tileList.RemoveRectangle(tile-AIMap.GetTileIndex(1,1),tile+AIMap.GetTileIndex(1,1));
		}else if(AITile.IsStationTile(tile) || isCompetitors||(target.IsTown()&&!AIRoad.IsRoadTile(tile))) {
			tileList.RemoveTile(tile);
		}
	}
	
	// Check if the game allows us to build DTRSes on town roads and get the road type
	local dtrsOnTownRoads = (AIGameSettings.GetValue("construction.road_stop_on_town_road") == 1);

	// Get some information about the nearest town's road layout
	local layoutType = AITown.GetRoadLayout(nearestTown);
	local tlayout = (layoutType == AITown.ROAD_LAYOUT_2x2) ? 3 : ((layoutType == AITown.ROAD_LAYOUT_3x3) ? 4 : 0);
	local tx = AIMap.GetTileX(AITown.GetLocation(nearestTown));
	local ty = AIMap.GetTileY(AITown.GetLocation(nearestTown));

	// Rank those tiles by their suitability for a station
	foreach(tile, _ in tileList) {
		// Find roads that are connected to the tile
		local adjRoadListRd = LandManager.GetAdjacentTileList(tile);
		AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);
		adjRoadListRd.Valuate(AIRoad.AreRoadTilesConnected, tile);
		adjRoadListRd.KeepValue(1);
		
		// Find tram tracks that are connected to the tile
		local adjRoadListTrm = LandManager.GetAdjacentTileList(tile);
		AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_TRAM);
		adjRoadListTrm.Valuate(AIRoad.AreRoadTilesConnected, tile);
		adjRoadListTrm.KeepValue(1);
		
		// Combine to see all the adjacent road tiles of any type that are connected to
		adjRoadListTrm.AddList(adjRoadListRd);
		local adjRoads = ListToArray(adjRoadListTrm);
		local straightRoad = false;

		// Check if the road tile is a straight road  
		if(adjRoads.len() == 1) {
			straightRoad = true;
		} else if(adjRoads.len() == 2) {
			local dx = abs(adjRoads[1] % AIMap.GetMapSizeY()) - abs(adjRoads[0] % AIMap.GetMapSizeY());
			local dy = abs(adjRoads[1] / AIMap.GetMapSizeY()) - abs(adjRoads[0] / AIMap.GetMapSizeY());
			straightRoad = (dx == 0) || (dy == 0);
		}
		
		// Reset road type		
		AIRoad.SetCurrentRoadType(roadType);

		// Find the roads that would run parallel to a DTRS in this spot
		local parlRoadList = LandManager.GetAdjacentTileList(tile);
		foreach(_tile, _ in parlRoadList) {
			local parl = AIRoad.IsRoadTile(_tile) && !AIRoad.AreRoadTilesConnected(tile, _tile);
			parlRoadList.SetValue(_tile, (parl) ? 1 : 0);
		}
		parlRoadList.KeepValue(1);
		local parlRoads = ListToArray(parlRoadList);
		local inCorner = false;

		if(parlRoads.len() >= 3) {
			inCorner = true;
		} else if(parlRoads.len() == 2) {
			local dx = abs(parlRoads[1] % AIMap.GetMapSizeY()) - abs(parlRoads[0] % AIMap.GetMapSizeY());
			local dy = abs(parlRoads[1] / AIMap.GetMapSizeY()) - abs(parlRoads[0] / AIMap.GetMapSizeY());
			inCorner = (dx != 0) || (dy == 0);
		}

		// Check if this tile is acceptable
		local canBuildOnRoad = (AITile.GetOwner(tile) == AICompany.COMPANY_INVALID) ? dtrsOnTownRoads : AICompany.IsMine(AITile.GetOwner(tile)); 
		local cl = (AIRoad.IsRoadTile(tile)) ? ((canBuildOnRoad) ? straightRoad : false) : LandManager.IsClearable(tile);
		local acceptable = LandManager.IsLevel(tile) && cl;
		if(target.IsTown()) acceptable = acceptable && AITown.IsWithinTownInfluence(target.GetId()-1000000, tile);
		
		// Do not allow stations on the junctions in a town with a grid layout
		if(target.IsTown() && tlayout != 0) {
			local dx = abs(AIMap.GetTileX(tile) - tx) % tlayout;
			local dy = abs(AIMap.GetTileY(tile) - ty) % tlayout;
			if(dx == 0 && dy == 0) acceptable = false; 
		}				

		// Get the cargo acceptance around the tile
		local score = 0;
		local threshold = 0;
		if(!target.IsTown() && target.ProducesCargo(cargo)) {
			score = AITile.GetCargoProduction(tile, cargo, 1, 1, radius);
		} else {
			score = AITile.GetCargoAcceptance(tile, cargo, 1, 1, radius);
			target.IsTown()&&target.ProducesCargo(cargo)&&(!first)?threshold = 40:threshold=8;
		}
		acceptable = acceptable &&(roadType==AIRoad.ROADTYPE_TRAM||!truckStation||!AIRoad.HasRoadType(tile,AIRoad.ROADTYPE_TRAM))&& (score >= threshold);

if (!(AIRoad.IsRoadTile(tile)&&!AIRoad.HasRoadType(tile,roadType)))score*=2;
		if(target.IsTown()) {
			// Penalise tiles in a corner
			score /= (inCorner) ? 3 : 1;
		
			// Promote tiles on road we can build on
			score += (AIRoad.HasRoadType(tile,roadType) && canBuildOnRoad) ? 10 : 0;
if (roadType==AIRoad.ROADTYPE_ROAD&&AIRoad.HasRoadType(tile,AIRoad.ROADTYPE_TRAM))score=min(score,1);
if (target.IsTown())			score += 1000-AIMap.DistanceManhattan(AITown.GetLocation(nearestTown),tile)*3;
if ((AIBridge.IsBridgeTile(tile+1)&&AIMap.DistanceManhattan(tile+1,AIBridge.GetOtherBridgeEnd(tile+1))>4)||(AITunnel.IsTunnelTile(tile+1)&&AIMap.DistanceManhattan(tile+1,AITunnel.GetOtherTunnelEnd(tile+1))))score=0;
if ((AIBridge.IsBridgeTile(tile-1)&&AIMap.DistanceManhattan(tile-1,AIBridge.GetOtherBridgeEnd(tile-1))>4)||(AITunnel.IsTunnelTile(tile-1)&&AIMap.DistanceManhattan(tile-1,AITunnel.GetOtherTunnelEnd(tile-1))))score=0;
if ((AIBridge.IsBridgeTile(tile+AIMap.GetMapSizeY())&&AIMap.DistanceManhattan(tile+AIMap.GetMapSizeY(),AIBridge.GetOtherBridgeEnd(tile+AIMap.GetMapSizeY()))>4)||(AITunnel.IsTunnelTile(tile+AIMap.GetMapSizeY())&&AIMap.DistanceManhattan(tile+AIMap.GetMapSizeY(),AITunnel.GetOtherTunnelEnd(tile+AIMap.GetMapSizeY()))))score=0;
if ((AIBridge.IsBridgeTile(tile-AIMap.GetMapSizeY())&&AIMap.DistanceManhattan(tile-AIMap.GetMapSizeY(),AIBridge.GetOtherBridgeEnd(tile-AIMap.GetMapSizeY()))>4)||(AITunnel.IsTunnelTile(tile-AIMap.GetMapSizeY())&&AIMap.DistanceManhattan(tile-AIMap.GetMapSizeY(),AITunnel.GetOtherTunnelEnd(tile-AIMap.GetMapSizeY()))))score=0;
}else{
if (score>0){
local mj=AIMap.GetMapSizeY();
local hjj=AITile.GetMaxHeight(tile);
if(AIMap.IsValidTile(tile-1)&&AITile.GetMaxHeight(tile-1)==hjj&&AITile.GetMinHeight(tile-1)>hjj-2&&AIMap.IsValidTile(tile+1)&&AITile.GetMaxHeight(tile+1)==hjj&&AITile.GetMinHeight(tile+1)>hjj-2){
if (AIMap.IsValidTile(tile-1-mj)&&AITile.GetMaxHeight(tile-1-mj)==hjj&&AITile.GetMinHeight(tile-1-mj)>hjj-2&&AIMap.IsValidTile(tile+1-mj)&&AITile.GetMaxHeight(tile+1-mj)==hjj&&AITile.GetMinHeight(tile+1-mj)>hjj-2)score*=2;
if (AIMap.IsValidTile(tile-1+mj)&&AITile.GetMaxHeight(tile-1+mj)==hjj&&AITile.GetMinHeight(tile-1+mj)>hjj-2&&AIMap.IsValidTile(tile+1+mj)&&AITile.GetMaxHeight(tile+1+mj)==hjj&&AITile.GetMinHeight(tile+1+mj)>hjj-2)score*=2;
}
if(AIMap.IsValidTile(tile-mj)&&AITile.GetMaxHeight(tile-mj)==hjj&&AIMap.IsValidTile(tile+mj)&&AITile.GetMaxHeight(tile+mj)==hjj){
if (AIMap.IsValidTile(tile-1-mj)&&AITile.GetMaxHeight(tile-1-mj)==hjj&&AITile.GetMinHeight(tile-1-mj)>hjj-2&&AIMap.IsValidTile(tile-1+mj)&&AITile.GetMaxHeight(tile-1+mj)==hjj&&AITile.GetMinHeight(tile-1+mj)>hjj-2)score*=2;
if (AIMap.IsValidTile(tile+1-mj)&&AITile.GetMaxHeight(tile+1-mj)==hjj&&AITile.GetMinHeight(tile+1-mj)>hjj-2&&AIMap.IsValidTile(tile+1+mj)&&AITile.GetMaxHeight(tile+1+mj)==hjj&&AITile.GetMinHeight(tile+1+mj)>hjj-2)score*=2;
}}}		
		// If the spot is acceptable, return tile score
		tileList.SetValue(tile, ((acceptable) ? score : 0));
	}
	tileList.Sort(AIAbstractList.SORT_BY_VALUE, false);
	
	// Remove unacceptable tiles
	tileList.RemoveValue(0);
	

	// If we can't find any suitable tiles then just give up!			
	if(tileList.Count() == 0) {
		if(stationList.Count() == 0) {
//			AILog.Error("  Station could not be built at " + target.GetName() + "!");
		}
		

		return -1;
	}
	
	// The tiles we need for reference
	local stationTile = null;
	local roadTile = null;
	local otherSide = null;
	local loop = null;
	AIRoad.SetCurrentRoadType(roadType);
	// Check each tile for valid paths that will connect it to the town.
	local success = false;
	foreach(stTile, _ in tileList) {
 		local path = true;
 		// Find a path only if we know where were going
 		if(target.IsTileFixed()) {

 			path = PathWrapper.FindPath(targetTile, stTile,AIRoad.ROADTYPE_ROAD, [], false, [PathWrapper.FEAT_DEPOT_ALIGN,PathWrapper.FEAT_NO_WORMHOLES]);

 		}
 		
 		// If no path was found, try another tile 
		if(path == null) continue;

		// Find and check the road and other side tiles
		if(target.IsTileFixed()) {
			roadTile = (path.GetParent() != null) ? path.GetParent().GetTile() : targetTile;
			otherSide = LandManager.GetApproachTile(stTile, roadTile);
			
			// If the other side is unsuitable, try another tile
			if(!LandManager.IsRoadable(otherSide)) continue;
		} else {
			// Choose an orientation for the station
		
	local adj = LandManager.GetAdjacentTileList(stTile);
			foreach(rtile, _ in adj) {
				local otile = LandManager.GetApproachTile(stTile, rtile);
				local acc = LandManager.IsRoadable(rtile) && LandManager.IsRoadable(otile) && AIRoad.CanBuildConnectedRoadPartsHere(stTile, rtile, otile)>0;
				local score = ((acc) ? 1 : 0) + ((AIRoad.IsRoadTile(rtile)) ? 1 : 0) + ((AIRoad.IsRoadTile(otile)) ? 1 : 0);
				adj.SetValue(rtile, score);
			}
			adj.RemoveValue(0);
			// If it doesn't fit either way around, try another tile
			if(adj.IsEmpty()) continue;
			
			// Set the road and other side tiles
			roadTile = adj.Begin();
			otherSide = LandManager.GetApproachTile(stTile, roadTile);
		}
		
		// Choose a tile to loop to
		local loopTile = (target.IsTown()&&roadType!=AIRoad.ROADTYPE_TRAM && stTile != targetTile) ? targetTile : roadTile;
		// Set the list of RPF features for the loop

		local features = [PathWrapper.FEAT_NO_WORMHOLES,PathWrapper.FEAT_DEPOT_ALIGN];
//if (roadType==AIRoad.ROADTYPE_ROAD)features.append(PathWrapper.FEAT_SHORT_SCOPE);
//if (roadType==AIRoad.ROADTYPE_TRAM)features.append(PathWrapper.FEAT_ROAD_LOOP);
//if (roadType==AIRoad.ROADTYPE_TRAM&&AITown.IsWithinTownInfluence(nearestTown, stTile)) features.append(PathWrapper.FEAT_GRID_LAYOUT);
//		if(target.IsTown()) features.append(PathWrapper.FEAT_ROAD_LOOP);
local rtdem=AITown.GetRating(AITile.GetClosestTown(stTile),AICompany.ResolveCompanyID(AICompany.COMPANY_SELF))>AITown.TOWN_RATING_GOOD;
		// Find a loop back to the town
		loop = PathWrapper.FindPath(loopTile, otherSide, AIRoad.ROADTYPE_ROAD, [stTile],rtdem, features);
if(loop != null &&loop!=false &&loop.GetParent() != null)loop=PathWrapper.OptimizePath(loop,loopTile, otherSide, roadType, [stTile],rtdem, features);

		// Get the first tile in the loop

		local firstTile = (loop != null) ? PathWrapper.GetFirstTile(loop) : -1;
//		if (loop != null && loop.GetParent() != null&&AIRoad.CanBuildConnectedRoadPartsHere(otherSide, stTile, loop.GetParent().GetTile()) > 0) 		// Check that the loop exists and that it can connect to the station
		if((roadType==AIRoad.ROADTYPE_TRAM||!target.IsTown())&&loop != null && loop.GetParent() != null && (AIRoad.CanBuildConnectedRoadPartsHere(otherSide, stTile, loop.GetParent().GetTile()) > 0) && (AIRoad.CanBuildConnectedRoadPartsHere(loopTile, stTile, firstTile) > 0)) {
			// Build the path. If it fails try another tile.
			local pathed = true;
			if(target.IsTileFixed()&&roadType!=AIRoad.ROADTYPE_TRAM) pathed = (PathWrapper.BuildPath(path, roadType) == 0);
			if(!pathed) continue;

			// Build the loop. If it fails try another tile.
			local looped = (PathWrapper.BuildPath(loop, roadType) == 0);
if(roadType==AIRoad.ROADTYPE_ROAD&&AIRoad.HasRoadType(stTile,AIRoad.ROADTYPE_TRAM)&&AIRoad.HasRoadType(AIRoad.GetRoadStationFrontTile(stTile),AIRoad.ROADTYPE_TRAM)&&AIRoad.HasRoadType(AIRoad.GetDriveThroughBackTile(stTile),AIRoad.ROADTYPE_TRAM)){
AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_TRAM);
PathWrapper.BuildPath(loop, AIRoad.ROADTYPE_TRAM)
RoadManager.SafelyBuildRoad(otherSide, stTile);
RoadManager.SafelyBuildRoad(roadTile, stTile);
AIRoad.SetCurrentRoadType(roadType);
}
			if(!looped&&(!target.IsTown()||roadType==AIRoad.ROADTYPE_TRAM)) continue;
			
if (looped){
			// Join the path and the loop to the station tile
			RoadManager.SafelyBuildRoad(otherSide, stTile);
			RoadManager.SafelyBuildRoad(roadTile, stTile);
local lt=AITileList();
lt.AddTile(stTile);
local parz=null;
local tz=null;
local pa=loop;
while (pa != null&&pa!=false) {
		tz=pa.GetTile();
if (AIMap.IsValidTile(tz))lt.AddTile(tz);

		parz = pa.GetParent();
		pa=parz;
}
local nt=AITileList();
local tt=-1;
foreach(tile,_ in lt){
for (local ac=0;ac<=3;ac++){
switch(ac){
case 0:
tt=tile+1;break;
case 1:
tt=tile-1;break;
case 2:
tt=tile+AIMap.GetMapSizeX();break;
case 3:
tt=tile-AIMap.GetMapSizeX();break;
}
if (!lt.HasItem(tt)&&AIMap.IsValidTile(tt)&&AIRoad.IsRoadTile(tt)&&AIRoad.HasRoadType(tt,roadType)&&AITile.GetOwner(tt)==AICompany.COMPANY_INVALID&&!AIRoad.AreRoadTilesConnected(tt,tile)){
local ttt=tt+tt-tile;
if(AIMap.IsValidTile(ttt)&&AIRoad.IsRoadTile(ttt)&&AIRoad.HasRoadType(ttt,roadType)&&AIRoad.AreRoadTilesConnected(ttt,tt)){
if(abs(tt-tile)==1){
local at1=tt+AIMap.GetMapSizeX();
local at2=tt-AIMap.GetMapSizeX();
if((!AIMap.IsValidTile(at1)||!AIRoad.IsRoadTile(at1)||!AIRoad.HasRoadType(at1,roadType)||!AIRoad.AreRoadTilesConnected(at1,tt))&&(!AIMap.IsValidTile(at2)||!AIRoad.IsRoadTile(at2)||!AIRoad.HasRoadType(at2,roadType)||!AIRoad.AreRoadTilesConnected(at2,tt))){
AIRoad.SetCurrentRoadType(roadType);
AIRoad.BuildRoad(tt,tile);
}
}else{
local at1=tt+1;
local at2=tt-1;
if((!AIMap.IsValidTile(at1)||!AIRoad.IsRoadTile(at1)||!AIRoad.HasRoadType(at1,roadType)||!AIRoad.AreRoadTilesConnected(at1,tt))&&(!AIMap.IsValidTile(at2)||!AIRoad.IsRoadTile(at2)||!AIRoad.HasRoadType(at2,roadType)||!AIRoad.AreRoadTilesConnected(at2,tt))){
AIRoad.SetCurrentRoadType(roadType);
AIRoad.BuildRoad(tt,tile);
}}
}else{
nt.AddTile(tt);
}}}}
local rt=AITileList();
while(!nt.IsEmpty()){
local ftt=-1;
foreach(ttt,_ in nt){
local fz=0;
for (local ac=0;ac<=3;ac++){
switch(ac){
case 0:
ftt=ttt+1;break;
case 1:
ftt=ttt-1;break;
case 2:
ftt=ttt+AIMap.GetMapSizeX();break;
case 3:
ftt=ttt-AIMap.GetMapSizeX();break;
}
if (AIMap.IsValidTile(ftt)&&AIRoad.IsRoadTile(ftt)&&AIRoad.HasRoadType(ftt,roadType)&&AIRoad.AreRoadTilesConnected(ftt,ttt))fz++;
}
if (fz<2){
 rt.AddTile(ttt);
}}
if (rt.IsEmpty())break;
foreach(r,_ in rt)AITile.DemolishTile(r);
nt.RemoveList(rt);
rt.Clear();
}}
			stationTile = stTile;
		} else {
			if (!target.IsTown()||roadType==AIRoad.ROADTYPE_TRAM){
(::german)?AILog.Warning("  Finde keinen Platz fuer eine Wendeschleife..."):AILog.Warning("  Could not find loop to station!");
			continue;		
}else{
AIRoad.SetCurrentRoadType(roadType);
			path=PathWrapper.FindPath(AITown.GetLocation(target.GetId()-1000000), stTile, roadType, [], false, [PathWrapper.FEAT_DEPOT_ALIGN,PathWrapper.FEAT_NO_WORMHOLES]);			
			if (path==null)continue;

/*local rcheck=clone path;
			local rrq=false;			
local qtl=null;
while(rcheck!=null&&rcheck!=false){
			local toq=rcheck.GetTile();			
			local ouq=rcheck.GetParent();
			if (ouq!=null){
			qtl=ouq.GetTile();			
if (!(AIRoad.IsRoadTile(qtl)&&AIRoad.IsRoadTile(toq)&&AIRoad.AreRoadTilesConnected(toq,qtl))){
break;
}}else{
rrq=true;
}			
rcheck=ouq;
			}
			if (rrq)continue;
*/
			stationTile=stTile;
}
			}
	
	// If we couldn;t find a path to any of the tiles then give up.
	if(stationTile == null) {
(::german)?AILog.Warning("  Kann keine Verbindung zur Haltestelle in " + target.GetName() + " herstellen!"):AILog.Warning("  Station could not be reached at " + target.GetName() + "!");
		continue;
	}
	
	// Ensure we have a bit of cash available
	FinanceManager.EnsureFundsAvailable(PathZilla.FLOAT);
	
(::german)?AILog.Info("  Errichte eine Haltestelle in " + target.GetName() + "..."):AILog.Info("  Building a station at " + target.GetName() + "...");
	
	// Clean up little road stubs, if any
AIRoad.SetCurrentRoadType(roadType);
	if(AIRoad.IsRoadTile(stationTile)) {
		local sideRoads = LandManager.GetAdjacentTileList(stationTile);
		sideRoads.RemoveTile(roadTile);
		sideRoads.RemoveTile(otherSide);
		foreach(side, _ in sideRoads) {
			AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);
			AIRoad.RemoveRoad(stationTile, side);
			AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_TRAM);
			AIRoad.RemoveRoad(stationTile, side);
		}

		// Reset the original road type
		AIRoad.SetCurrentRoadType(roadType); 
	}

	local attempts = 0;
	local fail = false;

	// Finally, try to build the station
	while(!success && attempts++ < PathZilla.MAX_CONSTR_ATTEMPTS) {
		local rvType = (truckStation) ? AIRoad.ROADVEHTYPE_TRUCK : AIRoad.ROADVEHTYPE_BUS;
		success = AIRoad.BuildDriveThroughRoadStation(stationTile, roadTile, rvType, AIStation.STATION_NEW);
if(!success&&AIError.GetLastError()==AIError.ERR_LOCAL_AUTHORITY_REFUSES){
TownManager.HandleRating(nearestTown);
		success = AIRoad.BuildDriveThroughRoadStation(stationTile, roadTile, rvType, AIStation.STATION_NEW);
if(!success&&AIError.GetLastError()==AIError.ERR_LOCAL_AUTHORITY_REFUSES){
		local stopType = (truckStation) ? "truck" : ((roadType == AIRoad.ROADTYPE_TRAM) ? "tram" : "bus");
(::german)?AILog.Warning("  Die Stadverwaltung von "+AITown.GetName(nearestTown)+ " verbietet uns den Bau einer Haltestelle!"):AILog.Warning("   Local authority didn't allow us to build a "+stopType+" stop in "+AITown.GetName(nearestTown));
}}
if (success){
target.FixTile(stationTile);
if (target.IsTown()&&roadType==AIRoad.ROADTYPE_ROAD){
local fr=AIRoad.GetRoadStationFrontTile(stationTile);
local bk=AIRoad.GetDriveThroughBackTile(stationTile);
if (AIRoad.IsRoadTile(fr)&&AIRoad.IsRoadTile(bk)&&(AIRoad.GetNeighbourRoadCount(fr)==2||AIRoad.GetNeighbourRoadCount(bk)==2)&&(loop != null && loop.GetParent() != null&&AIRoad.CanBuildConnectedRoadPartsHere(otherSide, stationTile, loop.GetParent().GetTile()) > 0)){
local looped = (PathWrapper.BuildPath(loop, roadType) == 0);
			if(looped){
			// Join the path and the loop to the station tile
			RoadManager.SafelyBuildRoad(otherSide, stationTile);
			RoadManager.SafelyBuildRoad(roadTile, stationTile);
local lt=AITileList();
lt.AddTile(stationTile);
local parz=null;
local tz=null;
local pa=loop;
while (pa != null&&pa!=false) {
		tz=pa.GetTile();
if (AIMap.IsValidTile(tz))lt.AddTile(tz);

		parz = pa.GetParent();
		pa=parz;
}
local nt=AITileList();
local tt=-1;
foreach(tile,_ in lt){
for (local ac=0;ac<=3;ac++){
switch(ac){
case 0:
tt=tile+1;break;
case 1:
tt=tile-1;break;
case 2:
tt=tile+AIMap.GetMapSizeX();break;
case 3:
tt=tile-AIMap.GetMapSizeX();break;
}
if (!lt.HasItem(tt)&&AIMap.IsValidTile(tt)&&AIRoad.IsRoadTile(tt)&&AIRoad.HasRoadType(tt,roadType)&&AITile.GetOwner(tt)==AICompany.COMPANY_INVALID&&!AIRoad.AreRoadTilesConnected(tt,tile)){
local ttt=tt+tt-tile;
if(AIMap.IsValidTile(ttt)&&AIRoad.IsRoadTile(ttt)&&AIRoad.HasRoadType(ttt,roadType)&&AIRoad.AreRoadTilesConnected(ttt,tt)){
if(abs(tt-tile)==1){
local at1=tt+AIMap.GetMapSizeX();
local at2=tt-AIMap.GetMapSizeX();
if((!AIMap.IsValidTile(at1)||!AIRoad.IsRoadTile(at1)||!AIRoad.HasRoadType(at1,roadType)||!AIRoad.AreRoadTilesConnected(at1,tt))&&(!AIMap.IsValidTile(at2)||!AIRoad.IsRoadTile(at2)||!AIRoad.HasRoadType(at2,roadType)||!AIRoad.AreRoadTilesConnected(at2,tt))){
AIRoad.SetCurrentRoadType(roadType);
AIRoad.BuildRoad(tt,tile);
}
}else{
local at1=tt+1;
local at2=tt-1;
if((!AIMap.IsValidTile(at1)||!AIRoad.IsRoadTile(at1)||!AIRoad.HasRoadType(at1,roadType)||!AIRoad.AreRoadTilesConnected(at1,tt))&&(!AIMap.IsValidTile(at2)||!AIRoad.IsRoadTile(at2)||!AIRoad.HasRoadType(at2,roadType)||!AIRoad.AreRoadTilesConnected(at2,tt))){
AIRoad.SetCurrentRoadType(roadType);
AIRoad.BuildRoad(tt,tile);
}}
}else{
nt.AddTile(tt);
}}}}
local rt=AITileList();
while(!nt.IsEmpty()){
local ftt=-1;
foreach(ttt,_ in nt){
local fz=0;
for (local ac=0;ac<=3;ac++){
switch(ac){
case 0:
ftt=ttt+1;break;
case 1:
ftt=ttt-1;break;
case 2:
ftt=ttt+AIMap.GetMapSizeX();break;
case 3:
ftt=ttt-AIMap.GetMapSizeX();break;
}
if (AIMap.IsValidTile(ftt)&&AIRoad.IsRoadTile(ftt)&&AIRoad.HasRoadType(ftt,roadType)&&AIRoad.AreRoadTilesConnected(ftt,ttt))fz++;
}
if (fz<2){
 rt.AddTile(ttt);
}}
if (rt.IsEmpty())break;
foreach(r,_ in rt)AITile.DemolishTile(r);
nt.RemoveList(rt);
rt.Clear();
}
}}}}
if(!success) {
			switch(AIError.GetLastError()) {
				case AIRoad.ERR_ROAD_DRIVE_THROUGH_WRONG_DIRECTION:
					// This shouldn't happen. Try to clear the tile, and if 
					// that doesn't work then just give up. 
					if(attempts <= 1) {
						//AITile.DemolishTile(stationTile);
					} else {
						break;
					}
				break;
				case AIError.ERR_AREA_NOT_CLEAR:
					// Something must have been built since we checked the tile. Clear it.
if (!AITile.IsWaterTile(stationTile)&&!AIRoad.IsRoadDepotTile(stationTile)&&!AIRoad.IsRoadStationTile(stationTile)&&!AIRoad.IsDriveThroughRoadStationTile(stationTile))					AITile.DemolishTile(stationTile);
				break;
				case AIError.ERR_NOT_ENOUGH_CASH:
					if(!FinanceManager.CanAfford((PathZilla.FLOAT)/2)) {
						// We cant afford to borrow any more money, so give up!
(::german)?AILog.Error("      Brauche mehr Geld!!!"):AILog.Error("      CAN'T AFFORD IT - ABORTING!");
						break;
					} else {
						// Otherwise, borrow some more money
						FinanceManager.Borrow();
					}
				break;
				case AIError.ERR_VEHICLE_IN_THE_WAY:
					// Theres a vehicle in the way... just wait a bit.
					PathZilla.Sleep(80);
				break;
				// NO idea what to do here! Just give up.
				case AIError.ERR_UNKNOWN:
						break;
				break;
			}
		}

	}
	
	if(!success) {

		local strType = (truckStation) ? "TRUCK" : ((roadType == AIRoad.ROADTYPE_TRAM) ? "TRAM" : "BUS");
//		AILog.Warning(strType + " STOP WAS NOT BUILT");
	}

	if (success){


 return AIStation.GetStationID(stationTile) ;
}}


return (success) ? AIStation.GetStationID(stationTile) : -1;
}

/*
 * Build a road from tileA to tileB, handling any errors that may occur.
 */
function RoadManager::SafelyBuildRoad(tileA, tileB, tqk=20) {

	local built = false;
	local tries = 0;
	local MAX_TRIES = tqk;
	
	while(!built && tries++ < MAX_TRIES) {
		built = AIRoad.BuildRoad(tileA, tileB);
		
		if(!built) {
			switch(AIError.GetLastError()) {
				case AIError.ERR_ALREADY_BUILT:
					// Just don't worry about this!
					built = true;
				break;
				case AIError.ERR_AREA_NOT_CLEAR:
					// Something must have been built since we check the tile. Clear it.
					local cleared=true;
					if (!(AIRoad.IsRoadStationTile(tileB)||AIRoad.IsRoadDepotTile(tileB)||AIRoad.IsDriveThroughRoadStationTile(tileB)||AIBridge.IsBridgeTile(tileB)||AITunnel.IsTunnelTile(tileB))){					
					cleared = AITile.DemolishTile(tileB);
					}
					if(!cleared) {
(::german)?AILog.Error("    Kann Platz fuer Haltestelle nicht raeumen!"):AILog.Error("    Construction of bus stop was blocked");
						return cleared;
					}
				break;
				case AIError.ERR_NOT_ENOUGH_CASH:
(::german)?AILog.Error("        GELD REICHT NICHT!"):AILog.Error("        CAN'T AFFORD IT!");
					if(!FinanceManager.CanAfford(PathZilla.FLOAT)) {
						// We cant afford to borrow any more money, so give up!
(::german)?AILog.Error("          BAU ABGEBROCHEN!!"):AILog.Error("          ABORT!!");
						return false;
					} else {
						// Otherwise, borrow some more money
						FinanceManager.EnsureFundsAvailable(PathZilla.FLOAT*10);
					}
				break;
				case AIError.ERR_VEHICLE_IN_THE_WAY:
(::german)?AILog.Error("        Fahrzeug im Weg..."):AILog.Error("        Vehicle in the way");
					// Theres a vehicle in the way... just wait a bit.
					PathZilla.Sleep(80);
				break;
			}
		}
	}
	
	return built;
}

/*
 * Build a depot at the specified target if none exits
 */
function RoadManager::BuildDepot(target, roadType, direction=0,town=false,mustBuild=false,t2=-1) {

AIRoad.SetCurrentRoadType(roadType);
local success=false;
local nxdep=99999;
local tww=AIStation.GetNearestTown(target);
local strType = ((::german)?((roadType == AIRoad.ROADTYPE_ROAD) ? "D" : "Strassenbahnd"):(roadType == AIRoad.ROADTYPE_ROAD) ? "road" : "tram");
(::german)?AILog.Info("  Suche nach einem " + strType + "epot in der Naehe von " + AIStation.GetName(target) + "..."):AILog.Info("  Checking for a " + strType + " depot near " + AIStation.GetName(target) + "...");
	local targetTile = AIStation.GetLocation(target);

	AIRoad.SetCurrentRoadType(roadType);

	// Check for existing depots in the town
	local depots = AIDepotList(AITile.TRANSPORT_ROAD);
	depots.Valuate(AIRoad.HasRoadType, roadType);
	depots.KeepValue(1);
	if(town) {
		foreach(depot, _ in depots) {
			local inTown = AITown.IsWithinTownInfluence(tww, depot);
			depots.SetValue(depot, (inTown) ? 1 : 0);
		}
		depots.KeepValue(1);
		depots.Valuate(AITile.GetDistanceManhattanToTile, targetTile);
if (!depots.IsEmpty())nxdep=depots.GetValue(depots.Begin());

		if (mustBuild){
depots.KeepBelowValue(4);
}else{
depots.KeepBelowValue(7);
}

	} else {
		depots.Valuate(AITile.GetDistanceManhattanToTile, targetTile);
if (!depots.IsEmpty())nxdep=depots.GetValue(depots.Begin());

		if (mustBuild){
depots.KeepBelowValue(4);
}else{
depots.KeepBelowValue(7);
}
		foreach(depot, _ in depots) {
if(AIMap.DistanceManhattan(AIRoad.GetRoadDepotFrontTile(depot),targetTile)==0||(AIMap.DistanceManhattan(AIRoad.GetRoadDepotFrontTile(depot),targetTile)==1&&(AIRoad.AreRoadTilesConnected(AIRoad.GetRoadDepotFrontTile(depot),targetTile)||AIRoad.BuildRoad(AIRoad.GetRoadDepotFrontTile(depot),targetTile)||AIRoad.AreRoadTilesConnected(AIRoad.GetRoadDepotFrontTile(depot),targetTile)))){
			depots.SetValue(depot, 1);
break;
}
			local value=0;			
			local rcheck=PathWrapper.FindPath(AIRoad.GetRoadDepotFrontTile(depot),targetTile,roadType,[],false,[PathWrapper.FEAT_NO_WORMHOLES,PathWrapper.FEAT_DEPOT_ALIGN]);
			local rrq=false;			
local qtl=null;
	AIRoad.SetCurrentRoadType(roadType);
while(rcheck!=null&&rcheck!=false){
			local toq=rcheck.GetTile();			
			local ouq=rcheck.GetParent();
			if (ouq!=null){
			qtl=ouq.GetTile();			
if (!(AIRoad.HasRoadType(qtl,roadType)&&AIRoad.IsRoadTile(qtl)&&AIRoad.IsRoadTile(toq)&&AIRoad.HasRoadType(toq,roadType)&&AIRoad.AreRoadTilesConnected(toq,qtl))){
break;
}}else{
rrq=true;
}			
rcheck=ouq;
			}
if (rrq)value = 1; // TODO - Is depot connected to target tile
			
			depots.SetValue(depot, value);
			if (value==1)break;
		}
		depots.KeepValue(1);

	}
	
	// If there aren't any we need to build one
	if(depots.Count() > 0) {
depots.Sort(AIAbstractList.SORT_BY_VALUE, false);

success = PathWrapper.TryBuildPath(PathWrapper.FindPath(AIRoad.GetRoadDepotFrontTile(depots.Begin()), targetTile, roadType, [], true, [PathWrapper.FEAT_DEPOT_ALIGN]), AIRoad.GetRoadDepotFrontTile(depots.Begin()), targetTile, roadType,[], true, []);

}else{(::german)?AILog.Info("    Ein Fahrzeugdepot wird gebaut..."):AILog.Info("    Building a new depot...");
for (local m=7;m<32;m=m+6){
::depotList.Clear();
::tileList.Clear();
RoadManager.FindTiles(targetTile,direction,0,0,m);
::depotList.Sort(AIAbstractList.SORT_BY_VALUE, true);
foreach (depotTile,score in ::depotList){
if (nxdep<AITile.GetDistanceManhattanToTile(targetTile,depotTile))return true;
local dirTile=0;
switch (score%4){
case 0:
dirTile=AIMap.GetTileIndex(AIMap.GetTileX(depotTile),AIMap.GetTileY(depotTile)+1)
break;
case 1:
dirTile=AIMap.GetTileIndex(AIMap.GetTileX(depotTile)+1,AIMap.GetTileY(depotTile))
break;
case 2:
dirTile=AIMap.GetTileIndex(AIMap.GetTileX(depotTile),AIMap.GetTileY(depotTile)-1)
break;
case 3:
dirTile=AIMap.GetTileIndex(AIMap.GetTileX(depotTile)-1,AIMap.GetTileY(depotTile))
break;
}
if (!AIRoad.IsRoadDepotTile(depotTile)&&!AIRoad.IsRoadTile(depotTile) && !AIRoad.IsRoadStationTile(depotTile)&&!AIBridge.IsBridgeTile(depotTile) && !AITunnel.IsTunnelTile(depotTile)&&!AIRoad.IsDriveThroughRoadStationTile(depotTile)&&!AITile.IsBuildable(depotTile))AITile.DemolishTile(depotTile);
if (score>256)AITile.LevelTiles(dirTile,depotTile);
local fz=0;
TownManager.HandleRating(AITile.GetClosestTown(depotTile));
while (!AIRoad.BuildRoadDepot(depotTile, dirTile)&&AIError.GetLastError()==AIError.ERR_NOT_ENOUGH_CASH){
FinanceManager.EnsureFundsAvailable(PathZilla.FLOAT*10,fz==0);
if (fz%10==9){
SaveMoney();
}
if(AICompany.GetBankBalance(AICompany.COMPANY_SELF)<88888)		PathZilla.Sleep(1);
::pz.HandleEvents(true);
fz++
}
if (AIMap.IsValidTile(depotTile)&&AIRoad.IsRoadDepotTile(depotTile)&&AITile.GetOwner(depotTile)==AICompany.ResolveCompanyID(AICompany.COMPANY_SELF)){

local path = PathWrapper.FindPath(depotTile, dirTile, roadType, [], true, [PathWrapper.FEAT_DEPOT_ALIGN]);
if (path==null){
AITile.DemolishTile(depotTile);
success=false;
}else{
for(local ap=0;!success&&ap<9;ap++){
success=PathWrapper.TryBuildPath(path, depotTile, dirTile, roadType,[], true, [PathWrapper.FEAT_DEPOT_ALIGN])
}
if (!success||!AIRoad.AreRoadTilesConnected(depotTile,AIRoad.GetRoadDepotFrontTile(depotTile))){ AITile.DemolishTile(depotTile);success=false;}
}

}
if (success)break;
}				
if (success) break;
}
//		PathZilla.Sleep(1);
(::german)?AILog.Info("    ...fertig."):AILog.Info("    Done building depot.");
}
}

function RoadManager::FindTiles(tile, direction,otile=0, distance=0,m=0) {

local good=0;
local ntile=0;
local nntile=0;
local lntile=0;
local rntile=0;
for (local d=0;d<4;d++){
switch ((d+direction)%4){
case 0:
ntile=AIMap.GetTileIndex(AIMap.GetTileX(tile),AIMap.GetTileY(tile)-1)
nntile=AIMap.GetTileIndex(AIMap.GetTileX(tile),AIMap.GetTileY(tile)+1)
lntile=AIMap.GetTileIndex(AIMap.GetTileX(tile)+1,AIMap.GetTileY(tile))
rntile=AIMap.GetTileIndex(AIMap.GetTileX(tile)-1,AIMap.GetTileY(tile))
break;
case 1:
ntile=AIMap.GetTileIndex(AIMap.GetTileX(tile)-1,AIMap.GetTileY(tile))
nntile=AIMap.GetTileIndex(AIMap.GetTileX(tile)+1,AIMap.GetTileY(tile))
lntile=AIMap.GetTileIndex(AIMap.GetTileX(tile),AIMap.GetTileY(tile)-1)
rntile=AIMap.GetTileIndex(AIMap.GetTileX(tile),AIMap.GetTileY(tile)+1)
break;
case 2:
ntile=AIMap.GetTileIndex(AIMap.GetTileX(tile),AIMap.GetTileY(tile)+1)
nntile=AIMap.GetTileIndex(AIMap.GetTileX(tile),AIMap.GetTileY(tile)-1)
lntile=AIMap.GetTileIndex(AIMap.GetTileX(tile)+1,AIMap.GetTileY(tile))
rntile=AIMap.GetTileIndex(AIMap.GetTileX(tile)-1,AIMap.GetTileY(tile))
break;
case 3:
ntile=AIMap.GetTileIndex(AIMap.GetTileX(tile)+1,AIMap.GetTileY(tile))
nntile=AIMap.GetTileIndex(AIMap.GetTileX(tile)+1,AIMap.GetTileY(tile))
lntile=AIMap.GetTileIndex(AIMap.GetTileX(tile),AIMap.GetTileY(tile)-1)
rntile=AIMap.GetTileIndex(AIMap.GetTileX(tile),AIMap.GetTileY(tile)+1)
break;
}
local tiles=((d==2)?3:((d==0)?1:2));

	if (!AIMap.IsValidTile(ntile)||::tileList.HasItem(ntile)||!(AIRoad.IsRoadTile(ntile)||AIBridge.IsBridgeTile(ntile)||AITunnel.IsTunnelTile(ntile))||!AIRoad.AreRoadTilesConnected(ntile,tile)||distance>m||good>0){
		if (AIMap.IsValidTile(ntile)&&otile>0&&!AIRoad.IsRoadTile(ntile)&&AITile.GetOwner(ntile)==AICompany.COMPANY_INVALID&&(!AIRoad.IsDriveThroughRoadStationTile(tile)||AIRoad.GetDriveThroughBackTile(tile)==ntile||AIRoad.GetRoadStationFrontTile(tile)==ntile)&&!AITile.IsWaterTile(ntile)&&!AIBridge.IsBridgeTile(tile)&&!AITunnel.IsTunnelTile(tile)&&/*AIRoad.CanBuildConnectedRoadPartsHere(otile,tile,ntile)>0&&*/
((AIMap.GetTileX(tile)==AIMap.GetTileX(otile)&&max(AITile.GetCornerHeight(tile,AITile.CORNER_N),AITile.GetCornerHeight(tile,AITile.CORNER_W))==max(AITile.GetCornerHeight(tile,AITile.CORNER_S),AITile.GetCornerHeight(tile,AITile.CORNER_E)))||(AIMap.GetTileY(tile)==AIMap.GetTileY(otile)&&max(AITile.GetCornerHeight(tile,AITile.CORNER_N),AITile.GetCornerHeight(tile,AITile.CORNER_E))==max(AITile.GetCornerHeight(tile,AITile.CORNER_S),AITile.GetCornerHeight(tile,AITile.CORNER_W))))){
local score=(d+direction)%4+distance*4+((AITile.HasTreeOnTile(ntile))?4:0)+((AITile.IsFarmTile(ntile))?8:0)+((AITile.IsCoastTile(ntile))?8:0)+((AITile.IsBuildable(ntile))?0:16)+((!AITile.IsSteepSlope(ntile)&&AITile.GetMaxHeight(tile)==AITile.GetMaxHeight(ntile))?0:256)
if (!((AIRoad.IsRoadTile(nntile)&&AIRoad.IsRoadTile(lntile))||(AIRoad.IsRoadTile(rntile)&&AIRoad.IsRoadTile(lntile))||(AIRoad.IsRoadTile(nntile)&&AIRoad.IsRoadTile(rntile)))){
score=score+28
}
if (score<16)good++;
if (!::depotList.HasItem(ntile)||::depotList.GetValue(ntile)>score)::depotList.AddItem(ntile,score);
		}
if (::tileList.HasItem(ntile)&&distance>::tileList.GetValue(ntile)+4-tiles){
RoadManager.FindTiles(tile,direction,otile,tileList.GetValue(ntile)+4-tiles,m);
}

	continue;
	}
::tileList.AddItem(ntile,distance);
if(AIBridge.IsBridgeTile(ntile)&&AIBridge.GetOtherBridgeEnd(ntile)!=tile){
RoadManager.FindTiles(AIBridge.GetOtherBridgeEnd(ntile),direction,tile,distance+tiles*AIMap.DistanceManhattan(ntile,AIBridge.GetOtherBridgeEnd(ntile)),m);
}else if (AITunnel.IsTunnelTile(ntile)&&AITunnel.GetOtherTunnelEnd(ntile)!=tile){
RoadManager.FindTiles(AITunnel.GetOtherTunnelEnd(ntile),direction,tile,distance+tiles*AIMap.DistanceManhattan(ntile,AITunnel.GetOtherTunnelEnd(ntile)),m);
}else{
RoadManager.FindTiles(ntile,direction,tile,distance+tiles,m);
}
}
}
