import("pathfinder.road", "RoadPathFinder", 4);

 class CPU extends AIController
 {
    directions0=AIList();
    roadpathfinder=RoadPathFinder();
    constructor()
    {
        directions0.AddItem(1,0);
        directions0.AddItem(-1,0);
        AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);

        roadpathfinder.cost.max_cost=50000000
        
    }
    function BuildRoadBuilding(town_id, type, rvtype);
    function BuildBusStation();
    function walkToEndOfRoad(start,maxlen);
    function Step(from, not);
    function Start();
    
}
    //function CPU::BuildRoadAroundIndustry(industryID){
    
    //}
    function CPU::BuildRoadBuilding(tile_id, type, rvtype, avoid=0, mindist=2, range=15, tiletype=0)
    {
    	local depot_placement_tiles = AITileList();
	    local town_loc = tile_id;
    	depot_placement_tiles.AddRectangle(town_loc - AIMap.GetTileIndex(range, range),
    	    town_loc + AIMap.GetTileIndex(range, range));

	    AILog.Info("Building new depot");

        AILog.Info("Rectangle Select: "+depot_placement_tiles.IsEmpty());
	    // Only consider tiles that are buildable
	    depot_placement_tiles.Valuate(AITile.IsBuildable);
	    depot_placement_tiles.KeepValue(1);

	    AILog.Info("Buildable: "+depot_placement_tiles.IsEmpty());
        if (AIMap.IsValidTile(avoid)){
            depot_placement_tiles.Valuate(AIMap.DistanceManhattan, avoid);
            depot_placement_tiles.KeepAboveValue(mindist);
            AILog.Info("Distance min: "+depot_placement_tiles.IsEmpty());
        }
	    // search from town center and outwards
	    depot_placement_tiles.Valuate(AIMap.DistanceManhattan, town_loc);
	    depot_placement_tiles.Sort(AIList.SORT_BY_VALUE, true); // highest value last

	    // try with all tiles until a working one is found
	    local depot_tile = depot_placement_tiles.Begin();
	    local first;
	    local second;
	    while(!depot_placement_tiles.IsEnd())
	    {
	    	//AILog.Info("Trying to build depot/station at tile " + depot_tile);
	    	if (type==0 && GetSetting("Build_Debug_signs")){
	    	    AISign.BuildSign(depot_tile, "build depot");
	    	}
	    	else if (type==1 && GetSetting("Build_Debug_signs")){
                AISign.BuildSign(depot_tile, "build station");
	    	}
    
	    	local depot = true;
	    	first=Step(depot_tile,depot_tile, tiletype);
	    	second=Step(first, depot_tile, tiletype);
	    	if (type==0){
	    	    if(AIRoad.CanBuildConnectedRoadPartsHere(first, depot_tile, second) && AIRoad.BuildRoadDepot
	    	          (depot_tile,first)){
	    	        
	    	        AIRoad.BuildRoad(first,depot_tile);
	    	        AILog.Info("Build Depo!");
	    		    break;			
                }
            }
            else if (type==1)
                if(AIRoad.CanBuildConnectedRoadPartsHere(first, depot_tile, second) && AIRoad.BuildRoadStation
	    	          (depot_tile,first, rvtype, AIStation.STATION_JOIN_ADJACENT)){
	    	        AIRoad.BuildRoad(first,depot_tile);
	    	        AILog.Info("Build Road Station!");
	    		    break;			
                }
	    	depot_tile = depot_placement_tiles.Next();
	    }
    
	    
    
	    // depot built likely is equal to no buses yet in town.
	    return depot_tile;
        }
    function BuildDriveThrewRoadBuilding(tile_id,rvtype,range,not,r)
    {
        AILog.Info("Building drive threw")
        local depot_placement_tiles = AITileList();
	    local town_loc = tile_id;
    	depot_placement_tiles.AddRectangle(town_loc - AIMap.GetTileIndex(range, range),
    	    town_loc + AIMap.GetTileIndex(range, range));
        AILog.Info(depot_placement_tiles.IsEmpty());
        depot_placement_tiles.Valuate(AIRoad.IsRoadTile);
        depot_placement_tiles.KeepValue(1);
        AILog.Info(depot_placement_tiles.IsEmpty());
        depot_placement_tiles.Valuate(AIMap.DistanceManhattan,town_loc);
        depot_placement_tiles.Sort(AIList.SORT_BY_VALUE, true);
        AILog.Info(depot_placement_tiles.IsEmpty());
        local tile;
        local tile = depot_placement_tiles.Begin();
        while(!depot_placement_tiles.IsEnd())
	    {
	        AILog.Info("Tried a place")
	        if (AIRoad.BuildDriveThroughRoadStation(tile,
	                                            Step(tile,tile,0),
	                                            rvtype,
	                                            AIStation.STATION_JOIN_ADJACENT)
	                                            )
	        {
            AILog.Info("Build Drive Threw")
	        return tile;}
	        
	        tile=depot_placement_tiles.Next()
        }
        AILog.Info("Failed")
        return 0;
        
        
    }
    function FindBusBuilding(tile_id, type, rvtype, range=15, not=0){
            local depot_placement_tiles = AITileList();
	        local town_loc = tile_id;
    	    depot_placement_tiles.AddRectangle(town_loc - AIMap.GetTileIndex(range, range), town_loc + 
    	        AIMap.GetTileIndex(range, range));
            if (type==0){
    	    depot_placement_tiles.Valuate(AIRoad.IsRoadDepotTile);
    	    }
    	    else if (type==1){
    	    depot_placement_tiles.Valuate(AIRoad.IsRoadStationTile);
    	    }
    	    depot_placement_tiles.KeepValue(1);
    	    depot_placement_tiles.Valuate(AITile.GetOwner);
    	    depot_placement_tiles.KeepValue(AICompany.ResolveCompanyID(AICompany.COMPANY_SELF)); 
    	    //if (type==1){
    	    //    
    	    //}
    	    depot_placement_tiles.Valuate(AIMap.DistanceManhattan, town_loc);
	        depot_placement_tiles.Sort(AIList.SORT_BY_VALUE, true); // highest value last
	        
	        local depot_tile = depot_placement_tiles.Begin();
	        //local stationID;
            while(!depot_placement_tiles.IsEnd())
	        {
	            if (depot_tile!=not){
	            return depot_tile;
	            }
                depot_tile=depot_placement_tiles.Next();
	        }
	        return 0;

	    }
	function BuildOrFind(tile, drivt, type, rvtype, avoid=0, mindist=2, range=15, tiletype=0){
	    local found=FindBusBuilding(tile, type, rvtype, range, avoid);
	    if (found){
	        return found;}
	    else if (drivt){
	        return BuildDriveThrewRoadBuilding(tile, rvtype, range, avoid, mindist);
	    }
	    else{
        
	        return BuildRoadBuilding(tile, type, rvtype, avoid, mindist, range, tiletype)
	    }
	    }
	
    function CPU::BuildBusStation()
    {
        local towns=AITownList()
        towns.Valuate(AITown.GetPopulation);
        towns.KeepAboveValue(GetSetting("Min_city_size"));
		towns.Sort(AIList.SORT_BY_VALUE, false);
		local biggest=towns.Begin();
		
		while (AITown.GetLastMonthTransportedPercentage(biggest,ReturnOfType
		        (AICargo.CC_PASSENGERS))>GetSetting("competivity")){
		    biggest=towns.Next();
		    if (!biggest){
		        return;
		    }
		}
		AILog.Info("Building Depo..."+AITown.GetName(biggest));
		local BusStop1=BuildOrFind(AITown.GetLocation(biggest), 1, 1, AIRoad.ROADVEHTYPE_BUS);
		if (!BusStop1){
		    return;
		    }
		local DepotLocation=BuildOrFind(AITown.GetLocation(biggest), 0, 0, 0, 0);
		if (!DepotLocation){
		    return;
		    }
		local BusStop2=BuildRoadBuilding(AITown.GetLocation(biggest), 1, AIRoad.ROADVEHTYPE_BUS, BusStop1,
		    2+(AITown.GetPopulation(AITown.GetLocation(biggest))/1000));
		if (!BusStop2){
		    return;
		    }
		local engine=FindRoadVeicle(ReturnOfType(AICargo.CC_PASSENGERS));
		local bus=AIVehicle.BuildVehicle(DepotLocation,engine);
            AILog.Info(AIError.GetLastErrorString()+AIEngine.GetName(engine));
		if (!AIOrder.AppendOrder(bus, BusStop1, AIOrder.OF_NONE)){
		    AILog.Info(AIError.GetLastErrorString());
		}
		if (!AIOrder.AppendOrder(bus, BusStop2, AIOrder.OF_NONE)){
		    AILog.Info(AIError.GetLastErrorString());
		}
		
		AIVehicle.StartStopVehicle(bus);
                BuildRoute([AIRoad.GetRoadStationFrontTile(BusStop1)],[AIRoad.GetRoadStationFrontTile(BusStop2)]);
                BuildRoute([AIRoad.GetDriveThroughBackTile(BusStop1)],[AIRoad.GetRoadStationFrontTile(BusStop2)]);
		//qvrx
		
	}
	function CPU::FindRoadVeicle(CargoID){
	        local engineList=AIEngineList(AIVehicle.VT_ROAD);
		    engineList.Valuate(AIEngine.GetCargoType);
		    engineList.KeepValue(CargoID);
		    engineList.Valuate(AIEngine.GetCapacity);
		    engineList.KeepAboveValue(10);
		    engineList.Valuate(AIEngine.GetMaxSpeed);
		    engineList.Sort(AIList.SORT_BY_VALUE, false);
                engineList.Valuate(AIEngine.GetRoadType);
		    engineList.KeepValue(AIRoad.GetCurrentRoadType());
		    return engineList.Begin();
	    }
	function CPU::CompleteSubsidy(SubsidyID)
	{
	    AILog.Info("Completing Subsidy!")
	    local sorce=AISubsidy.GetSourceIndex(SubsidyID);
	    local destination=AISubsidy.GetDestinationIndex(SubsidyID);
	    local station1;
	    local station2;
	    local tiletype1=0;
	    local tiletype2=0;
	    local rvtype=AIRoad.ROADVEHTYPE_TRUCK;
	    local cargoID=AISubsidy.GetCargoType(SubsidyID);
	    if (AISubsidy.GetSourceType(SubsidyID)==AISubsidy.SPT_INDUSTRY){
	        
	        station1=AIIndustry.GetLocation(sorce);
	        tiletype1=1;
	        }
	    else{
	        station1=AITown.GetLocation(sorce);
	    }
	    if (AISubsidy.GetDestinationType(SubsidyID)==AISubsidy.SPT_INDUSTRY){
	        station2=AIIndustry.GetLocation(destination);
	        tiletype2=1;
	        }
	    else{
	        station2=AITown.GetLocation(destination);
	    }
	    if (AICargo.HasCargoClass(cargoID, AICargo.CC_PASSENGERS)){
	        rvtype=AIRoad.ROADVEHTYPE_BUS;}
	    if (AISubsidy.GetSourceType(SubsidyID)==AISubsidy.SPT_INDUSTRY)
	        if (
	               AIIndustry.GetLastMonthProduction(sorce,cargoID)*AICargo.GetCargoIncome(cargoID,
	               AIMap.DistanceManhattan(station1,station2),20)<1000){
	        AILog.Info("Subsidy is not profitable")
	        return;
	        }
	    station1=BuildOrFind(station1, 0, 1, rvtype, 0, 0, 4, tiletype1);
	    station2=BuildOrFind(station2, 0, 1, rvtype, 0, 0, 4,tiletype2);
	    local depo=BuildRoadBuilding(station2, 0, 0, rvtype); //finish
	    if (!station1 || !station2 || !depo){
            return;
	    }
	    //PlanRoute
	    BuildRoute([AIRoad.GetRoadStationFrontTile(station1),
	                                              ], 
	                                             [AIRoad.GetRoadStationFrontTile(station2),
	                                             
	                                              AIRoad.GetRoadDepotFrontTile(depo)]);
        
	    local engine=FindRoadVeicle(cargoID);
	    local bus=AIVehicle.BuildVehicle(depo, engine);
	    if (!AIOrder.AppendOrder(bus, station1, AIOrder.OF_NONE)){
		    AILog.Info(AIError.GetLastErrorString());
		}
		if (!AIOrder.AppendOrder(bus, station2, AIOrder.OF_NONE)){
		    AILog.Info(AIError.GetLastErrorString());
		}
        
		local number=GetSetting("Veicle_number_multiplyer")*AIMap.DistanceManhattan(station1,station2)/AIEngine.GetMaxSpeed(engine);
		AILog.Info(number);
        while (number>1){
            
		    AILog.Info(number+" remaining");
            local bus2=AIVehicle.CloneVehicle(depo,bus,true);
            AILog.Info(AIError.GetLastErrorString()); ///////////
            if (!AIVehicle.StartStopVehicle(bus2)){
                
		            
                }
            AIController.Sleep(10);
            number-=1;
        }
		
		AIVehicle.StartStopVehicle(bus);
	    
	    
	}
	function CPU::BuildRoute(sourcetiles, destinationtiles){
	    AILog.Info(roadpathfinder.InitializePath(sourcetiles,destinationtiles));
	    local path = false;
	    AILog.Info("Pathfinding...")
          while (path == false) {
             path = roadpathfinder.FindPath(100);
             AIController.Sleep(1);
           }
        AILog.Info("Completed, building route")
        //building route
        AILog.Info("Building Route")
        local distance=0
        if (path==null) {
            return;
        }
        while (path != null) {
            local par = path.GetParent();
            if (par != null) {
            local last_node = path.GetTile();
            if (AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) == 1 ) {
                if (!AIRoad.BuildRoad(path.GetTile(), par.GetTile())) {
                    /* An error occurred while building a piece of road. TODO: handle it. 
                    * Note that this could mean the road was already built. */
                }
                distance+=1;
            } else {
            /* Build a bridge or tunnel. */
            if (!AIBridge.IsBridgeTile(path.GetTile()) && !AITunnel.IsTunnelTile(path.GetTile())) {
                /* If it was a road tile, demolish it first. Do this to work around expended roadbits. */
            if (AIRoad.IsRoadTile(path.GetTile())) AITile.DemolishTile(path.GetTile());
                if (AITunnel.GetOtherTunnelEnd(path.GetTile()) == par.GetTile()) {
            if (!AITunnel.BuildTunnel(AIVehicle.VT_ROAD, path.GetTile())) {
            /* An error occured while building a tunnel. TODO: handle it. */
          }
          } else {
            local bridge_list = AIBridgeList_Length(AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) + 1);
            bridge_list.Valuate(AIBridge.GetMaxSpeed);
            bridge_list.Sort(AIList.SORT_BY_VALUE, false);
            if (!AIBridge.BuildBridge(AIVehicle.VT_ROAD, bridge_list.Begin(), path.GetTile(), par.GetTile())) {
                /* An error occured while building a bridge. TODO: handle it. */
          }
        }
        }
        }
        }
        path = par;
        }
	}
	function CPU::ClearNegetiveIncomeVeicles() {
	    AILog.Info("Finding - Income Veicles")
	    local busses=AIVehicleList();
	    busses.Valuate(AIVehicle.GetProfitThisYear);
	    busses.KeepBelowValue(-250);
	    AILog.Info(busses.Count()+" Busses with - profit this year");
	    busses.Valuate(AIVehicle.GetProfitLastYear);
	    busses.KeepBelowValue(-250);
	    AILog.Info(busses.Count()+" Busses with - profit last year");
	    foreach (bus, n in busses){
	        if (AIOrder.IsCurrentOrderPartOfOrderList(bus)){
	        AIVehicle.SendVehicleToDepot(bus);
	        }
	    }
	    local busses=AIVehicleList();
	    busses.Valuate(AIVehicle.IsStoppedInDepot);
	    busses.KeepValue(1);
	    foreach (bus, n in busses){
	        AIVehicle.SellVehicle(bus);
	    }
	}
    function CPU::ReturnOfType(type){
        local list = AICargoList();
        local pass_cargo = -1;
        for (local cargo = list.Begin(); !list.IsEnd(); cargo = list.Next()) {
            if (AICargo.HasCargoClass(cargo, type)) {
                //AILog.Info("Found a suitable cargo type! "+AICargo.GetCargoLabel(cargo));
                pass_cargo = cargo;
                return cargo;
        return pass_cargo;
  }
}
    } 
    function CPU::walkToEndOfRoad(start,maxlen){
        previous=start;
        current=start;
        next=start;
        num=0;
        while (current!=0 && num<maxlen){
            next=Step(current, previous);
            previous=current;
            current=next;
            num+=1;
            }
        return previous;
    }
    function CPU::Step(from, not, tiletype){
        local fx=AIMap.GetTileX(from);
        local fy=AIMap.GetTileY(from);
        local prex;
        local prey;
        local b;
        local c;
        local x;
        local y;
        local tileindex;
        foreach(prex in [-1,1]){
            foreach(prey in [-1,1]){
                if (prey==-1){
                    x=prex;
                    y=0;
                    }
                else if (prey==1){
                    x=0;
                    y=prex;
                    }
                tileindex=AIMap.GetTileIndex(fx+x,fy+y);
                if (tileindex!=not && ((tiletype==0  && AIRoad.IsRoadTile(tileindex))||
                               (tiletype==1 && AITile.IsBuildable(tileindex)))){
                
                    //AILog.Info("Old Loc "+AIMap.GetTileX(from)+","+
                    //           AIMap.GetTileY(from));
                    //AILog.Info("New Loc "+AIMap.GetTileX(tileindex)+","+
                    //           AIMap.GetTileY(tileindex));
                    return tileindex;
                }
            }
        }
        return not;
    }
    
 
 
 
    function CPU::Start() {
        AILog.Info("TestAI Started.");
        SetCompanyName();
        AICompany.SetAutoRenewStatus(true);
        //set a legal railtype. 
        local types = AIRailTypeList();
        AIRail.SetCurrentRailType(types.Begin());
        local towns = AITownList();
        //Keep running. If Start() exits, the AI dies.
        local step=-2;
        while (true) {
            this.Sleep(100);
            
            step+=1;
            while (AIEventController.IsEventWaiting()) {
                AILog.Info("We have a Event")
                local e = AIEventController.GetNextEvent();
                switch (e.GetEventType()) {
                    case AIEvent.ET_VEHICLE_CRASHED:
                        local ec = AIEventVehicleCrashed.Convert(e);
                        local v  = ec.GetVehicleID();
                        AILog.Info("We have a crashed vehicle (" + v + ")");
                        /* Handle the crashed vehicle */
                        if (AIVehicle.GetVehicleType(v)==AIVehicle.VT_ROAD){
                            local depo=FindBusBuilding(ec.GetCrashSite(),0,0,30,0);
                            local bus2=AIVehicle.CloneVehicle(depo,v,true);
                            AIVehicle.StartStopVehicle(bus2);
                            AILog.Info(AIVehicle.GetName(bus2));
                        }
                        break;
                    case AIEvent.ET_SUBSIDY_OFFER:
                        AILog.Info("We have a subsidy!")
                        local ec = AIEventSubsidyOffer.Convert(e);
                        local v=ec.GetSubsidyID();
                        if (AICompany.GetBankBalance(AICompany.COMPANY_SELF)>50000 && GetSetting("Complete_Subsidies")){
                            CompleteSubsidy(v);
                        }
                    }
                    
            
  
            }
            if (step%20==0){
                if (AICompany.GetBankBalance(AICompany.COMPANY_SELF)>15000){
                    //AILog.Info("Building Station again");
                    BuildBusStation();
                }
                //if (AIDate.GetMonth(AIDate.GetCurrentDate())==12){
                ClearNegetiveIncomeVeicles();
                //}
            }
            
                
     
   }
 }
 
 function CPU::Save()
 {
   local table = {};	
   //TODO: Add your save data to the table.
   return table;
 }
 
 function CPU::Load(version, data)
 {
   AILog.Info(" Loaded");
   //TODO: Add your loading routines.
 }
 
 
 function CPU::SetCompanyName()
 {
   if(!AICompany.SetName("CPU")) {
     local i = 2;
     while(!AICompany.SetName("CPU #" + i)) {
       i = i + 1;
       if(i > 255) break;
     }
   }
   AICompany.SetPresidentName("computer");
 }
