/*
 * This file is part of TownCars, which is an AI for OpenTTD
 * Copyright (C) 2009  Leif Linse
 *
 * TownCars is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * TownCars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TownCars; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

// min OpenTTD nightly: 2009-01-18

class TownCars extends AIInfo {
	function GetAuthor()      { return "Zuu"; }
	function GetName()        { return "TownCars"; }
	function GetShortName()            { return "TCAR"; }
	function GetDescription() { return "Builds random cars on your streets if you have a GRF with cars. See help on URL"; }
	function GetURL() { return "http://junctioneer.net/o-ai/TCAR"; }
	function GetVersion()     { return 5; }
	function MinVersionToLoad() { return 1; }
	function GetDate()        { return "2011-03-25"; }
	function CreateInstance() { return "TownCars"; }
	function UseAsRandomAI()  { return false; }


	function GetSettings() {
		AddSetting({name = "num_cars_total", description = "Maximum total number of cars to build", easy_value = 500, medium_value = 500, hard_value = 500, custom_value = 500, flags = 0, min_value = 1, max_value = 1000000});
		AddSetting({name = "num_cars_per_town", description = "Number of cars per town to build", easy_value = 5, medium_value = 10, hard_value = 20, custom_value = 10, flags = 0, min_value = 1, max_value = 1000});
		AddSetting({name = "build_only_zero_price_rvs", description = "Only build zero price RVs", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = AICONFIG_BOOLEAN});
		AddSetting({name = "build_only_zero_running_cost_rvs", description = "Only build zero running cost RVs", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN});
		AddSetting({name = "build_only_zero_capacity_rvs", description = "Only build zero capacity RVs", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN});
		AddSetting({name = "build_only_if_cargo_type_is_pax", description = "Only build RVs that carry PAX", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = AICONFIG_BOOLEAN});
		AddSetting({name = "debug_signs", description = "Enable building debug signs", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN});
	}

}

/* Tell the core we are an AI */
RegisterAI(TownCars());
