/**
 * Class that handles company HQ building.
 */
class AIBuildCompanyHQAction extends InstantAction
{
/* public */
	function GetName()
	{
		return "Building my HQ";
	}

	function Execute()
	{
		AICompany.SetLoanAmount(AICompany.GetMaxLoanAmount());

		local town_list = AITownList();
		town_list.Valuate(AITown.GetPopulation);
		town_list.Sort(AIList.SORT_BY_VALUE, false);
		town_list.KeepTop(10);

		town_list.Valuate(function(t) { return AIBase.RandRange(100);});
		town_list.Sort(AIList.SORT_BY_VALUE, false);

		foreach (town_id, dummy in town_list) {
			local list = AITileList();
			local location = AITown.GetLocation(town_id);
			TileUtils.AddSimmetricRectangleSafe(list, location, 25, 25);

			list.Valuate(AITile.IsBuildableRectangle, 2, 2);
			list.RemoveValue(0);

			list.Valuate(AIMap.DistanceSquare, location);
			list.Sort(AIList.SORT_BY_VALUE, true);
			foreach (t, dummy in list) {
				if (AICompany.BuildCompanyHQ(t)) return town_id;
			}
		}
		return -1;
	}

	function HandleResult(result)
	{
		local msg = !AITown.IsValidTown(result) ? "Failed to build company HQ" :
			"HQ built near " + AITown.GetName(result);
		CodeUtils.Log(msg, 2);
		return 0;
	}
}
