/**
 * Class that handles vehicles selling.
 */
class SellLostVehiclesTask extends Terron_Task
{
/* public */
	/** Name prefix to mark vehicles to sell. */
	static special_sell_name = "Sally";

/* protected */
	function Execute()
	{
		local vehicles = AIVehicleList();
		local sally_list = AIList();

		local sell_name = SellLostVehiclesTask.special_sell_name;
		local n = sell_name.len();
		foreach (v, dummy in vehicles) {
			if (!AIVehicle.IsValidVehicle(v)) continue;

			local v_name = AIVehicle.GetName(v); 
			if (v_name == null || v_name.len() < n) continue;
			v_name = v_name.slice(0, n);
			if (v_name == sell_name) sally_list.AddItem(v, dummy);
		}

		/* Add to sell - those with 0 orders... */
		vehicles.Valuate(AIOrder.GetOrderCount);
		vehicles.KeepValue(0);

		/* ...all planes with orders count != 4... */
		local av_list = AIVehicleList();
		av_list.Valuate(AIVehicle.GetVehicleType);
		av_list.KeepValue(AIVehicle.VT_AIR);

		/* ...planes not assigned to any air trade route... */
		local invalid_aircrafts_list = AIList();
		foreach (v, dummy in av_list) {
			local echo = {v = v, response_received = false};
			AircraftEchoEvent.Fire(echo);
			if (!echo.response_received) invalid_aircrafts_list.AddItem(v, v);
		}

		av_list.Valuate(AIOrder.GetOrderCount);
		av_list.RemoveValue(4);
		vehicles.AddList(av_list);
		vehicles.AddList(invalid_aircrafts_list);
		
		/* ... and those which already marked by 'special_sell_name' */
		vehicles.AddList(sally_list);

		vehicles.Valuate(AIVehicle.GetState);

		foreach (v, state in vehicles) {
			if (AIVehicle.IsStoppedInDepot(v)) {
				AIVehicle.SellVehicle(v);
				continue;
			}

			if (AIVehicle.IsInDepot(v)) {
				if (AIVehicle.SellVehicle(v)) continue;
				if (AIVehicle.StartStopVehicle(v)) {
					AIController.Sleep(1);
					if (!AIVehicle.SellVehicle(v)) AIVehicle.StartStopVehicle(v);
				}
				continue;
			}
			AIVehicle.SendVehicleToDepot(v);
		}

		/* Account corporation month income */
		vehicles = AIVehicleList();
		local profit = 0;

		vehicles.Valuate(AIOrder.GetOrderCount);
		vehicles.RemoveValue(0);

		vehicles.Valuate(AIVehicle.GetProfitLastYear);
		foreach (v, profit_last_year in vehicles) {
			profit += profit_last_year;
		}
		vehicles.Valuate(AIVehicle.GetProfitThisYear);
		foreach (v, profit_this_year in vehicles) {
			profit += profit_this_year;
		}

		profit = profit / (12 + AIDate.GetMonth(AIDate.GetCurrentDate()));

		local my_id = AICompany.ResolveCompanyID(AICompany.COMPANY_SELF);
		local COST = AIInfrastructure.GetMonthlyInfrastructureCosts;
		profit = profit - COST(my_id, AIInfrastructure.INFRASTRUCTURE_ROAD);
		profit = profit - COST(my_id, AIInfrastructure.INFRASTRUCTURE_STATION);
		profit = profit - COST(my_id, AIInfrastructure.INFRASTRUCTURE_AIRPORT);
		profit = profit - COST(my_id, AIInfrastructure.INFRASTRUCTURE_CANAL);

		//profit = profit - COST(my_id, AIInfrastructure.INFRASTRUCTURE_RAIL);
		//profit = profit - COST(my_id, AIInfrastructure.INFRASTRUCTURE_SIGNALS);
		local base_loan = 1.0 * AIGameSettings.GetValue("difficulty.max_loan");
		CorporationUtils.SetInflation(AICompany.GetMaxLoanAmount() / base_loan);

		/* If something stuck in depot => launch it */
		vehicles.Valuate(AIVehicle.IsStoppedInDepot);
		vehicles.RemoveValue(0);
		foreach (v, state in vehicles) {
			AIVehicle.StartStopVehicle(v);
		}
	}

/* private */
}
