/**
 * Class that handles corporation naming.
 */
class AISetCompanyNameAction extends InstantAction
{
/* public */
	constructor()
	{
		::InstantAction.constructor();

		this.name_array = [];
		local names = ["Acme Labs", "Advanced Capital Ventures", "Awesome Express",
					"Hercules", "Far Go Inc.", "Brackenton Line",
					"Something Awesome", "UniTrans"];
 
		while (names.len() > 0) {
			local index = AIBase.RandRange(names.len());
			this.name_array.push(names[index]);
			names.remove(index);
		}

		if (name_array.len() == 0) name_array.append("Terron AI");
	}

	function GetName()
	{
		return "Choosing Company Name";
	}

/* protected */
	function Execute()
	{
		foreach (name in this.name_array) {
			if (AICompany.SetName(name)) return name;
		}

		for (local i = 1; i < 16; i++) {
			foreach (dummy_id, name in this.name_array) {
				local xname = name + " #" + i;
				if (AICompany.SetName(xname)) return xname;
			}
		}
		return null; //should never happen
	}

	function HandleResult(result)
	{
		if (result != null) {
			CodeUtils.Log("Name \"" + result + "\" choosen", 2);
		}
		return 0;
	}

/* private */
	/** List of available company names */
	name_array = null;
}
