/* Load all AI files */

require("root/enums.nut");
require("transport_system/utils/code_utils.nut");
require("magic_numbers.nut");

/* "Core" files */
require("root/general_hierarchy/objects_counter.nut");
require("root/general_hierarchy/object.nut");

require("root/class_table.nut");
require("root/container.nut");

require("root/data_structures/fib_heap.nut");
require("root/data_structures/priority_queue.nut");
require("root/data_structures/quadtree.nut");
//require("root/data_structures/quadtree++.nut");
require("root/data_structures/grid.nut");

require("root/event_driven_system/event.nut");
require("root/event_driven_system/abstract_task.nut");
require("root/event_driven_system/task.nut");
require("root/event_driven_system/clock.nut");
require("root/event_driven_system/property.nut");

require("root/action_types/abstract_action.nut");
require("root/action_types/action_priority.nut");
require("root/action_types/action_priority_advanced.nut");

require("root/action_types/instant_action.nut");
require("root/action_types/trigger_action.nut");
require("root/action_types/universal_action/universal_action.nut");
require("root/action_types/universal_action/universal_action_abstract_execution_strategy.nut");
require("root/action_types/universal_action/universal_action_self_remove_task.nut");

require("root/general_hierarchy/saveable_object.nut");
require("root/general_hierarchy/abstract_transport_system.nut");

require("root/save_load/tag.nut");
require("root/save_load/save_load_utils.nut");

require("root/settings.nut");

require("transport_system/utils/engines_info.nut");

require("transport_system/utils/visitors/visitor.nut");
require("transport_system/utils/visitors/get_by_type_visitor.nut");
require("transport_system/utils/visitors/get_owners_visitor.nut");

//Trasnport rules description
require("root/transport_schema/node_related/primitive_node_type.nut");
require("root/transport_schema/node_related/node_type.nut");
require("root/transport_schema/node_related/node.nut");
require("root/transport_schema/node_related/nodes_repository.nut");
require("root/transport_schema/node_related/node_factory.nut");

require("root/transport_schema/node_related/industry/industry_node.nut");
require("root/transport_schema/node_related/industry/industry_node_factory.nut");
require("root/transport_schema/node_related/town/town_node.nut");
require("root/transport_schema/node_related/town/town_node_factory.nut");
require("root/transport_schema/node_related/transit/transit_node.nut");
require("root/transport_schema/node_related/transit/transit_node_factory.nut");
require("root/transport_schema/node_related/transit/heap_node.nut");

require("root/transport_schema/playable_regions.nut");
require("root/transport_schema/transport_schema.nut");
require("root/transport_schema/global_transport_map.nut");
require("root/transport_schema/link.nut");
require("root/transport_schema/linker.nut");
require("root/transport_schema/transport_politics.nut");
require("root/transport_schema/transport_node.nut");

require("root/transport_schema/supply_net/supply_contingent.nut");
require("root/transport_schema/supply_net/supply_net.nut");
require("root/transport_schema/supply_net/supply_net_builder.nut");

//Main corporation
require("root/general_hierarchy/corporation.nut");

/* Base actions */
require("actions/Corporation/build_company_hq_action.nut");
require("actions/Corporation/process_events_action.nut");
require("actions/Corporation/repay_loan_action.nut");
require("actions/Corporation/sell_lost_vehicles_task.nut");
require("actions/Corporation/set_company_name_action.nut");
require("actions/Corporation/sleep_action.nut");
require("actions/Corporation/spawn_nodes_action.nut");
require("actions/Corporation/town_action_strategies.nut");
require("actions/TradeRoutes/manage_vehicles_action.nut");

/* Base hierarchy */
require("transport_system/abstract_route.nut");
require("transport_system/single_engine_route.nut");
require("transport_system/simple_route.nut");
require("transport_system/trade_route.nut");
require("transport_system/hub.nut");
require("transport_system/station.nut");
require("transport_system/station_terminal.nut");
require("transport_system/station_loading_terminal.nut");
require("transport_system/station_cargo_drop_terminal.nut");
require("transport_system/town_politics_handling_section.nut");

/* Road section */
require("transport_system/road/roadmap/road_connection.nut");
require("transport_system/road/roadmap/roadmap.nut");

require("transport_system/road/road_department.nut");
require("transport_system/road/road_route.nut");
require("transport_system/road/road_trade_route.nut");

require("transport_system/road/road_engine_roster.nut");
require("transport_system/road/road_settings.nut");
require("transport_system/road/road_utils.nut");
require("transport_system/road/heap_support_transport_politics.nut");
require("transport_system/road/default_road_construction_strategy.nut");

require("transport_system/road/construction_plans/abstract_plan.nut");
require("transport_system/road/construction_plans/free_station_plan.nut");
require("transport_system/road/construction_plans/random_transit_station_plan.nut");
require("transport_system/road/construction_plans/road_site_construction_command.nut");
require("transport_system/road/construction_plans/road_site_construction_plan.nut");

require("transport_system/road/station_handling/road_station.nut");
require("transport_system/road/station_handling/road_station_depot.nut");
require("transport_system/road/station_handling/road_terminal_core.nut");
require("transport_system/road/station_handling/road_loading_terminal.nut");
require("transport_system/road/station_handling/road_cargo_drop_terminal.nut");

require("transport_system/road/trade_system/town-to-town/bus_hub.nut");
require("transport_system/road/trade_system/town-to-town/bus_hub_control_section.nut");
require("transport_system/road/trade_system/town-to-town/town-to-town_transport_politics.nut");
require("transport_system/road/trade_system/town-to-town/construction.nut");
require("transport_system/road/trade_system/town-to-town/reshake_towns_task.nut");

require("transport_system/road/trade_system/transit/pax_transit_hub.nut");
require("transport_system/road/trade_system/transit/pax_transit_control_section.nut");
require("transport_system/road/trade_system/transit/pax_transit_transport_politics.nut");
require("transport_system/road/trade_system/transit/construction.nut");

require("transport_system/road/trade_system/freight/common/freight_trade_overseer.nut");
require("transport_system/road/trade_system/freight/common/truck_hub.nut");

require("transport_system/road/trade_system/freight/dumb/dumb_freight_transport_politics.nut");
require("transport_system/road/trade_system/freight/dumb/dumb_truck_control_section.nut");
require("transport_system/road/trade_system/freight/dumb/construction.nut");

require("transport_system/road/trade_system/freight/sensible_net/road_network.nut");
require("transport_system/road/trade_system/freight/sensible_net/road_networks_coordinator.nut");
require("transport_system/road/trade_system/freight/sensible_net/construction.nut");
require("transport_system/road/trade_system/freight/sensible_net/management_task.nut");

require("transport_system/road/builders/road_route_builder.nut");
require("transport_system/road/builders/industry_station_builder.nut");
require("transport_system/road/builders/town_station_builder.nut");

require("transport_system/road/jam_handling_section/search_road_plugs_task.nut");
require("transport_system/road/jam_handling_section/build_loop_road_action.nut");

require("transport_system/road/roads_stealing_section/activity_map.nut");
require("transport_system/road/roads_stealing_section/roads_stealing_section.nut");
require("transport_system/road/roads_stealing_section/opponents_activity_scan_task.nut");
require("transport_system/road/roads_stealing_section/construction.nut");

require("transport_system/road/actions/fix_roads_action.nut");
require("transport_system/road/actions/search_road_trade_routes_action.nut");
require("transport_system/road/actions/expand_road_station_action.nut");

require("transport_system/road/pathfinders/AdmiralAIv22/adapter.nut");
require("transport_system/road/pathfinders/simple_pf/adapter.nut");

require("transport_system/road/road_transit_handler.nut");
require("transport_system/road/transit_routes_construction_strategy.nut");

/* utils */
require("transport_system/utils/corporation_utils.nut");
require("transport_system/utils/stations_facade.nut");
require("transport_system/utils/tile_utils.nut");

/* Water section */
require("transport_system/ship/waterform_scaner.nut");
require("transport_system/ship/marine_basin.nut");
require("transport_system/ship/ship_department.nut");
require("transport_system/ship/built_water_paths_register.nut");
require("transport_system/ship/dock.nut");
require("transport_system/ship/dock_terminal.nut");
require("transport_system/ship/water_depot.nut");
require("transport_system/ship/builders/dock_builder.nut");
require("transport_system/ship/builders/water_route_builder.nut");
require("transport_system/ship/waterline_utils.nut");
require("transport_system/ship/water_settings.nut");
require("transport_system/ship/trade_system/cruise_section/cruise_central_control.nut");
require("transport_system/ship/trade_system/cruise_section/cruise_transport_politics.nut");
require("transport_system/ship/trade_system/cruise_section/cruise_center.nut");
require("transport_system/ship/trade_system/cruise_section/cruise_route.nut");
require("transport_system/ship/trade_system/cruise_section/cruise_line.nut");
require("transport_system/ship/trade_system/cruise_section/restore_cruise_lines_action.nut");

require("transport_system/ship/simple_water_pf/adapter.nut");

/* Air section */
require("transport_system/air/air_department.nut");
require("transport_system/air/air_constants.nut");
require("transport_system/air/air_settings.nut");
require("transport_system/air/airline_utils.nut");
require("transport_system/air/airport.nut");
require("transport_system/air/airport_terminal.nut");
require("transport_system/air/airport_builder.nut");
require("transport_system/air/plane_engines_roster.nut");
require("transport_system/air/air_route.nut");
require("transport_system/air/air_trade_route.nut");
require("transport_system/air/replace_airport_action.nut");
require("transport_system/air/planes_trade_system/air_hub.nut");
require("transport_system/air/planes_trade_system/air_hubs_control.nut");
require("transport_system/air/planes_trade_system/planes_transport_politics.nut");

/*require("transport_system/utils/construction_plans/abstract_construction_plan.nut");
require("transport_system/utils/construction_plans/construction_command.nut");
require("transport_system/utils/construction_plans/construction_plan_builder.nut");*/

/* Rail section */
/*require("transport_system/rail/rail_settings.nut");
require("transport_system/rail/locos_roster.nut");
require("transport_system/rail/rail_wagons_roster.nut");
require("transport_system/rail/rail_landscape_grid.nut");
require("transport_system/rail/pathfinders/magic_pf/adapter.nut");
require("transport_system/rail/rail_department.nut");
require("transport_system/rail/rail_hub.nut");
require("transport_system/rail/neighbours_based_transport_politics.nut");
require("transport_system/rail/rail_links_maintenance.nut");
require("transport_system/rail/rail_route.nut");
require("transport_system/rail/freight_trains_control_section.nut");
require("transport_system/rail/railway_builder.nut");

require("transport_system/rail/station_plans/default.nut");*/
