/**
 * Super class for "Actions": classes that describes AI behaviour.
 */
class Terron_AbstractAction extends Terron_Object
{
/* public */
	/**
	 * Terron_AbstractAction constructor.
	 */
	constructor()
	{
		::Terron_Object.constructor(null);
	}

	/**
	 * Get this action priority.
	 * @return number indicating action desireability for the AI.
	 */
	function GetPriority();

	/**
	 * Try to execute an action.
	 * @return Result of the HandleResult method.<p>
	 *  It is one of the following error codes:<p>
	 *  0 - Good run, action complete<p>
	 * -1 - General execution error(whatever)<p>
	 * -2 - Not enough money <p>
	 */  
	function Try()
	{
		return this.HandleResult(this.Execute());
	}

	/** Exclude self from the AI visibility. */
	function SelfRemove()
	{
		Corporation.Get().actions.RemoveItem(this.GetID());
	}

/* protected */
	/**
	 * The "action" itself.
	 * @return Any thing devived class condisder important for self. 
	 */
	function Execute();

	/**
	 * Handle self execute result.<p>
	 * @param result Return value of the last Execute method call. 
	 * @return One of the following error codes:<p>
	 *  0 - Good run, action complete<p>
	 * -1 - General execution error(whatever)<p>
	 * -2 - Not enough money <p>
	 * @note By default returns given param.
	 */
	function HandleResult(result)
	{
		return result;
	}
}
