/**
 * Base class that provides instant actions.
 * Simple one-time (must be destructed after completion) top-priority actions.
 */
class InstantAction extends Terron_AbstractAction
{
/* public */
	function GetPriority()
	{
		return APriority.MAX;
	}

	function Try()
	{
		local result = this.HandleResult(this.Execute());
		if (result == 0) this.SelfRemove();
		return result;
	}
}
