/**
 * Interface for universal action's strategies.
 */
class UniversalAction_AbstractExecutionStrategy
{
/* public */
	/**
	 * Dummy constructor.
	 */
	constructor() {};

	/**
	 * Trigger strategy execution.
	 * @param context One of the ConcretizeContext .context return values.
	 * @return Result of the HandleResult method.<p>
	 */
	function Go(context)
	{
		return this.HandleResult(this.Execute(context), context);
	}

/* public */
	/**
	 * Select what to do next.
	 * @return Table with following fields:<p>
	 *  .context - Instance representing entity we want to manipulate further<p>
	 *  .priority - Action priority, float between APriority.BAD and MAX.
	 */
	function ConcretizeContext();

	/**
	 * Get the cost of action within specified context.
	 * @param context Instance previously returned by
	 *  self ConcretizeContext() function.
	 * @return Estimated cost of self execute with the given context.
	 */
	function GetActionCost(context);

/* protected */
	/**
	 * Try to do something.
	 * @param context Instance that describes what(and/or where) we want to do.
	 * @return Whatever derived class wants.
	 */
	function Execute(context);

	/**
	 * Handle self execute result.<p>
	 * @param result Return value of the last Execute method call.
	 * @param context Context of the last Execute method call.
	 * @return One of the following error codes:<p>
	 *  0 - Good run, action complete<p>
	 * -1 - General execution error(whatever)<p>
	 * -2 - Not enough money <p>
	 */
	 function HandleResult(result, context);
}
