/**
 * Table with pairs [class name, class].
 * Used for save/load.
 */
class Terron_ClassTable
{
/* public */
	/**
	 * Register a class inside AI.<p>
	 * With registration, if we know class name and memento,
	 * we can delegate saved object restoration to its class method.<p>
	 * Required only for classes that want save/load.
	 * @param _class Squirrel class derived from Terron_SaveableObject.
	 */
	static function RegisterClass(_class)
	{
		Terron_ClassTable.classes[_class.GetClassName()] <- _class;
	}

	/**
	 * Get previously registered Terron class.
	 * @param class_name name of the class to get.
	 * @return Squirrel class, if class table contains record with given name,
	 *   null else.
	 */
	static function GetClass(class_name)
	{
		local table = Terron_ClassTable.classes;
		return class_name in table ? table[class_name] : null;
	}

/* private */
	/** Table with Terron classes */
	static classes = {};
}
