/**
 * Almost the same as the library priority queue(ver 2).
 * Difference: During insert operation items relocation inside the array
 * moved to a c++ Squirrel code (inside array.insert built-in function).
 * It means that AI will not spend own ticks for that stuff and gives great
 * speed boost measured in AI ticks (in comprasion with default library queue).<p>
 */
class Terron_PriorityQueue
{
	/** Array for items */
	_queue = null;

	/** Total items count */
	_count = 0;

	/**
	 * Creates Terron_PriorityQueue instance.
	 */
	constructor()
	{
		_queue = [];
	}

	/**
	 * Insert a new entry in the list.
	 *  The complexity of this operation is O(n).
	 * @param item The item to add to the list.
	 * @param priority The priority this item has.
	 */
	function Insert(item, priority)
	{
		local n = _count;
		_count++;
		if (n == 0 || priority >= _queue[0][1]) {
			_queue.insert(0, [item, priority]);
			return;
		} else if (priority < _queue[n - 1][1]) {
			_queue.append([item, priority]);
			return;
		}

		local z = n / 2;
		for (local i = 0, j = n - 1; z != j; z = (i + j + 1) / 2) {
			local zz = _queue[z][1];
			if (priority <= zz) i = z;
			if (priority >= zz) j = z;
		}

		_queue.insert(z, [item, priority]);
	}

	/**
	 * Check wheteher the queue is empty.
	 * @return True if and only if the queue has no items.
	 */
	function IsEmpty()
	{
		return _count <= 0;
	}

	/**
	 * Pop the first entry of the list.
	 *  This is always the item with the lowest priority.
	 *  The complexity of this operation is O(1).
	 * @return The item of the entry with the lowest priority.
	 */
	function Pop()
	{
		if (_count == 0) return null;

		_count--;

		return _queue.pop()[0];
	}

	/**
	 * Peek the first entry of the list.
	 *  This is always the item with the lowest priority.
	 *  The complexity of this operation is O(1).
	 * @return The item of the entry with the lowest priority.
	 */
	function Peek()
	{
		return _count == 0 ? null : _queue[_count - 1][0];
	}

	/**
	 * Peek priority of the first entry of the list.
	 * @return The lowest priority among all items(if any).
	 */
	function PeekPriority()
	{
		return _count == 0 ? -0x0FFFFFFF : _queue[_count - 1][1];
	}

	/**
	 * Get the amount of current items in the list.
	 *  The complexity of this operation is O(1).
	 * @return The amount of items currently in the list.
	 */
	function Count() { return _count;}
}
