/**
 * Class that handles tasks shedule and tasks execution in proper time.
 * The central(and the only one should be) AI timer to shedule tasks.
 */
class Terron_Clock extends Terron_Object
{
/* public */
	static function GetClassName()
	{
		return "Terron_Clock";
	}

	/**
	 * Shedule the specified task.
	 * @param task The task to shedule.
	 */
	function AddTask(task)
	{
		this.queue[task.next_run_date % GameTime.SHEDULE_SIZE][task.object_id] <- task;
	}

	/**
	 * Remove the specified task from execution shedule.
	 * @param task The task to shedule.
	 */
	function RemoveTask(task)
	{
		local day_shedule = this.queue[task.next_run_date % GameTime.SHEDULE_SIZE];
		if (task.object_id in day_shedule) delete day_shedule[task.object_id];
	}

	/**
	 * Run tasks ahead until the specified date is reached.
	 * This should trigger all tasks sheduled between the last Run call param
	 *  and the current Run call param.
	 * @param current_date The latest game date for that tasks run allowed(in this call).
	 */
	function Run(current_date)
	{
		//local tt = AIController.GetTick();
		for (; this.next_run_date <= current_date;) {
			local tasks = this.queue[this.next_run_date++ % GameTime.SHEDULE_SIZE];
			foreach (dummy_id, task in tasks) {
				//CodeUtils.Log("Running task: " + task.GetName(), 0);
				task.Run(current_date);
			}
			tasks.clear();
		}
		//CodeUtils.Log("Tasks running time " + (AIController.GetTick() - tt), 0);
	}

	/**
	 * Starts the the clock.
	 */
	function Start()
	{
		_ai_clock.next_run_date = AIDate.GetCurrentDate() - GameTime.DAY;
	}

/* protected */
	/** Next run date. */
	next_run_date = 0;

/* private */
	/** Despite name this is a static array. */
	queue = null;

	/**
	 * Creates the AI clock.
	 */
	constructor()
	{
		::Terron_Object.constructor(null);

		this.queue = array(GameTime.SHEDULE_SIZE);
		for (local i = 0; i < this.queue.len(); i++) {
			this.queue[i] = {};
		}
	}
}

/* Must use only this global variable */
/** Internal AI timer */
_ai_clock <- Terron_Clock();
