/**
 * Terron class hierarchy root.
 */
class Terron_Object
{
/* public */
	/**
	 * Get the object class name.
	 * Must be provided by derived classes.
	 * @return Unique string for each class.
	 */
	static function GetClassName();

	/**
	 * Terron_Object constructor.
	 * @param id Desired object id. If null => ID will be assigned automaticly.
	 */
	constructor(id)
	{
		this.object_id = (id != null) ? id : Terron_ObjectsCounter.PopNewID();
	}

	/**
	 * Get the ID of this object.
	 */
	function GetID()
	{
		return this.object_id;
	}

	/**
	 * Get the name of this object.
	 * @return short string - name of the object.
	 */
	function GetName();

	/**
	 * Function to compare different objects.
	 */
	function _cmp(other)
	{
		if (this.object_id < other.object_id) return -1;
		return this.object_id > other.object_id ? 1 : 0;
	}

/* private */
	/** The object's runtime ID */
	object_id = null;
}
