/**
 * Base class for saveable objects.
 */
class Terron_SaveableObject extends Terron_Object
{
/* public */
	/**
	 * Create new object, restored from the memento.
	 * @param memento result of this.GetMemento().
	 * @return restored object.
	 * @note must be provided for save/load.
	 */
	static function Restore(memento);

	/**
	 * Get this object's memento.
	 * @return Repository that hold object state.
	 * @note Return value must be a table.
	 */
	function GetMemento()
	{
		local memento = {};
		local this_class = this.getclass();
		foreach(member, dummy in this_class) {
			local attr = this_class.getattributes(member);
			if (attr == null) continue;
			if (!("must_save" in attr)) continue;
			if (attr["must_save"] == true) memento[member] <- this[member];
		}
		return memento;
	}
}
