/**
 * Helper to parse save file strings.
 * @note It is not to handle all true XML tags, it's only to understand
 *  those concrete "tags" we create in SaveLoadUtils.Save function.
 */
class Tag
{
/* public */
	/**
	 * Check if given string is tag.
	 * @param s String to check.
	 */
	static function IsTag(s)
	{
		local n = s.len();
		return (n >= 2 && s.slice(0, 1) == "<" && s.slice(n - 1, n) == ">");
	}

	/**
	 * Check if given string is end(close) tag (e.g </end_tag>, not <not_end_tag>).
	 * @param s String to check.
	 * @note IsTag(s) must be true.
	 */
	static function IsEndTag(s)
	{
		return s.slice(1, 2) == "/";
	}

	/**
	 * Check if given string is start(open) tag (e.g <start_tag>).
	 * @param s String to check.
	 * @note IsTag(s) must be true.
	 */
	static function IsStartTag(s)
	{
		return !Tag.IsEndTag(s);
	}

	/**
	 * Parses given string into structure, with tag(tag itself) and type(type attribute) fields.
	 * @param s String to parse.
	 * @return table representing given string, or null if string has invalid format.
	 */
	static function GetStartTag(s) {
		if (!Tag.IsTag(s) || Tag.IsEndTag(s)) return null;
		local i = s.find(" type=\"");
		local j = (i == null) ? null : s.find("\"", i + 7);
		return j == null ? null : {tag = s.slice(1, i), type = s.slice(i + 7, j)};
	}
}
