/**
 * Class that should be parent for all AI settings classes.<p>
 * "Settings classes" then will have following properties:<p>
 *  * Singleton(as possible in Squirrel, with static "Get" to access instance)<p>
 *  * instance name will be "<class name> object"<p>
 *  * will support save "on-request" mechanism,
 *     so must provide GetMemento/Restore methods.<p>
 */
class Terron_Settings extends Terron_SaveableObject
{
/* public */
	/** Must be called to create all settings */
	static function Init()
	{
		/*
		 * Table with classes will be completed at AI start,
		 *  items inserted during settings classes declaration(see _inherited).
		 */
		foreach (dummy_id, item in Terron_Settings.settings_classes) {
			// constructor call
			item();
		}
	}

/* protected */
	/**
	 * Base settings constructor.
	 */
	constructor()
	{
		::Terron_SaveableObject.constructor(null);

		/*
		 * New objects will rewrite the old ones.
		 * But due to creation order "new ones" are only can be loaded objects,
		 *  therefore such rewriting is ok.
		 */
		// of course unless constructor'll be called outside of Restore or Init
		//  function.
		// thus it is not allowed to call Get of one settings class inside
		//  another's constructor.
		this._instance[0] = this;

		this.name = this.GetClassName() + " object";

		AISettingsSaveEvent.AddListener(this);
	}

/* private */
	/** Helper to create all settings instances at game start */
	static settings_classes = [];

	/** See Squirrel manual */
	function _inherited(attributes)
	{
		/* Create common part for all "settings" stuff */
		local new_settings_class = this;
		this["name"] <- null;
		this["_instance"] <- [null];

		this["Get"] <- function() : (new_settings_class) {
			/* Safe */
			//if (new_settings_class._instance[0] == null) new_settings_class();

			// not safe
			// if one setting object is called from another setting construcor
			return new_settings_class._instance[0];
		}
		this["GetName"] <- function() {
			return this.name;
		}
		this["OnSettingsSave"] <- function(save_array) {
			save_array.append(this);
		}

		Terron_Settings.settings_classes.append(new_settings_class);
	}
}
