/**
 * Class that handles industry nodes creation.
 */
class IndustryNodeFactory extends NodeFactory
{
/* public */
	constructor()
	{
		::NodeFactory.constructor();
		Terron_Event.IndustryOpen.AddListener(this);
		this.fake_raw_consumer_types = {};
	}

	function GetCorrespondingNodeClassID()
	{
		return NodeClass.NC_INDUSTRY;
	}

	function GetPrimitiveTypes()
	{
		local result = {};
		local industry = NodeClass.NC_INDUSTRY;
		local max_industry_type_id = -1;
		local must_make_fake_types = [];
		foreach (id, dummy in AIIndustryTypeList()) {
			if (id > max_industry_type_id) max_industry_type_id = id;

			/* no, thanks */
			if (id == AIIndustryType.INDUSTRYTYPE_TOWN) continue;
			/* no, thanks */
			if (id == AIIndustryType.INDUSTRYTYPE_UNKNOWN) continue;

			local name = CodeUtils.MakeNoSpacesString(AIIndustryType.GetName(id));
			local recipes = [];
			local is_raw = AIIndustryType.IsRawIndustry(id);
			local accepted_cargo = AIIndustryType.GetAcceptedCargo(id);
			local produced_cargo = AIIndustryType.GetProducedCargo(id);

			/* Raw production industry accepts something */
			if (is_raw && (accepted_cargo.Count() > 0)) {
				/* Split it into raw producing type without acception... */
				foreach (c1, dummy in produced_cargo) {
					recipes.append(CargoProductionRecipe(c1, [{}]));
				}
				result[id] <- PrimitiveNodeType(NodeClass.NC_INDUSTRY, id, name, recipes, is_raw);

				/* ...and a "fake"(accept only, no production) industry type */
				must_make_fake_types.append(id);
				continue;
			}

			local one_cargo_recipe = [];
			foreach (c2, dummy in accepted_cargo) {
				one_cargo_recipe.append({[c2] = 2});
			}

			local multi_cargo_recipe = [{}];
			foreach (c2, dummy in accepted_cargo) {
				multi_cargo_recipe[0][c2] <- 1;
			}

			/*foreach (c1, dummy in produced_cargo) {
				recipes.append(CargoProductionRecipe(c1, clone one_cargo_recipe));
			}*/
			foreach (c1, dummy in produced_cargo) {
				recipes.append(CargoProductionRecipe(c1, clone multi_cargo_recipe));
			}
			if (produced_cargo.Count() == 0) {
				recipes.append(CargoProductionRecipe(null, clone one_cargo_recipe));
			}

			result[id] <- PrimitiveNodeType(NodeClass.NC_INDUSTRY, id, name, recipes, is_raw);
		}

		/* Here we'll create "fake" industry types */
		max_industry_type_id++;
		foreach (x, type_id in must_make_fake_types) {
			local id = max_industry_type_id + x;
			this.fake_raw_consumer_types[type_id] <- id;
			local name = "FAKE_" + CodeUtils.MakeNoSpacesString(AIIndustryType.GetName(type_id));
			local recipes = [];
			local one_cargo_recipe = [];
			local accepted_cargo = AIIndustryType.GetAcceptedCargo(type_id);
			foreach (c2, dummy in accepted_cargo) {
				one_cargo_recipe.append({[c2] = 2});
			}
			recipes.append(CargoProductionRecipe(null, clone one_cargo_recipe));
			result[id] <- PrimitiveNodeType(NodeClass.NC_INDUSTRY, id, name, recipes, false);
		}

		return result;
	}

	function CreateNodes(full_node_types_table)
	{
		local result = TableContainer.new("Industry Nodes");
		foreach (industry_id, dummy in AIIndustryList()) {
			local industry_type_id = AIIndustry.GetIndustryType(industry_id);
			if (industry_type_id in full_node_types_table) {
				local industry_type = full_node_types_table[industry_type_id];
				result.AddItem(IndustryNode(industry_id, industry_type));
			}

			if (industry_type_id in this.fake_raw_consumer_types) {
				local fake_type_id = this.fake_raw_consumer_types[industry_type_id];
				if (fake_type_id in full_node_types_table) {
					local industry_type = full_node_types_table[fake_type_id];
					result.AddItem(IndustryNode(industry_id, industry_type));
				}
			}
		}

		return result;
	}

	/**
	 * Create new industry node on each new industry open.
	 * @param industry_id ID of the newly opended industry.
	 */
	function OnIndustryOpen(industry_id)
	{
		local industry_type_id = AIIndustry.GetIndustryType(industry_id);
		local industry_type = TransportSchema.Get().node_types[industry_type_id];
		local new_node = IndustryNode(industry_id, industry_type);
		if (new_node.IsBuiltOnWater()) return;
		NodesRepository.Get().AddNode(new_node);
		NewNodeEvent.Fire(new_node);
	}

/* private */
	/** Table to hold "fake" transport types. */
	fake_raw_consumer_types = null;
}

node_classes_mount_point.InjectNodeClassImplementation(IndustryNodeFactory());
