/**
 * Class to enumerate all in-game cargo IDs.
 */
class DummyCargoVector extends Terron_Settings
{
/* public */
	static function GetClassName()
	{
		return "TransportSchema";
	}

	/** Max of all cargo IDs */
	max_cargo_id = 0;

	/**
	 * Get "dummy" cargo list.
	 * @return Table with all game cargo IDs.
	 */
	function GetDummyVector()
	{
		return (clone this.dummy_vector);
	}

/* protected */
	/**
	 * DummyCargoVector constructor.
	 */
	constructor()
	{
		::Terron_Settings.constructor();
		AISettingsSaveEvent.RemoveListener(this);

		this.dummy_vector = {};
		this.max_cargo_id = 0;
		foreach (c, dummy in AICargoList()) {
			this.dummy_vector[c] <- 0;
			if (c > max_cargo_id) this.max_cargo_id = c;
		}
	}

/* private */
	/**
	 * Table with all game cargo IDs.
	 * Key - ID, value - always 0.
	 */
	dummy_vector = null;
}

/**
 * Simple class, main purpose is it's Print function for debug.
 */
class SimplestRecipe
{
/* public */
	/** Recipe ingridients. */
	ingridients = null;

	/** ID of the result production cargo. */
	output_cargo_id = null;

	/**
	 * Creates SimplestRecipe.
	 * @param output_cargo_id ID of the cargo produced from the ingridients.
	 * @param ingridients Table with "ingridients"<p>
	 *  key - ID of one of the cargo required to produce output_cargo_id<p>
	 *  value - amount of units to produce 1 unit of output_cargo_id<p>
	 */
	constructor(output_cargo_id, ingridients)
	{
		this.ingridients = ingridients;
		this.output_cargo_id = output_cargo_id;
	}

	/**
	 * Prints info about this recipe.
	 */
	function Print()
	{
		local s1 = this.output_cargo_id == "null" ?  "NULL" :
			AICargo.GetCargoLabel(this.output_cargo_id);
		local j = ingridients.len();
		local s2 = "["
		foreach (c, amount in this.ingridients) {
			j--;
			s2 += amount + " units of " + AICargo.GetCargoLabel(c);
			s2 += (j != 0) ? " AND " : "";
		}
		s2 += "]";
		CodeUtils.Log("Unit of " + s1 + " for " + s2, 2)
	}
}

/**
 * Class that holds all production recipes(cargo production rules)
 *  of the node type.<p>
 * It is needed for advanced cargo delivery tree generation/computation,
 *  but for now this part of AI is on hold and class is almost useless.
 */
class SuperRecipe
{
/* public */
	/** Container with all small recipes. */
	recipes = null;

	/**
	 * Creates SuperRecipe for the given node type.
	 * @param node_type Node type.
	 */
	constructor(node_type)
	{
		local must_have_cargo_ids = {}, helper_cargo_ids = {};
		foreach (supplier_id, cargo_ids in node_type.supplier_node_types) {
			if (supplier_id in node_type.helpers) continue;
			foreach (c, dummy in cargo_ids) {
				must_have_cargo_ids[c] <- null;
			}
		}
		foreach (supplier_id, cargo_ids in node_type.helpers) {
			foreach (c, dummy in cargo_ids) {
				helper_cargo_ids[c] <- null;
			}
		}

		/*CodeUtils.Log("helpers ", 2);
		foreach (c, dummy in helper_cargo_ids) {
			CodeUtils.Log(AICargo.GetCargoLabel(c), 2);
		}*/
		foreach (c, dummy in helper_cargo_ids) {
			if (c in must_have_cargo_ids) delete helper_cargo_ids[c];
		}
		/*CodeUtils.Log("helpers b ", 2);
		foreach (c, dummy in helper_cargo_ids) {
			CodeUtils.Log(AICargo.GetCargoLabel(c), 2);
		}
		//if (node_type.GetName() == "Mixed_Farm") {
			//AIController.Sleep(10);
		//}*/

		local xxx = [];
		local tmp = clone must_have_cargo_ids;
		if (must_have_cargo_ids.len() == 0) {
			xxx.append({});
		}
		foreach (c1, dummy1 in must_have_cargo_ids) {
			if (must_have_cargo_ids.len() == 1) {
				xxx.append({[c1] = 1});
			}
			delete tmp[c1];
			foreach (c2, dummy2 in tmp) {
				xxx.append({[c1] = 1, [c2] = 1});
			}
		}

		foreach (c, dummy in helper_cargo_ids) {
			foreach (dummy_id, table in clone xxx) {
				local helper_plus = clone table;
				helper_plus[c] <- 1;
				xxx.append(helper_plus);
			}
		}
		/*if (xxx.len() == 0) {
			foreach (c, dummy in helper_cargo_ids) {
				xxx.append({[c] = 0.1});
			}
		}*/

		this.recipes = [];
		if (node_type.production.len() == 0 && node_type.raw_consumption) {
			foreach (c1, dummy1 in must_have_cargo_ids) {
				this.recipes.append(SimplestRecipe("null", {[c1] = 1}));
			}
			foreach (c1, dummy1 in helper_cargo_ids) {
				this.recipes.append(SimplestRecipe("null", {[c1] = 1}));
			}
		} else {
			foreach (production_cargo_id, dummy1 in node_type.production) {
				foreach (dummy_id, table in xxx) {
					this.recipes.append(SimplestRecipe(production_cargo_id, table));
				}
			}
		}
	}

	/**
	 * Get cargo production from the given cargo input.
	 * @param input_cargo_ids Table with input cargo IDs.
	 * @return Table that contains cargo IDs that can be received from
	 *  the given input.
	 */
	function GetOutput(input_cargo_set)
	{
		local result = {has_output = false, output_result = {}};

		foreach (dummy_id, recipe in this.recipes) {
			if (recipe.output_cargo_id in result.output_result) continue;
			local yes = true;
			foreach (c, x in recipe.ingridients) {
				if (!(c in input_cargo_set)) {
					//CodeUtils.Log("c = " + c, 0);
					//CodeUtils.Log("input_cargo_set " + input_cargo_set.len(), 0);
					yes = false;
					break;
				}
			}
			if (yes) {
				result.has_output = true;
				if (recipe.output_cargo_id != "null") {
					result.output_result[recipe.output_cargo_id] <- 1;
				}
			}
		}
		return result;
	}

	/**
	 * Same as GetOutput but contain information not only about "what"
	 *  can be produced, but also "how much".
	 */
	function GetMeasuredOutput(input_cargo_set)
	{
		local result = {has_output = false, output_result = {}};

		foreach (dummy_id, recipe in this.recipes) {
			local output_amount = 0;
			foreach (c, portion_size in recipe.ingridients) {
				if (!(c in input_cargo_set)) {
					output_amount = 0;
					break;
				}
				output_amount += input_cargo_set[c] / portion_size;
			}
			if (output_amount > 0) {
				result.has_output = true;
				//if (recipe.output_cargo_id != "null") {
					result.output_result[recipe.output_cargo_id] <- output_amount;
				//}
			}
		}
		return result;
	}

	/**
	 * Prints info about all of this recipe's subrecipes.
	 */
	function Print()
	{
		foreach (dummy_id, recipe in this.recipes) {
			recipe.Print();
		}
	}
}

/**
 * Class that should describe cargo production rules in game.
 * This class may look unnecessary, but without it final SuperRecipe creation
 *  code becomes complete mess of the Squirrel tables, so I keep it.
 */
class CargoProductionRecipe
{
/* public */
	/** Output cargo ID. */
	c = null;

	/** All combinations of different cargo IDs to produce output cargo ID. */
	recipe_map = null;

	constructor(produced_cargo, short_recipes)
	{
		this.c = produced_cargo;
		this.recipe_map = array(short_recipes.len());
		foreach (id, recipe in short_recipes) {
			this.recipe_map[id] = DummyCargoVector.Get().GetDummyVector();
			foreach (c, amount in recipe) {
				this.recipe_map[id][c] = amount;
			}
		}
	}

	/**
	 * Prints info about this recipe.
	 */
	function Print()
	{
		if (c == null) {
			CodeUtils.Log("Raw consumption", 2);
		} else {
			CodeUtils.Log("One unit of " + AICargo.GetCargoLabel(c) + " from", 2);
		}
		local i = recipe_map.len();
		foreach (dummy_id, recipe in recipe_map) {
			i--;
			local j = recipe.len();
			local s = "["
			foreach (ingridient, amount in recipe) {
				j--;
				s += amount + " of units " + AICargo.GetCargoLabel(ingridient);
				if (j != 0) s+= " AND ";
			}
			CodeUtils.Log(s + "]", 2);
			if (i != 0) CodeUtils.Log("      OR", 2);
		}
	}
}

/**
 * Class that provides temporary data needed to create proper NodeType objects.
 */
class PrimitiveNodeType
{
/* public */
	/** Type's nodes class ID. */
	class_id = null;

	/** Type's ID. */
	type_id = null;

	/** Type's name. */
	type_name = null;

	/** Type's recipes. */
	recipes = null;

	/** See NodeType. */
	raw_production = false;

	/** See NodeType. */
	raw_consumption = false;

	/** See NodeType. */
	production = null;

	/** See NodeType. */
	consumption = null;

	/**
	 * Creates PrimitiveNodeType object.
	 */
	constructor(node_class_id, type_id, type_name, recipes, is_raw_production)
	{
		if (type_id >= NodeTypeID.NT_MAXTYPES) assert(null);

		this.class_id = node_class_id;
		this.type_id = type_id;
		this.type_name = type_name;
		this.recipes = recipes;
		this.raw_production = is_raw_production;
		this.production = {};
		this.consumption = {};
		foreach (dummy_id, recipe in recipes) {
			local c = recipe.c;
			if (c == null) this.raw_consumption = true;
			if (c != null) this.production[c] <- [];
			if (c != null) CodeUtils.Log(type_name + " PRODUCTION " + c, 2);

			foreach (dummy_id, cargo_vector in recipe.recipe_map) {
				foreach (c_consumed, amount in cargo_vector) {
					//if (c_consumed != null) this.consumption[c_consumed] <- [];
					if (amount > 0) this.consumption[c_consumed] <- [];
				}
				if (cargo_vector == null) {
					this.raw_production = true;
					continue;
				}
			}
		}
	}
}
