/**
 * Class that handles town nodes creation.
 */
class TownNodeFactory extends NodeFactory
{
/* public */
	function GetCorrespondingNodeClassID()
	{
		return NodeClass.NC_TOWN;
	}

	function GetPrimitiveTypes()
	{
		local recipes = [];
		local raw_accept_recipe = [];

		local cargo_list = AICargoList();
		cargo_list.Valuate(AICargo.GetTownEffect);
		cargo_list.RemoveValue(AICargo.TE_NONE);
		foreach (c, effect in cargo_list) {
			if (effect == AICargo.TE_PASSENGERS || effect == AICargo.TE_MAIL) {
				recipes.append(CargoProductionRecipe(c, [{[c] = 1}]));
				continue;
			}
			raw_accept_recipe.append({[c] = 1});
		}

		return {
			[NodeTypeID.NT_PAX_TOWN] = PrimitiveNodeType(NodeClass.NC_TOWN, NodeTypeID.NT_PAX_TOWN, "PAX Town", recipes, false),
			[NodeTypeID.NT_RAW_TOWN] = PrimitiveNodeType(NodeClass.NC_TOWN, NodeTypeID.NT_RAW_TOWN, "RAW Town", [CargoProductionRecipe(null, raw_accept_recipe)], false)
		};
	}

	function CreateNodes(full_node_types_table)
	{
		local pax_type = full_node_types_table.rawget(NodeTypeID.NT_PAX_TOWN);
		local raw_type = full_node_types_table.rawget(NodeTypeID.NT_RAW_TOWN);

		local result = TableContainer.new("Town Nodes");
		foreach (t, dummy in AITownList()) {
			if (pax_type != null) result.AddItem(TownNode(t, pax_type));
			if (raw_type != null) result.AddItem(TownNode(t, raw_type));
		}
		return result;
	}
}

node_classes_mount_point.InjectNodeClassImplementation(TownNodeFactory());
