/**
 * Class that handles transit nodes creation.
 */
class TransitNodeFactory extends NodeFactory
{
/* public */
	constructor()
	{
		::NodeFactory.constructor();
		TransitWantedEvent.AddListener(this);
	}

	function GetCorrespondingNodeClassID()
	{
		return NodeClass.NC_TRANSIT;
	}

	function GetPrimitiveTypes()
	{
		local recipes = [];
		local cargo_list = AICargoList();
		foreach (c, dummy in cargo_list) {
			recipes.append(CargoProductionRecipe(null, [{[c] = 1}]));
		}

		return {
			[NodeTypeID.NT_TRANSIT_DROP] = PrimitiveNodeType(NodeClass.NC_TRANSIT, NodeTypeID.NT_TRANSIT_DROP, "Transit Point", recipes, false),
		};
	}

	function CreateNodes(full_node_types_table)
	{
		return TableContainer.new("Transit Nodes");
	}

	/**
	 * Creates new transit node when transit is needed.
	 */
	function OnTransitWanted(info)
	{
		local station = info[0];
		local station_id = station.GetStationID();
		local transit_transport_types_allowed = info[1];
		local cargo_ids = info[2];
		local all_nodes = NodesRepository.Get();
		if (all_nodes.GetNode(NodeTypeID.NT_TRANSIT_DROP, station_id) == null) {
			local new_node = TransitNode(station_id, transit_transport_types_allowed, cargo_ids);
			all_nodes.AddNode(new_node);
			station.is_transit = true;
			NewNodeEvent.Fire(new_node);
		}
	}
}

node_classes_mount_point.InjectNodeClassImplementation(TransitNodeFactory());
