/**
 * Class that holds air related "magic numbers".
 */
class AirConstants extends Terron_Settings
{
/* public */
	static function GetClassName()
	{
		return "AirConstants";
	}

/* public */
	/**
	 * Table that holds max supported airplanes arrival frequencies
	 *  for each of the airports' type.
	 */
	static airports_arrival_requency = {};

	/** Speed of a "broken down" plane in km/h */
	static broken_plane_speed = 321;

	/** AI company's month income enough to stop care about money during planning */
	static good_corporation_income_for_full_scale_expansion = 40000;

	/** Should represent impossible airport construction option */
	static infinite_airport_cost = 1 << 20;

	/**
	 * Towns with population above this number considered "huge".
	 * @note Mostly because of territory occupated.
	 */
	static huge_town_pop = 7000;

	/**
	 * Towns with population below this number considered too small to have an
	 *  airport.
	 */
	static tiny_town_pop = 750;

	/** Just ignore towns with lesser population. */
	static lowest_population_limit_for_towns = 550;

	/** Station(airports) rating below this considered low. */
	static low_airport_rating_border = 55;

	/** How many times AI can try to place airport near town. */
	static airport_build_attempts_limit = 80;

	/** Minimal allowed acceptance level in a point of new airport placing. */
	min_acceptance_for_airport = 16;

	/** The amount of vehicles AI must have to begin airports construction. */
	min_vehicles_to_enable_planes = 0;

	/** True if and only if towns allowed to control noise level of airports. */
	noise_matters = false;

/* protected */
	/**
	 * AirConstants constructor.
	 */
	constructor()
	{
		::Terron_Settings.constructor();
		AISettingsSaveEvent.RemoveListener(this);

		if (AIController.GetSetting("PlaneModule") == 1) {
			this.min_vehicles_to_enable_planes = 10 + AIBase.RandRange(40);
		} else {
			this.min_vehicles_to_enable_planes = 0;
		}

		this.min_acceptance_for_airport = 16;
		if (AIController.GetSetting("BusModule") >= 2) {
			this.min_acceptance_for_airport = 12;
			this.noise_matters = AIGameSettings.IsValid("economy.station_noise_level") ?
				AIGameSettings.GetValue("economy.station_noise_level") : false;
			if (this.noise_matters) this.min_acceptance_for_airport = 10;
		}

		AirConstants.airports_arrival_requency[AIAirport.AT_LARGE] <- 0.065;
		AirConstants.airports_arrival_requency[AIAirport.AT_SMALL] <- 0.05;
		AirConstants.airports_arrival_requency[AIAirport.AT_METROPOLITAN] <- 0.071;
		AirConstants.airports_arrival_requency[AIAirport.AT_INTERNATIONAL] <- 0.08;
		AirConstants.airports_arrival_requency[AIAirport.AT_COMMUTER] <- 0.06;
		AirConstants.airports_arrival_requency[AIAirport.AT_INTERCON] <- 0.1;
		AirConstants.airports_arrival_requency[AIAirport.AT_HELIPORT] <- 0.0;
		AirConstants.airports_arrival_requency[AIAirport.AT_HELISTATION] <- 0.0;
		AirConstants.airports_arrival_requency[AIAirport.AT_HELIDEPOT] <- 0.0;
		AirConstants.airports_arrival_requency[AIAirport.AT_INVALID] <- 0.0;
	}
}
