/**
 * Class that represents airport.
 */
class Airport extends Station
{
/* public */
	static function GetClassName()
	{
		return "Airport";
	}

	/**
	 * Returns airport builded to service the given node.
	 * @param node Node (town, industy, e.t.c.).
	 * @return Airport assigned to the given node, or null for nodes without
	 *  airports.
	 */
	static function GetAirport(node)
	{
		foreach (dummy_id, item in node.GetClassStations("Airport")) {
			return item;
		}
		return null;
	}

	static function Restore(memento)
	{
		local c = memento.airport_terminal.GetCargoID();
		local a = Airport(memento.station_id, memento.node_id, memento.node_type, c);

		a.is_obsoletable = memento.is_obsoletable;
		a.airport_terminal = memento.airport_terminal;
		a.RegisterTerminal(memento.airport_terminal);

		return a;
	}

	constructor(station_id, node_id, node_type_id, c)
	{
		::Station.constructor(station_id, node_id, node_type_id);

		if (SaveLoadUtils.IsLoading()) return;

		this.airport_terminal = AirportTerminal(station_id, c);
		this.RegisterTerminal(this.airport_terminal); //(!) watch for override

		/* If INTERNATIONAL available don't replace new smaller airports */
		/* Mean if we build SMALL => we choose SMALL (e.g. mountain region) =>
		*  => replacement futile */
		if (AIAirport.IsValidAirportType(AIAirport.AT_INTERNATIONAL)) return;
		/*
		 * In practice it's hard for current build algorithm
		 *  to favourably replace METROPOLITAN airport in big towns,
		 *  due to increased size of INTERNATIONAL airports.
		 */
		if (node_type_id == NodeTypeID.NT_PAX_TOWN &&
			this.GetAirportType() == AIAirport.AT_METROPOLITAN) {
			local n = AirConstants.huge_town_pop;
			if (this.GetStationNode().GetPopulation() > n) return;
		}
		this.is_obsoletable = true;
	}

	/**
	 * Get this airport type.
	 */
	function GetAirportType()
	{
		return this.airport_terminal.GetAirportType();
	}

	/**
	 * Get number of free airport "slots" for additional airplanes.
	 * @return (Max airport planes) - (current airport planes).
	 */
	function GetFreePlanes(f)
	{
		 return max(0, this.airport_terminal.GetFreeSheduleSlots(f));
	}

/* private */
	/** Main(and single) terminal for this station. */
	</ must_save = true />
	airport_terminal = null;

	/** Flag showing that this airport must be expanded later. */
	</ must_save = true />
	is_obsoletable = false;
}

Terron_ClassTable.RegisterClass(Airport);
