/**
 * Class that handles actual steal-roads building.
 */
class RoadsStealingSection_LocalBuildStrategy extends DefaultRoadConstructionStrategy
{
/* public */
	/**
	 * RoadsStealingSection.LocalBuildStrategy constructor.
	 * @param stealing_section AI roads stealing section.
	 */
	constructor(stealing_section)
	{
		this.routes_to_steal = stealing_section.confirmed_can_steal_routes;
	}

/* protected */
	function GetConstructionCost(road_route)
	{
		local cfg = RoadSettings.Get();
		return (
			2 * cfg.GetRoadStationCost() +
			cfg.GetRoadCost(road_route.length / 5) +
			3 * road_route.best_engine_price
		);
	}

	function SelectObjectToBuild()
	{
		local best_route = null;
		local best_route_rank = APriority.BAD;
		foreach (dummy_route_id, route in this.routes_to_steal) {
			if (route.GetNormalCargoIncome() <= best_route_rank) continue;
			if (this.RankRoadRoute(route) > APriority.BAD) {
				best_route_rank = route.normal_cargo_income;
				best_route = route;
			}
		}
		best_route_rank = best_route == null ? APriority.BAD :
			this.RankRoadRoute(best_route);

		return {priority = best_route_rank, context = best_route};
	}

	function Build(route)
	{
		return RoadRouteBuilder.BuildRoute(route, SimplePF_RoadsReuseAdapter());
	}

	function HandleResult(result, route)
	{
		if (result.err_code == -3 || result.err_code == -1) {
			route.MakeNefarious(GameTime.YEAR);
			return -1;
		}
		if (result.err_code == 0) {
			this.FoundNewTradeRoute(route, result.s_station, result.e_station);
			this.routes_to_steal.RemoveItem(route.GetID());
		}

		return result.err_code;
	}

/* private */
	/** Table with routes */
	routes_to_steal = null;
}
