/**
 * Class that searches newest stations(built by other players).
 */
class OpponentsActivityScanTask extends Terron_Task
{
/* public */
	/**
	 * Creates a task that will scan opponents activity in "background". 
	 * @param host RoadsStealingSection object. It will receive updates
	 *  when new candidate routes to steal are found.
	 * @param transport_class_name Transport class name to scan it's nodes.
	 * @param node_types Types of the nodes to scan.
	 */
	constructor(host, transport_class_name, node_types)
	{
		/* Delay this task start a bit */
		// to be sure that all AI data init finished
		local date = AIDate.GetCurrentDate() + 10 * GameTime.DAY; 
		::Terron_Task.constructor(date , 3 * GameTime.MONTH + GameTime.DAY);

		this.host = host;
		this.transport_class_name = transport_class_name;
		this.node_types = node_types;
		this.activity = ActivityMap.GetActivityMap(transport_class_name, node_types);
	}

/* protected */
	function Execute()
	{
		if (!RoadDepartment.Get().IsEnabled()) return 0;

		local new = ActivityMap.GetActivityMap(transport_class_name, node_types);
		local routes = this.FindRoutesToSteal(new - this.activity, new);
		this.activity = new;
		this.host.UploadNewCandidatesToSteal(routes);
		return 0;
	}

/* private */
	/** Opponents activity map. */
	activity = null;

	/** Road stealing section. */
	host = null;

	/** Name of the transport class to scan it's nodes. */
	transport_class_name = null;

	/** Types of the nodes to scan. */
	node_types = null;

	/**
	 * Get a new portion of routes to steal.
	 * @param new_activity Recent opponents activity. 
	 * @param full_activity Full game time opponents activity.
	 * @return Table with pairs [route ID, route].
	 */
	function FindRoutesToSteal(new_activity, full_activity)
	{
		local global_repository = GlobalTransportMap.Get().transport_nodes_map;

		/* We'll save links with routes to steal here */
		local links = [];
		foreach (node_runtime_id, dummy_n in new_activity.map) {
			/*
			 * If a node does not exist anymore in the global container
			 *  (e.g. due to industry close)
			 *   => remove it from our local container too.
			 */
			if (!(node_runtime_id in global_repository)) {
				full_activity.map.rawdelete(node_id);
				continue;
			}

			local road_node = global_repository[node_runtime_id];
			foreach (to_node_id, link in road_node.links_out) {
				//if (link.color != LinkColor.LC_GREEN) continue; 
				if (to_node_id in full_activity.map) links.append(link);
			}
			foreach (from_node_id, link in road_node.links_in) {
				//if (link.color != LinkColor.LC_GREEN) continue;
				if (from_node_id in full_activity.map) links.append(link);
			}
		}

		local result = {};
		foreach (dummy_id, link in links) {
			foreach (route_id, route in link.routes) {
				if (route.GetCurrentRouteLevel() > 0) continue;
				result[route_id] <- route;
			}
		}
		return result;
	}
}
