/**
 * Class that describes cargo drop road terminal.
 */
class RoadStation_CargoDropTerminal extends Station_CargoDropTerminal
{
/* public */
	static function GetClassName()
	{
		return "RoadStation_CargoDropTerminal";
	}

	static function Restore(memento)
	{
		local restored = RoadStation_CargoDropTerminal(
			memento.station_id, memento.cargo_list, memento.tiles
		);
		restored.depot.location = memento.depot_location;

		return restored;
	}

	/** Core information about the terminal. */
	core = null;

	depot = null;

	/** The terminal's station type. */
	station_type = null;

	/**
	 * Creates cargo drop terminal.
	 * @param cargo_list Cargo list(array, or table),
	 *  which this terminal allowed to accept.
	 */
	constructor(station_id, cargo_list, tiles)
	{
		this.station_type = AIStation.STATION_BUS_STOP;
		foreach (dummy_id, c in cargo_list) {
			if (!AICargo.HasCargoClass(c, AICargo.CC_PASSENGERS)) {
				this.station_type = AIStation.STATION_TRUCK_STOP;
			}
		}

		::Station_CargoDropTerminal.constructor(station_id, cargo_list);

		this.core = RoadTerminalCore(tiles);
		this.depot = RoadStationDepot(station_id, this.core);
	}

	function GetMemento()
	{
		local memento = {};
		memento.station_id <- this.station_id;
		memento.cargo_list <- CodeUtils.TableToArray(this.cargo_list);
		memento.tiles <- this.core.tiles;
		memento.depot_location <- this.depot.location;
		return memento;
	}

	/**
	 * Checks whether the terminal can be expanded.
	 * @param cargo_id ID of the cargo to sevice with new road stops.
	 * @return True if and only if the terminal can be expanded with
	 *  additional bus/truck stops.
	 */
	function CanBeExpanded(cargo_id)
	{
		return this.core.tiles.len() > this.core.max_upgrades_allowed ? false :
			(this.core.failed_upgrades < 6 && (cargo_id in this.cargo_list));
	}

/* protected */
	function GetMaxFrequency() { return this.core.tiles.len() * 0.22;}
}

Terron_ClassTable.RegisterClass(RoadStation_CargoDropTerminal);
