/**
 * Class that handles truck hubs/routes generation.
 */
class DumbFreightTransportPolitics extends TransportPolitics
{
/* public */
	constructor()
	{
		::TransportPolitics.constructor();

		local cfg = RoadSettings.Get();
		this.d_min = cfg.min_route_length;
		this.d_max = cfg.max_route_length;
	}

	function GetTransportNode(node)
	{
		if (node.IsBuiltOnWater()) return null;

		if (node.type_id != NodeTypeID.NT_TRANSIT_DROP) {
			if (!node.IsTown()) return TruckHub(node, this);
			local min_pop = RoadSettings.lowest_population_limit_for_towns;
			return (node.IsPaxTown() || node.GetPopulation() < min_pop) ?
				null : TruckHub(node, this);
		}
		foreach (c, dummy in node.cargo_ids) {
			if (AICargo.IsFreight(c)) return TruckHub(node, this);
		}
		return null;
	}

	function GetRoutes(from_transport_node, to_transport_node, cargo_ids)
	{
		local s = from_transport_node.node;
		if (s.IsTown()) return {}; // routes only IN towns allowed
		local e = to_transport_node.node;

		local result = {};
		foreach (c, dummy_value in cargo_ids) {
			local is_transit = (e.type_id == NodeTypeID.NT_TRANSIT_DROP);
			local road_route = RoadRoute(s, e, c, is_transit);
			result[road_route.GetID()] <- road_route;
		}
		return result;
	}

/* protected */
	function CanRoute(from_transport_node, to_transport_node)
	{
		local t1 = from_transport_node.node.location;
		local t2 = to_transport_node.node.location;
		local d = AIMap.DistanceManhattan(t1, t2);
		if (d > this.d_max) return false;
		return this.d_min <= d;
	}

	function FinalizeIntegration(truck_hub, transport_schema)
	{
		Linker.RescaleNewNodeLinks(truck_hub);
	}

/* private */
	/** Min allowed road routes' length */
	d_min = 0

	/** Max allowed road routes' length */
	d_max = 0;
}
