/**
 * Class that handles "greedy" freight trade organization.
 */
class DumbTruckControlSection extends AbstractTransportSystem
{
/* public */
	static function GetClassName()
	{
		return "TruckDumbControlSection";
	}

	static function Restore(memento)
	{
		return DumbTruckControlSection(memento.enable_stealing);
	}

	/**
	 * DumbTruckControlSection constructor.
	 * @param enable_stealing Defines whether routes staeling should be on.
	 */
	constructor(enable_stealing)
	{
		::AbstractTransportSystem.constructor();

		this.enable_stealing = enable_stealing;
		this.AddSubsystem(FreightTradeOverseer(TruckHub.GetClassName(), enable_stealing));

		local a_name = "Building simple freight route..."
		local strategy = DumbTruckRoutesConstructionStrategy();
		local t = 22 * GameTime.DAY;
		this.best_action = UniversalAction(a_name, strategy, 4 * t, t);
		this.transport_politics = DumbFreightTransportPolitics();

		NewNodeEvent.AddListener(this);
	}

	function GetName()
	{
		return "SuperTruckHub";
	}

	/**
	 * Intgrate new node into freight network.
	 * @param node New game node.
	 */
	function OnNewNode(node)
	{
		this.transport_politics.EnableTransportNode(node);
	}

/* protected */
	function doGetBestAction()
	{
		return this.best_action;
	}

/* private */
	/** Currently best action to upgrade road freight network. */
	best_action = null;

	/** Defines whether routes staeling should be on */
	</ must_save = true />
	enable_stealing = null;

	/** Freight routes handling strategy. */
	transport_politics = null;
}

Terron_ClassTable.RegisterClass(DumbTruckControlSection);
