/**
 * Pop-up task which allows to act(build self) to certain amount of "best" road
 *  networks and disallows to act to every other road network.
 */
class RoadNetsManagementTask extends Terron_Task
{
/* public */
	constructor(road_networks_coordinator, period)
	{
		::Terron_Task.constructor(AIDate.GetCurrentDate() + GameTime.DAY, period);
		this.road_networks_coordinator = road_networks_coordinator;
		this.te_cargo_ids = {};
		foreach (c, dummy in TransportSchema.Get().node_types[NodeTypeID.NT_RAW_TOWN].consumption) {
			this.te_cargo_ids[c] <- c;
		}
	}

/* protected */
	function Execute()
	{
		this.RemoveFinishedNetworksFromToDoTable();
		this.FindNewBestNetworksAndAddThemIntoToDoTable();
	}

/* private */
	te_cargo_ids = null;

	road_networks_coordinator = null;

	function RemoveFinishedNetworksFromToDoTable()
	{
		local active_networks = this.road_networks_coordinator.GetSubsystems();
		local finished_network_ids = [];
		//local used_nets_to_free = {};
		foreach (id, road_network in active_networks) {
			if (road_network.IsFinished()) {
				finished_network_ids.append(id);
			} else if (
				road_network.IsOnlyUnprofitableRoutesLeft() ||
				!road_network.IsEnabled()
			) {
				finished_network_ids.append(id);
				//used_nets_to_free[road_network.GetName()] <- 1;
			}
		}

		/*if (used_nets_to_free.len() > 0) {
			local used = RoadNetwork.nodes_already_in_networks;
			foreach (from_id, info_arr in used) {
				local index_to_remove = -1;
				foreach (arr_index, info in info_arr) {
					if (info.net_id in used_nets_to_free) {
						index_to_remove = arr_index;
						break; 
					}
				}
				if (index_to_remove != -1) info_arr.remove(index_to_remove);
			}
		}*/

		foreach (dummy, id in finished_network_ids) {
			delete active_networks[id];
		}
	}

	function FindNewBestNetworksAndAddThemIntoToDoTable()
	{
		local active_networks = this.road_networks_coordinator.GetSubsystems();
		local n = MagicNumbers.max_active_road_networks - active_networks.len();
		for (; n > 0; n--) {
			local best_net_info = this.GetBestNetwork();
			local best_net_to_build = best_net_info.best_item;
			if (best_net_to_build != null && best_net_info.best_item_rank > 0) {
				active_networks.AddItem(best_net_to_build);
			}
		}

		CodeUtils.Log("-------- ACTIVE ROAD NETWORKS ---------", 1);
		foreach (dummy_id, item in active_networks) {
			CodeUtils.Log("#" + dummy_id + " " + item.GetName(), 1);
		}
	}

	function GetBestNetwork()
	{
		local result = {};
		result.best_item <- null;
		result.best_item_rank <- -0x0FFFFFFF;

		local all = this.road_networks_coordinator.ordered_town_netwotks;
		local active_networks = this.road_networks_coordinator.GetSubsystems();
		foreach (town_id, stack in all) {
			local is_bad_item = false;
			for (local i = stack.len() - 1; i >= 0; i--) {
				local info = stack[i];
				if (info.net == null) {
					if (i > 0) {
						info.net = RoadNetwork(info.hub);
					} else {
						foreach (c, dummy in this.te_cargo_ids) {
							if (!info.hub.node.IsAcceptingRightNow(c)) continue;
							info.net = RoadNetwork(info.hub);
							break;
						}
					}

					/* happens when town is not accepting goods yet */
					if (info.net == null) break;
				}

				if (info.net.GetNetworkLinks().len() == 0) {
					is_bad_item = true;
					break;
				} else {
					if (active_networks.HasItem(info.net.GetID())) break;

					local p = this.RankNetwork(info.net, active_networks);
					if (p > result.best_item_rank) {
						result.best_item_rank = p;
						result.best_item = info.net;
					}
					if (p > 0) break;
				}
			}

			if (is_bad_item) {
				local n = stack.len();
				stack[n - 1].hub = null;
				stack[n - 1].net = null;
				stack.remove(n - 1);
			}
		}

		return result;
	}

	function RankNetwork(net, active_nets)
	{
		if (
			!net.IsEnabled() ||
			(net.GetID() in active_nets) ||
			net.IsOnlyUnprofitableRoutesLeft()
		) return 0;

		local root = net.root_node;
		local root_id = root.GetID();
		local links = net.GetNetworkLinks();

		local is_built = true;
		foreach (link_id, link in links) {
			foreach (dummy_route_id, route in link.routes) {
				if (is_built && !route.IsCompletelyUpgraded()) is_built = false;

				/* Net is useless when town can't accept goods */
				if (link.to_id == root_id) {
					local c = route.GetCargoID();
					if (!root.node.IsAcceptingRightNow(c)) return 0;
				}
			}
		}
		if (is_built) return 0;

		local routes = {};
		local production = {};
		local net_name = net.GetName();
		local used = RoadNetwork.nodes_already_in_networks;
		local sum_raw_production = 0;
		foreach (dummy_link_id, link in links) {
			foreach (route_id, route in link.routes) {
				local s = route.GetStart();
				local e_id = route.GetEnd().GetID();
				local c = route.GetCargoID();
				if (!(e_id in routes)) routes[e_id] <- {}
				if (!(e_id in production)) production[e_id] <- 0;

				local can_be_used = true;
				if (link.from_id in used) {
					can_be_used = false;
					foreach (dummy_id, info in used[link.from_id]) {
						if (info.net_id == net_name && info.cargo_id == c) {
							can_be_used = true;
							break;
						}
					}
				}

				local p = can_be_used && s.type.raw_production ?
					s.GetFreeProduction(c) : 0;
				sum_raw_production += p;

				local s_id = s.GetID();
				production[s_id] <- p;
				routes[e_id][s_id] <- p;
			}
		}

		if (sum_raw_production < MagicNumbers.supply_net_target_raw_production_sum / 2) return 0;

		while (true) {
			local should_stop = true;
			foreach (e_id, incoming_routes in routes) {
				local accounted = [];
				foreach (s_id, production_rate in incoming_routes) {
					if (production_rate <= 0) continue;
					production[e_id] += 4 * production_rate / 5;
					accounted.append(s_id);
					should_stop = false;
				}

				foreach (dummy, id in accounted) {
					delete incoming_routes[id];
				}
			}

			if (should_stop) break;
		}

		local result = 0;
		foreach (dummy_link_id, link in links) {
			foreach (route_id, route in link.routes) {
				local s = route.GetStart();
				result += route.GetNormalCargoIncome() * production[s.GetID()];
			}
		}

		return result;
	}
}
