/**
 * Class that represents complex road delivery net.
 */
class RoadNetwork extends AbstractTransportSystem
{
/* public */
	static nodes_already_in_networks = {};

	static function GetClassName()
	{
		return "RoadNetwork";
	}

	constructor(root_node)
	{
		if (root_node.GetClassName() != TruckHub.GetClassName()) assert(null);

		::AbstractTransportSystem.constructor();

		this.root_node = root_node;
		this.name = this.root_node.node.GetName() + " road supply network";
		this.network_links = {};
		this.links_to_ignore = {};

		local a_name = this.root_node.node.GetName() + " road net construction";
		local strategy = RoadNetworkConstructionStrategy(this);
		local t = 22 * GameTime.DAY;
		this.build_action = UniversalAction(a_name, strategy, 3 * t, t);

		this.Refresh();
	}

	function GetName()
	{
		return this.name;
	}

	function Clear()
	{
		if (this.network_contingent != null) {
			this.network_contingent.Clear();
			this.network_contingent = null;
		}

		this.network_links.clear();
	}

	function Refresh()
	{
		this.Clear();

		local tmp = SupplyNet.Create(this.root_node); 
		if (tmp != null) {
			this.network_contingent = tmp;
			this.network_links = SupplyNetBuilder.ExcreteMaxNet(tmp, 3, this.links_to_ignore);
		}

		this.build_action.ForceUpdate();
	}

	function GetNetworkLinks()
	{
		return this.network_links;
	}

	function GetRawProductionSum()
	{
		local p = 0;
		foreach (link_id, link in this.GetNetworkLinks()) {
			foreach (dummy_route_id, route in link.routes) {
				local s = route.GetStart();
				p += s.GetLastMonthProduction(route.GetCargoID());
			}
		}

		return p;
	}

	function IsFinished()
	{
		local links = this.GetNetworkLinks();
		foreach (link_id, link in links) {
			foreach (dummy_route_id, route in link.routes) {
				if (!route.IsCompletelyUpgraded()) return false;
			}
		}

		return true;
	}

	unprofitable = false;

	function MarkAsUnprofitable()
	{
		this.unprofitable = true;
	}

	function IsOnlyUnprofitableRoutesLeft()
	{
		return this.unprofitable;
	}

	function HandleBadLink(failed_to_build_link)
	{
		local id = failed_to_build_link.GetID();
		local links = this.GetNetworkLinks();
		if (id in links) {
			delete links[id];
			if (id in this.links_to_ignore) {
				this.Disable(2 * GameTime.YEAR);
			}

			this.links_to_ignore[id] <- 1;
			this.Refresh();
		}
		return 0;
	}

/* protected */
	function doGetBestAction()
	{
		return this.network_contingent == null ? null : this.build_action;
	}

/* private */
	root_node = null;

	/** Action responsible for actual construction of this network. */
	build_action = null;

	name = null;

	network_contingent = null;

	network_links = null;

	links_to_ignore = null;
}
