/**
 * Class that handles all town-to-town trade organization.
 */
class BusHubControlSection extends AbstractTransportSystem
{
/* public */
	static function GetClassName()
	{
		return "BusHubControlSection";
	}

	static function Restore(memento)
	{
		return BusHubControlSection();
	}

	/**
	 * Creates a bus hubs controller.
	 */
	constructor()
	{
		::AbstractTransportSystem.constructor();

		local a_name = "Building town-to-town road route...";
		local t = 22 * GameTime.DAY;
		local strategy = BusHubControlSection_LocalBuildStrategy(this);
		this.best_action = UniversalAction(a_name, strategy, 3 * t, t);
		this.transport_politics = TownToTownTransportPolitics();

		GlobalTransportMap.Get().SetUpNewTransportNodeClass(BusHub.GetClassName());

		NewNodeEvent.AddListener(this);
		AIStartedEvent.AddListener(this);
		TransportSystemClosedEvent.AddListener(this);
	}

	function GetName()
	{
		return "SuperBusHub";
	}

	/**
	 * Restore own trade lines after game load.
	 */
	function OnAIStarted(is_game_loaded)
	{
		if (is_game_loaded) {
			local a = AISearchRoadTradeRoutesAction(BusHub.GetClassName());
			Corporation.Get().AddAction(a);
		}
	}

	/**
	 * Intgrate new node into bus network.
	 * @param node Newly found node.
	 */
	function OnNewNode(node)
	{
		local new_bus_hub = this.transport_politics.EnableTransportNode(node);
		if (new_bus_hub != null) this.AddSubsystem(new_bus_hub);
	}

	/**
	 * Reopen town if it become closed.
	 * transport_system The closed transport system.
	 */
	function OnTransportSystemClose(transport_system)
	{
		if (transport_system.GetClassName() != BusHub.GetClassName()) return;
		this.OnNewNode(transport_system.node);
	}

	function GetBestAction()
	{
		return this.best_action;
	}

/* private */
	/** Currently best action handles town-to-town trade building. */
	best_action = null;

	/** Bus/mail lines handling strategy. */
	transport_politics = null;
}

Terron_ClassTable.RegisterClass(BusHubControlSection);
