/**
 * Task that handles better town pairs re-search.<p>
 * When triggered this task renew information about pairs of connected hubs
 *  and corresponding routes.<p>
 */
class BusHubControlSection_ReshakeTowns extends Terron_Task
{
/* public */
	constructor(bus_hub_control_section, routes)
	{
		local date = AIDate.GetCurrentDate() + GameTime.DAY;
		::Terron_Task.constructor(date, 90 * GameTime.DAY);

		this.bus_hub_control_section = bus_hub_control_section;
		this.routes = routes;

		RegionScanFinishedEvent.AddListener(this);
		TransportSystemClosedEvent.AddListener(this);
	}

	/**
	 * Keep own data up to date right from the start.
	 */
	function OnRegionScanFinished(r_id)
	{
		this.Execute();
	}

	/**
	 * Purge information about closed town node from self.
	 * transport_system The closed transport system.
	 */
	function OnTransportSystemClose(transport_system)
	{
		if (transport_system.GetClassName() != BusHub.GetClassName()) return;
		local town = transport_system.node;
		foreach (id, route_info in this.routes) {
			local route = route_info.pass;
			if (route == null) {
				delete this.routes[id];
				continue;
			}
			if (town.IsEqual(route.GetStart()) || town.IsEqual(route.GetEnd())) {
				delete this.routes[id];
			}
		}
	}

/* protected */
	function Execute()
	{
		local t = AIController.GetTick();
		local subsystems = this.bus_hub_control_section.GetSubsystems();
		foreach (dummy_id, item in subsystems) {
			item.Reshake();
		}
		CodeUtils.Log(
			"Bus hubs reshake... " + (AIController.GetTick() - t) + " ticks.", 1
		);

		this.routes.clear();
		local pass = CorporationUtils.pass_cargo_id.value;
		local mail = CorporationUtils.mail_cargo_id.value;
		foreach (dummy_child_id, child in subsystems) {
			foreach (link_id, info in child.best_links) {
				foreach (route_id, route in info.link.routes) {
					if (route.cargo_id != pass) continue;
					if (RoadDepartment.Get().GetDevelopmentProgress() < 0.2) {
						local cfg = RoadSettings.Get();
						local m = min(cfg.max_route_length, 90);
						if (route.length > m) continue;
					}

					if (route_id in this.routes) continue;
					this.routes[route_id] <- {pass = null, mail = null};
					this.routes[route_id].pass = route;

					foreach (dummy_route_id, mail_route in info.link.routes) {
						if (mail_route.cargo_id != mail) continue;
						this.routes[route_id].mail = mail_route;
					}
				}
			}
		}
	}

/* private */
	/** AI section that hold bus hubs as subsystems. */
	bus_hub_control_section = null;

	/** Container with all currently available bus routes. */
	routes = null;
}
