/**
 * Base transport node for pax transit.
 */
class PaxTransitHub extends TransportNode
{
/* public */
	static function GetClassName()
	{
		return "PaxTransitHub";
	}

	/** True if and only if this node represents cargo transit station. */
	is_drop_point = false;

	constructor(node, transport_politics, is_drop_point)
	{
		::TransportNode.constructor(node, transport_politics);
		this.is_drop_point = is_drop_point;
		this.name = node.GetName() + (is_drop_point ? " passengers transit hub" :
			" town");
	}

	function CanBeRoot()
	{
		return true;
	}
}
