/**
 * Class that handles pax transit routes generation.
 */
class PaxTransitTransportPolitics extends TransportPolitics
{
/* public */
	function GetTransportNode(node)
	{
		if (node.type_id == NodeTypeID.NT_TRANSIT_DROP) {
			return TransitType.TT_BUS in node.transport_types_allowed ?
				PaxTransitHub(node, this, true) : null;
		} else {
			if (!node.IsTown()) return null;
			local min_pop = RoadSettings.lowest_population_limit_for_towns;
			if (node.GetPopulation() < min_pop) return null;
			return node.IsPaxTown() ? PaxTransitHub(node, this, false) : null;
		}
	}

	function GetRoutes(from_transport_node, to_transport_node, cargo_ids)
	{
		local s = from_transport_node.node;
		local e = to_transport_node.node;

		local result = TableContainer.new("Routes");
		foreach (c, dummy_value in cargo_ids) {
			if (!(c in to_transport_node.node.cargo_ids)) continue;
			local is_transit = (e.type_id == NodeTypeID.NT_TRANSIT_DROP);
			result.AddItem(RoadRoute(s, e, c, is_transit));
		}
		return result;
	}

/* protected */
	function CanRoute(from_transport_node, to_transport_node)
	{
		if (from_transport_node.is_drop_point) return false;
		if (!to_transport_node.is_drop_point) return false;
		local t1 = from_transport_node.node.location;
		local t2 = to_transport_node.node.location;
		local d = AIMap.DistanceManhattan(t1, t2);

		return (4 <= d && d <= RoadSettings.max_transit_range);
	}

	function FinalizeIntegration(transit_hub, transport_schema)
	{
		//Linker.RescaleNewNodeLinks(transit_hub);
	}
}
