/**
 * Dock terminal implementation.
 */
class DockTerminal extends Station_LoadingTerminal
{
/* public */
	static function GetClassName()
	{
		return "DockTerminal";
	}

	static function Restore(memento)
	{
		return DockTerminal(memento.station_id, memento.cargo_id);
	}

	constructor(station_id, cargo_id)
	{
		::Station_LoadingTerminal.constructor(station_id, cargo_id);

		this.location = AIStation.GetLocation(station_id);
	}

	function GetMemento()
	{
		return {station_id = this.station_id, cargo_id = this.cargo_id};
	}

/* protected */
	target_rating = 70;

	function GetLoadingVehicles()
	{
		local v_list = AIVehicleList_Station(this.station_id);

		v_list.Valuate(AIVehicle.GetState);
		v_list.KeepValue(AIVehicle.VS_AT_STATION);
 
		local f = function(v) {
			return AIOrder.GetOrderDestination(v, AIOrder.ResolveOrderPosition(v, AIOrder.ORDER_CURRENT));
		}
		v_list.Valuate(f);
		v_list.KeepValue(this.location);

		v_list.Valuate(AIVehicle.GetCapacity, this.cargo_id);
		v_list.RemoveValue(0);

		return v_list.Count();
	}

	function GetMaxLoadingVehicles()
	{
		return 2;
	}

	function GetMaxFrequency()
	{
		return this.max_frequency;
	}

/* private */
	/** The dock location. */
	location = null;

	/** Max allowed vehicles arrival frequency for the terminal. */
	max_frequency = 10.0;
}

Terron_ClassTable.RegisterClass(DockTerminal);
