require("WASTAR.nut");
require("WQTASTAR.nut");
require("WHPASTAR.nut");

/**
 * Access to water pathfinding.
 */
class WHPASTAR_Adapter
{
/* public */
	/**
	 * Find water route between given tile sets.
	 */
	static function FindBuoyPath(s_array, e_array, qt, max_buoys_interval)
	{
		return WHPASTAR().FindPath(s_array, e_array, qt, max_buoys_interval); 
	}

	/**
	 * Build buoys.
	 */
	static function BuildBuoys(tile_ids_array)
	{
		foreach (dummy_id, t in tile_ids_array) {
			if (AIMarine.IsBuoyTile(t)) continue;
			if (AIMarine.BuildBuoy(t)) continue;

			AIController.Sleep(2 * Ticks.DAY);

			if (!AIMarine.BuildBuoy(t)) return false;
		}

		return true;
	}

	/**
	 * Check if the two water tiles are connected.
	 * Must be used when tiles are close to each other.
	 */
	static function AreTilesConnectedShort(s, e)
	{
		local max_time = max(Ticks.DAY, AIMap.DistanceManhattan(s, e));
		return WASTAR().FindPath(s, e, max_time) != null;
	}
}
