/**
 * Class that represents large(enough), near-water town.
 */
class CruiseCenter extends TransportNode
{
/* public */
	static function GetClassName()
	{
		return "CruiseCenter";
	}

	/**
	 * Creates a new CruiseCenter.
	 * @param town_node Base town node.
	 * @param transport_politics Control politics.
	 */
	constructor(town_node, transport_politics, basin_id)
	{
		::TransportNode.constructor(town_node, transport_politics);
		this.name = town_node.GetName() + " cruise center";
		this.basin_id = basin_id;
	}

	function CanBeRoot()
	{
		return true;
	}

	/** ID of the water basin to which this cruise center belongs. */
	basin_id = null;
}
