/**
 * Class that handles cruise lines/centers generation.
 */
class CruiseTransportPolitics extends TransportPolitics
{
/* public */
	function GetTransportNode(node)
	{
		if (!node.IsTown()) return null;
		if (!node.IsPaxTown()) return null;
		if (node.GetPopulation() < 500) return null;
		if (node.GetRegion() != WaterSettings.Get().region_to_operate) return null;

		local tiles = node.AITileList_NodeProducing(4);
		tiles.Valuate(AITile.IsCoastTile);
		tiles.RemoveValue(0);

		local r = 5;
		local qt = ShipDepartment.Get().water_qt;
		foreach (t, dummy in tiles) {
			local x = AIMap.GetTileX(t);
			local y = AIMap.GetTileY(t);
			local water_around = qt.GetIntersection(x - r, y - r, x + r, y + r, SeaLevelRecognition.SL_SEA_SHORE);
			foreach (dummy_id, water_patch in water_around) {
				if (!(MarineBasin.key in water_patch.custom_data)) continue;
				local basin_id = water_patch.custom_data[MarineBasin.key];
				if (basin_id != -1) {
					return CruiseCenter(node, this, basin_id);
				}
			}
		}

		return null;
	}

	function GetRoutes(from_transport_node, to_transport_node, cargo_ids)
	{
		local s = from_transport_node.node;
		local e = to_transport_node.node;
		local result = TableContainer.new("Routes");
		local pass_cargo_id = CorporationUtils.pass_cargo_id.value;
		local s_basin_id = from_transport_node.basin_id;
		local e_basin_id = to_transport_node.basin_id;
		foreach (c, dummy_value in cargo_ids) {
			if (c != pass_cargo_id) continue;
			result.AddItem(CruiseRoute(s, s_basin_id, e, e_basin_id, c));
		}
		return result;
	}

/* protected */
	function CanRoute(from_transport_node, to_transport_node)
	{
		local t1 = from_transport_node.node.location;
		local t2 = to_transport_node.node.location;
		local d = AIMap.DistanceManhattan(t1, t2);
		local cfg = WaterSettings.Get();
		if (d < cfg.min_route_length || cfg.max_route_length < d) return false;
		if (from_transport_node.basin_id == to_transport_node.basin_id) {
			return true;
		}
		local seas = ShipDepartment.Get().seas;
		local s1 = seas[from_transport_node.basin_id];
		return to_transport_node.basin_id in s1.adjacent_basins;
	}

	function FinalizeIntegration(cruise_center, transport_schema)
	{
		Linker.RescaleNewNodeLinks(cruise_center);
	}
}
