/**
 * Class Station_Terminal.
 */
class Station_Terminal extends Terron_SaveableObject
{
/* public */
	/** Terminal build date */
	build_date = -1;

	/** Average vehicles arrival frequency. */
	current_arrival_frequency = 0;

	/** Host station ID. */
	station_id = null;

	/**
	 * Station_Terminal constructor.
	 * @param station_id Host station ID.
	 * @note Terminal must not exist without host station.
	 */
	constructor(station_id)
	{
		::Terron_SaveableObject.constructor(null);
		this.build_date = AIDate.GetCurrentDate();
		this.station_id = station_id;
		this.arrival_frequency_map = {};
	}

	/**
	 * Is this terminal only to unload cargo from vehicles?
	 * @return True if yes, false if no.
	 */
	function UnloadOnly()
	{
		return false;
	}

	/**
	 * Notify this station about added vehicle.
	 * @param v Vehicle ID.
	 * @param arrival_frequency 1.0 / [average time between vehicle arrivals].	
	 */
	function AddVehicle(v, arrival_frequency)
	{
		this.arrival_frequency_map[v] <- arrival_frequency;
		this.current_arrival_frequency += arrival_frequency;
	}

	/**
	 * Get number of vehicles registered for this terminal.
	 */
	function GetVehiclesCount()
	{
		return this.arrival_frequency_map.len();
	}

	/**
	 * Notify this station about removed vehicle.
	 * @param v Vehicle ID.
	 * @param arrival_frequency 1.0 / [average time between vehicle arrivals].
	 */
	function RemoveVehicle(v)
	{
		local map = this.arrival_frequency_map;
		if (v in map) this.current_arrival_frequency -= delete map[v];
	}

	/**
	 * Get the amount of vehicles that can be added.
	 * @param arrival_frequency = 1.0 / [average time between vehicle arrivals]
	 * @return The amount of vehicles we can add to the station, negative
	 *  value mean it's already overcharged with vehicles.
	 */
	function GetFreeSheduleSlots(arrival_frequency)
	{
		local df = this.GetMaxFrequency() - this.current_arrival_frequency;
		// -1 due to "round to zero", e.g. -0.99.tointeger() is 0
		return (df / arrival_frequency).tointeger() + (df < 0 ? -1 : 0);
	}

/* protected */
	/** Table with pairs [vehicle id, vehicle arrival frequency] */
	arrival_frequency_map = null;

	/**
	 * Get the max allowed vehicles arrival frequency.
	 */
	function GetMaxFrequency() { return 0;}
	
}
