/**
 * Some utility functions here.
 */
class CodeUtils
{
	/**
	 * Convert given table to array.
	 * Keys become lost.
	 * @param table The table to convert.
	 * @return Array with same items that was in the table.
	 */
	static function TableToArray(table)
	{
		local result = array(table.len()), i = 0;
		foreach (dummy_id, item in table) {
			result[i++] = item;
		}

		return result;
	}

	/**
	 * Convert given AIList to array.
	 * Values become lost.
	 * @param ai_list The list to convert.
	 * @return Array with items corresponding to list keys.
	 */
	static function ListToArray(ai_list)
	{
		local result = array(ai_list.Count()), i = 0;
		foreach (key, dummy in ai_list) {
			result[i++] = key;
		}

		return result;
	}

	/**
	 * Replaces spaces(" ") in a string to underscopes("_").
	 * @param s The string to modify (but it'll remain the same).
	 * @return The new string.
	 */
	static function MakeNoSpacesString(s)
	{
		local i = 0;
		local result = ""
		while (true) {
			local j = s.find(" ", i);
			if (j == null) {
				result += s.slice(i);
				return result;
			}
			result += s.slice(i, j) + "_";
			i = j + 1;
		}
	}

	/**
	 * Replacement for AILog.Info function.
	 * @param text String to type in log.
	 * @param level Integer >= 0. Lesser levels for routine debug, so
	 *  sensible messages must be logged with level at least 2.
	 */
	static function Log(text, level)
	{
		if (level >= CodeUtils.log_level) AILog.Info(text);
	}

	/**
	 * Messages with log level < this one will not be displayed.
	 */
	static log_level = 0;

	/**
	 * Integer log with 2 as base.
	 */
	static function iLog2(x)
	{
		return 31 - CodeUtils.nlz(x);
	}

	/**
	 * Returns number of leading zeros in binary represntation of x.
	 */
	static function nlz(x)
	{
		local n = 32, y;

		y = x >> 16;
		if (y != 0) {
			n = n - 16;
			x = y;
		}

		y = x >> 8;
		if (y != 0) {
			n = n - 8;
			x = y;
		}

		y = x >> 4;
		if (y != 0) {
			n = n - 4;
			x = y;
		}

		y = x >> 2;
		if (y != 0) {
			n = n - 2;
			x = y;
		}

		y = x >> 1;
		if (y != 0) return n - 2;
		return n - x;
	}
}
