/**
 * Visitor class that searches hierarchy items having given object as subsystem.
 * It will scan given transport system (use Visit function),
 * and return (use GetResult function) all it's parts,
 * which have given object(constructor param) in the subsystems container.
 */
class VGetOwners extends Visitor
{
/* public */
	/**
	 * Creates a VGetItemsByType visitor object.
	 * @param classname_to_search class name to search objects.
	 */
	constructor(object)
	{
		this.key_object_id = object.GetID();
		this.result = TableContainer.new("Vistor Result");
	}

	/**
	 * Get the visit result.
	 * @return table, containing founded objects.
	 */
	function GetResult()
	{
		return this.result;
	}

/* protected */
	function doVisit(transport_system)
	{
		local key_id = this.key_object_id;
		foreach (id, item in transport_system.GetSubsystems()) {
			if (id == key_id) this.result.AddItem(transport_system);
		}
	}

/* private */
	/** Objects which "parents" we are searching */
	key_object_id = null;

	/** Table to store found objects */
	result = null;
}
