import("pathfinder.road", "RoadPathFinder", 3);
class EpicTrans extends AIController {	name = null;
	towns_used = null;
	route_1 = null;
	route_2 = null;
	distance_of_route = {};
	vehicle_to_depot = {};
	delay_build_airport_route = 500;
	passenger_cargo_id = -1;
    constructor(){
		this.towns_used = AIList();
		this.route_1 = AIList();
		this.route_2 = AIList();

		local list = AICargoList();
		for (local i = list.Begin(); list.HasNext(); i = list.Next()) {
			if (AICargo.HasCargoClass(i, AICargo.CC_PASSENGERS)) {
				this.passenger_cargo_id = i;
				break;
			}
	}	}
}function EpicTrans::Start()
{
	local placeind=1000;
	while(!AICompany.BuildCompanyHQ(placeind))
	placeind++;
	AICompany.SetName("EPIC WINNING COMPANY");
	AICompany.SetPresidentName("OWNER OF THE WORLD");
	AICompany.SetLoanAmount(AICompany.GetMaxLoanAmount());
//init company
  local townpoplist = AITownList();
  townpoplist.Valuate(AITown.GetPopulation);
  townpoplist.Sort(AIAbstractList.SORT_BY_VALUE, false);
  local townid_a = townpoplist.Begin();		//suche die grte Stadt
   while(true)
   {
      local townlist = AIList();
      for(local i=0;i<townpoplist.Count();i++)
         townlist.AddItem(i,AITown.GetDistanceSquareToTile(i,AITown.GetLocation(townid_a)));
      townlist.Sort(AIAbstractList.SORT_BY_VALUE, true);
      local townid_b = townlist.Begin();//sortiere alle stdte nach der entfernung zur gesuchteen stadt und finde die nchstgelegene
      local stcou=0;
      AILog.Info(" "+townpoplist.Count()+" "+townlist.Count()+" "+townid_a+" "+townid_b+"");
     this.ManageAirRoutes();
this.BuildAirportRoute();
      for(local i=0;i<5;i++)
      {
          townid_b = townlist.Next();
          AILog.Info("Going to connect " + AITown.GetName(townid_a) + " to " + AITown.GetName(townid_b));
          AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);
          local pathfinder = RoadPathFinder();
          pathfinder.cost.turn = 100;
          pathfinder.InitializePath([AITown.GetLocation(townid_a)], [AITown.GetLocation(townid_b)]);
          stcou=0;
       //   while(!AIRoad.BuildDriveThroughRoadStation([AITown.GetLocation(townid_b)]+stcou))
         //    stcou++;
          local path = false;
          local j=0;
          while (path == false&&j<500)
          {
             j++;
             AILog.Info("try to find path for the"+j+" time");
             path = pathfinder.FindPath(100);
             //AIController.Sleep(1);
		if(j>=498)
		    i=5;
          }
          if (path == false||path==null) {
              AILog.Error("pathfinder.FindPath return null");
            }
            while (path != false&&path!=null) {
              local par = path.GetParent();
              if (par != null) {
                local last_node = path.GetTile();
                if (AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) == 1 ) {
                  if (!AIRoad.BuildRoad(path.GetTile(), par.GetTile())) {
                   }
                }  else {
					if (!AIBridge.IsBridgeTile(path.GetTile()) && !AITunnel.IsTunnelTile(path.GetTile())) {
						if (AIRoad.IsRoadTile(path.GetTile())) AITile.DemolishTile(path.GetTile());
        if (AITunnel.GetOtherTunnelEnd(path.GetTile()) == par.GetTile()) {
          if (!AITunnel.BuildTunnel(AIVehicle.VT_ROAD, path.GetTile())) {
          }
        } else {
          local bridge_list = AIBridgeList_Length(AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) + 1);
          bridge_list.Valuate(AIBridge.GetMaxSpeed);
          bridge_list.Sort(AIList.SORT_BY_VALUE, true);
          if (!AIBridge.BuildBridge(AIVehicle.VT_ROAD, bridge_list.Begin(), path.GetTile(), par.GetTile())) {
          }
                    }
                  }
                }
              }
              path = par;
			 // EpicTrans.BuildBusStop(townid_b);
            }//baue Strae und verbinde die jetzt noch nicht verbundenenchste stadt
	    
EpicTrans.BuildBusStop(townid_b);
    	  EpicTrans.BuildRVStation(townid_a,"depot");
		EpicTrans.FillRoute(townid_a,townid_b);}
       //suche nchstgrere stadt     
 townid_a=townpoplist.Next();
   }		
  AILog.Info("Done");
}



//_--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function EpicTrans::GetDepot(town)
{
    local depotList = AIDepotList(AITile.TRANSPORT_ROAD);
		depotList.Valuate(AITile.GetClosestTown);
		depotList.KeepValue(town);
		if (!depotList.IsEmpty()) {
			AILog.Info("Depot in " + AITown.GetName(town) + " found. Using it instead of building one");
			local depotTile = depotList.Begin();
	AILog.Info(depotTile);
			return depotTile;
		}
}
function EpicTrans::GetStation(town)
{
    local stationList = AIStationList(AIStation.STATION_ANY);
		stationList.Valuate(AIStation.GetNearestTown);
		stationList.KeepValue(town);
		if (!stationList.IsEmpty()) {
			AILog.Info("Station in " + AITown.GetName(town) + " found. Using it instead of building one");
			local stationTile = stationList.Begin();
	                AILog.Info(stationTile);
			return AIStation.GetLocation(stationTile);
		}
}
function EpicTrans::FillRoute(towna,townb)
{
    local stationa=EpicTrans.GetStation(towna);
    local depot=EpicTrans.GetDepot(towna);
    local stationb=EpicTrans.GetStation(townb);
AILog.Info("Init");
while(stationa==null)
    {
EpicTrans.BuildBusStop(towna);
AILog.Error("no station exists");
stationa=EpicTrans.GetStation(towna);
    }
if(stationa!=null&&stationb!=null&&depot!=null)
    { 
local engine=EpicTrans.SelectVehicles();
    local vehicle_id = AIVehicle.BuildVehicle(depot, engine);
if(!AIRoad.IsDriveThroughRoadStationTile(stationa))AILog.Error("a not exists");
	AIOrder.AppendOrder(vehicle_id, stationa,0);
if(AIRoad.IsDriveThroughRoadStationTile(stationb))
	AIOrder.AppendOrder(vehicle_id, stationb,0);
		local builtVehicle_id = vehicle_id;
	AIVehicle.StartStopVehicle(builtVehicle_id);
		vehicle_id = AIVehicle.CloneVehicle(depot, builtVehicle_id, true);
	AIVehicle.StartStopVehicle(vehicle_id);
		vehicle_id = AIVehicle.CloneVehicle(depot, builtVehicle_id, true);
	AIVehicle.StartStopVehicle(vehicle_id);
		vehicle_id = AIVehicle.CloneVehicle(depot, builtVehicle_id, true);
	AIVehicle.StartStopVehicle(vehicle_id);
if(AIVehicle.IsValidVehicle(vehicle_id)) 
AILog.Info("BUS BUILT IN"+AITown.GetName(towna));
return true;
    }
else
return false;
}
	
function EpicTrans::SelectVehicles()
{
	local list = AICargoList();
	local passenger_cargo_id = null;
	for (local i = list.Begin(); !list.IsEnd(); i = list.Next()) {
		if (AICargo.HasCargoClass(i, AICargo.CC_PASSENGERS) &&
		    AICargo.GetTownEffect(i) == AICargo.TE_PASSENGERS) {
			passenger_cargo_id = i;
			break;
		}
	}
	local engine_list = AIEngineList(AIVehicle.VT_ROAD);
	engine_list.Valuate(AIEngine.GetRoadType);
	engine_list.KeepValue(AIRoad.ROADTYPE_ROAD);
	
	engine_list.Valuate(AIEngine.GetCargoType);
	engine_list.KeepValue(passenger_cargo_id);

	engine_list.Valuate(AIEngine.GetDesignDate);
	engine_list.Sort(AIList.SORT_BY_VALUE, false);
	local engine = engine_list.Begin();
	return engine;
}
function EpicTrans::BuildRVStation(townid, type)
{
	local buildType = null;
	Info("Building bus " + type + " in " + AITown.GetName(townid));
	if (type == "station") {
		buildType = AIRoad.BT_BUS_STOP;
	}
	else if (type == "depot") {
		buildType = AIRoad.BT_DEPOT;
		Info("Checking for pre-built depots in " + AITown.GetName(townid));
		local depotList = AIDepotList(AITile.TRANSPORT_ROAD);
		depotList.Valuate(AITile.GetClosestTown);
		depotList.KeepValue(townid);
		if (!depotList.IsEmpty()) {
			Info("Depot in " + AITown.GetName(townid) + " found. Using it instead of building one");
			local depotTile = depotList.Begin();
			return depotTile;
		}
		Info("No depot in " + AITown.GetName(townid) + " found");
	}
	local range = 1;
	local area = AITileList();
	local townLocation = AITown.GetLocation(townid);
	
	while (range < 15) {
		area.AddRectangle(townLocation - AIMap.GetTileIndex(range, range), townLocation + AIMap.GetTileIndex(range, range));
		area.Valuate(AITile.IsBuildable);
		area.KeepValue(1);
		if (area.Count()) {
			for (local buildTile = area.Begin(); !area.IsEnd(); buildTile = area.Next()) {
				local buildFront = getRoadTile(buildTile);
				if (buildFront) {
					if (!AIRoad.BuildRoad(buildTile, buildFront)) {
						switch (AIError.GetLastError()) {
							case AIError.ERR_NOT_ENOUGH_CASH:
								Warning("Not enough money to build road for bus " + type + ". Waiting for more");
								while (AICompany.GetBankBalance(AICompany.COMPANY_SELF) < AIRoad.GetBuildCost(AIRoad.ROADTYPE_ROAD, AIRoad.BT_ROAD)) {
									if (!AITile.IsBuildable(buildTile)) continue;
									AIController.Sleep(10000);
								}
								if (!AIRoad.BuildRoad(buildTile, buildFront)) return null;
								break;
							case AIError.ERR_VEHICLE_IN_THE_WAY:
								while (!AIRoad.BuildRoad(buildTile, buildFront)) {
									if (!AITile.IsBuildable(buildTile)) continue;
									AIController.Sleep(1000);
								}
								break;
							case AIError.ERR_ALREADY_BUILT:
							break;
							case AIError.ERR_LAND_SLOPED_WRONG:
							case AIError.ERR_AREA_NOT_CLEAR:
							case AIRoad.ERR_ROAD_ONE_WAY_ROADS_CANNOT_HAVE_JUNCTIONS:
							case AIRoad.ERR_ROAD_WORKS_IN_PROGRESS:
							default:
								Warning("Unhandled error while building bus " + type + ": " + AIError.GetLastErrorString() + ". Trying again");
								continue;
						}
					}
					local buildStructure = null;
					if (type == "depot") buildStructure = AIRoad.BuildRoadDepot(buildTile, buildFront);
					else if (type == "station") buildStructure = AIRoad.BuildRoadStation(buildTile, buildFront, AIRoad.ROADVEHTYPE_BUS, AIStation.STATION_JOIN_ADJACENT);
					else return null;
					if (!buildStructure) {
						switch (AIError.GetLastError()) {
							case AIError.ERR_NOT_ENOUGH_CASH:
								Warning("Not enough money to build bus " + type + ". Waiting for more");
								while (AICompany.GetBankBalance(AICompany.COMPANY_SELF) < AIRoad.GetBuildCost(AIRoad.ROADTYPE_ROAD, buildType)) {
									if (!AITile.IsBuildable(buildTile)) continue;
									AIController.Sleep(10000);
								}
								if (type == "depot" && !AIRoad.BuildRoadDepot(buildTile, buildFront)) return null; 
								else if (type == "station" && !AIRoad.BuildRoadStation(buildTile, buildFront, AIRoad.ROADVEHTYPE_BUS, AIStation.STATION_JOIN_ADJACENT)) return null;
								break;
							case AIError.ERR_FLAT_LAND_REQUIRED:
							case AIError.ERR_AREA_NOT_CLEAR:
							default:
								Warning("Unhandled error while building bus " + type + ": " + AIError.GetLastErrorString() + ". Trying again");
								continue;
						}
					}
					Info("Successfully built bus " + type);
					return buildTile;
				}
			}
			range++;
		} else {
			range++;
			area.Clear;
		}
	}
	Error("Building bus " + type + " in " + AITown.GetName(townid) + " failed");
	return null;
}

function EpicTrans::getRoadTile(tile) //From OTVI
{
	local adjacent = AITileList();
	adjacent.AddTile(tile - AIMap.GetTileIndex(1,0));
	adjacent.AddTile(tile - AIMap.GetTileIndex(0,1));
	adjacent.AddTile(tile - AIMap.GetTileIndex(-1,0));
	adjacent.AddTile(tile - AIMap.GetTileIndex(0,-1));
	adjacent.Valuate(AIRoad.IsRoadTile);
	adjacent.KeepValue(1);
	adjacent.Valuate(AIRoad.IsRoadStationTile);
	adjacent.KeepValue(0);
	adjacent.Valuate(AITile.GetSlope);
	adjacent.KeepValue(AITile.SLOPE_FLAT);
	if (adjacent.Count()) return adjacent.Begin();
	else return null;
}
function EpicTrans::BuildBusStop(town)
{
	local range = 1;
	local max_range = 20; 
	local area = AITileList();
		
	while (range < max_range) {
		area.AddRectangle(AITown.GetLocation(town) - AIMap.GetTileIndex(range, range), AITown.GetLocation(town) + AIMap.GetTileIndex(range, range));
		area.Valuate(AIRoad.IsRoadTile);
		area.KeepValue(1);
		area.Valuate(AIRoad.IsDriveThroughRoadStationTile);
		area.KeepValue(0);
		area.Valuate(AITile.GetSlope);
		area.KeepValue(AITile.SLOPE_FLAT);
		area.Valuate(AIRoad.GetNeighbourRoadCount);
		area.KeepValue(2);
		if (area.Count()) {
			for (local station = area.Begin(); !area.IsEnd(); station = area.Next()) {
				local opening = getRoadTile(station);
				if (opening) {
					if (AIRoad.BuildDriveThroughRoadStation(station, opening, AIRoad.ROADVEHTYPE_BUS, AIStation.STATION_JOIN_ADJACENT)) {
					return station;
						
					}
				}
			}
			range++;
		} else {
			range++;
		}
	}return null;
}

function EpicTrans::Info(string)
{
	AILog.Info(" [Bus Route Builder] " + string + ".");
}


function EpicTrans::Warning(string)
{
	AILog.Warning(" [Bus Route Builder] " + string + ".");
}

function EpicTrans::Error(string)
{
	AILog.Error(" [Bus Route Builder] " + string + ".");
}

function EpicTrans::Debug(string)
{
	AILog.Warning(" [Bus Route Builder] DEBUG: " + string + ".");
	AILog.Warning(" [Bus Route Builder] (if you see this, please inform the AI Dev in charge, as it was supposed to be removed before release)");
}
function EpicTrans::HasMoney(money)
{
	if (AICompany.GetBankBalance(AICompany.COMPANY_SELF) + (AICompany.GetMaxLoanAmount() - AICompany.GetLoanAmount()) > money) return true;
	return false;
}
function EpicTrans::GetMoney(money)
{
	if (!this.HasMoney(money)) return;
	if (AICompany.GetBankBalance(AICompany.COMPANY_SELF) > money) return;

	local loan = money - AICompany.GetBankBalance(AICompany.COMPANY_SELF) + AICompany.GetLoanInterval() + AICompany.GetLoanAmount();
	loan = loan - loan % AICompany.GetLoanInterval();
	AILog.Info("Need a loan to get " + money + ": " + loan);
	AICompany.SetLoanAmount(loan);
}
function EpicTrans::BuildAirportRoute()
{
	local airport_type = (AIAirport.IsValidAirportType(AIAirport.AT_LARGE) ? AIAirport.AT_LARGE : AIAirport.AT_SMALL);

	this.GetMoney(GetSetting("min_money_route"));

	AILog.Info("Trying to build an airport route");

	local tile_1 = this.FindSuitableAirportSpot(airport_type, 0);
	if (tile_1 < 0) return -1;
	local tile_2 = this.FindSuitableAirportSpot(airport_type, tile_1);
	if (tile_2 < 0) {
		this.towns_used.RemoveValue(tile_1);
		return -2;
	}

	if (!AIAirport.BuildAirport(tile_1, airport_type, AIStation.STATION_NEW)) {
		AILog.Error("Although the testing told us we could build 2 airports, it still failed on the first airport at tile " + tile_1 + ".");
		this.towns_used.RemoveValue(tile_1);
		this.towns_used.RemoveValue(tile_2);
		return -3;
	}
	if (!AIAirport.BuildAirport(tile_2, airport_type, AIStation.STATION_NEW)) {
		AILog.Error("Although the testing told us we could build 2 airports, it still failed on the second airport at tile " + tile_2 + ".");
		AIAirport.RemoveAirport(tile_1);
		this.towns_used.RemoveValue(tile_1);
		this.towns_used.RemoveValue(tile_2);
		return -4;
	}

	local ret = this.BuildAircraft(tile_1, tile_2);
	if (ret < 0) {
		AIAirport.RemoveAirport(tile_1);
		AIAirport.RemoveAirport(tile_2);
		this.towns_used.RemoveValue(tile_1);
		this.towns_used.RemoveValue(tile_2);
		return ret;
	}

	AILog.Info("Done building a route");
	return ret;
}
function EpicTrans::BuildAircraft(tile_1, tile_2)
{
	local hangar = AIAirport.GetHangarOfAirport(tile_1);
	local engine = null;

	local engine_list = AIEngineList(AIVehicle.VT_AIR);

	local balance = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
	engine_list.Valuate(AIEngine.GetPrice);
	engine_list.KeepBelowValue(balance < (GetSetting("min_money_costly_aircraft")) ? 50000 : (balance < 1000000 ? (GetSetting("min_money_costly_aircraft")) : 1000000));

	engine_list.Valuate(AIEngine.GetCargoType);
	engine_list.KeepValue(this.passenger_cargo_id);

	engine_list.Valuate(AIEngine.GetCapacity);
	engine_list.KeepTop(1);

	engine = engine_list.Begin();

	if (!AIEngine.IsValidEngine(engine)) {
		AILog.Error("Couldn't find a suitable engine");
		return -5;
	}
	local vehicle = AIVehicle.BuildVehicle(hangar, engine);
	if (!AIVehicle.IsValidVehicle(vehicle)) {
		AILog.Error("Couldn't build the aircraft");
		return -6;
	}
	AIOrder.AppendOrder(vehicle, tile_1, AIOrder.AIOF_NONE);
	AIOrder.AppendOrder(vehicle, tile_2, AIOrder.AIOF_NONE);
	AIVehicle.StartStopVehicle(vehicle);
	this.distance_of_route.rawset(vehicle, AIMap.DistanceManhattan(tile_1, tile_2));
	this.route_1.AddItem(vehicle, tile_1);
	this.route_2.AddItem(vehicle, tile_2);

	AILog.Info("Done building an aircraft");

	return 0;
}

function EpicTrans::FindSuitableAirportSpot(airport_type, center_tile)
{
	local airport_x, airport_y, airport_rad;

	airport_x = AIAirport.GetAirportWidth(airport_type);
	airport_y = AIAirport.GetAirportHeight(airport_type);
	airport_rad = AIAirport.GetAirportCoverageRadius(airport_type);

	local town_list = AITownList();
	town_list.RemoveList(this.towns_used);

	town_list.Valuate(AITown.GetPopulation);
	town_list.KeepTop(10);
	town_list.Valuate(AIBase.RandItem); local townlist = AIList();
	for (local town = town_list.Begin(); town_list.HasNext(); town = town_list.Next()) {
		Sleep(1);

		local tile = AITown.GetLocation(town);
		local list = AITileList();
		list.AddRectangle(tile - AIMap.GetTileIndex(15, 15), tile + AIMap.GetTileIndex(15, 15));
		list.Valuate(AITile.IsBuildableRectangle, airport_x, airport_y);
		list.KeepValue(1);
		if (center_tile != 0) {
			list.Valuate(AITile.GetDistanceSquareToTile, center_tile);
			list.KeepAboveValue(625);
		}
		list.Valuate(AITile.GetCargoAcceptance, this.passenger_cargo_id, airport_x, airport_y, airport_rad);
		list.RemoveBelowValue(10);
		if (list.Count() == 0) continue;
		{
			local test = AITestMode();
			local good_tile = 0;

			for (tile = list.Begin(); list.HasNext(); tile = list.Next()) {
				Sleep(1);
				if (!AIAirport.BuildAirport(tile, airport_type, AIStation.STATION_NEW)) continue;
				good_tile = tile;
				break;
			}
			if (good_tile == 0) continue;
		}

		AILog.Info("Found a good spot for an airport in town " + town + " at tile " + tile);
		this.towns_used.AddItem(town, tile);

		return tile;
	}

	AILog.Info("Couldn't find a suitable town to build an airport in");
	return -1;
}

function EpicTrans::ManageAirRoutes()
{
	local list = AIVehicleList();
	list.Valuate(AIVehicle.GetAge);
	list.KeepAboveValue(365 * 2);
	list.Valuate(AIVehicle.GetProfitLastYear);

	for (local i = list.Begin(); list.HasNext(); i = list.Next()) {
		local profit = list.GetValue(i);
		if (profit < (GetSetting("min_profit_keep_aircraft")) && AIVehicle.GetProfitThisYear(i) < (GetSetting("min_profit_keep_aircraft"))) {
			if (!vehicle_to_depot.rawin(i) || vehicle_to_depot.rawget(i) != true) {
				AILog.Info("Sending " + i + " to depot as profit is: " + profit + " / " + AIVehicle.GetProfitThisYear(i));
				AIVehicle.SendVehicleToDepot(i);
				vehicle_to_depot.rawset(i, true);
			}
		}
		if (vehicle_to_depot.rawin(i) && vehicle_to_depot.rawget(i) == true) {
			if (AIVehicle.SellVehicle(i)) {
				AILog.Info("Selling " + i + " as it finally is in a depot.");
				local list2 = AIVehicleList_Station(AIStation.GetStationID(this.route_1.GetValue(i)));
				if (list2.Count() == 0) this.SellAirports(i);
				vehicle_to_depot.rawdelete(i);
			}
		}
	}
	if (!this.HasMoney(GetSetting("min_money_aircraft"))) return;

	list = AIStationList(AIStation.STATION_AIRPORT);
	list.Valuate(AIStation.GetCargoWaiting, this.passenger_cargo_id);
	list.KeepAboveValue(250);

	for (local i = list.Begin(); list.HasNext(); i = list.Next()) {
		local list2 = AIVehicleList_Station(i);
		if (list2.Count() == 0) {
			this.SellAirports(i);
			continue;
		};

		local v = list2.Begin();
		local dist = this.distance_of_route.rawget(v);

		list2.Valuate(AIVehicle.GetAge);
		list2.KeepBelowValue(dist);
		if (list2.Count() != 0) continue;

		AILog.Info("Station " + i + " (" + AIStation.GetLocation(i) + ") has too many cargo, adding a new vehicle for the route.");


		this.GetMoney(GetSetting("min_money_aircraft"));

		return this.BuildAircraft(this.route_1.GetValue(v), this.route_2.GetValue(v));
	}
}
function EpicTrans::SellAirports(i) {
	AILog.Info("Removing airports as nobody serves them anymore.");
if(AIStation.GetCargoRating(this.route_1.GetValue(i),passenger_cargo_id)<=5)
	AIAirport.RemoveAirport(this.route_1.GetValue(i));
if(AIStation.GetCargoRating(this.route_2.GetValue(i),passenger_cargo_id)<=5)
	AIAirport.RemoveAirport(this.route_2.GetValue(i));
	this.towns_used.RemoveValue(this.route_1.GetValue(i));
	this.towns_used.RemoveValue(this.route_2.GetValue(i));
	this.route_1.RemoveItem(i);
	this.route_2.RemoveItem(i);
}

function EpicTrans::HandleEvents()
{
	while (AIEventController.IsEventWaiting()) {
		local e = AIEventController.GetNextEvent();
		switch (e.GetEventType()) {
			case AIEvent.AI_ET_VEHICLE_CRASHED: {
				local ec = AIEventVehicleCrashed.Convert(e);
				local v = ec.GetVehicleID();
				AILog.Info("We have a crashed vehicle (" + v + "), buying a new one as replacement");
				this.BuildAircraft(this.route_1.GetValue(v), this.route_2.GetValue(v));
				this.route_1.RemoveItem(v);
				this.route_2.RemoveItem(v);
			} break;

	AIAirport.RemoveAirport(this.route_2.GetValue(i));
			default:
				break;
		}
	}
}

