/**
 * @author Daniela Plachtova
 * @file station_info
 */

 /**
  * @brief basic StationInfo class
  */  
class StationInfo
{
	_stationID = null;			/* station id */
	_platform_length = null;	/* platform length */
	_number_of_tracks = null;	/* number of tracks */
	_exit_direction = null;     /* exit direction (station poiting in direction to the other) */
	_exit_tile_pair = null;		/* exit tiles of station */
	
	/**
	 * @brief constructor for StationInfo
	 * @param stationID station id
	 * @param platform_length platform length
	 * @param number_of_tracks number of tracks
	 * @param exit_direction exit direction (station pointing in direction to the other)
	 * @param exit_tile_pair exit tiles of station
	 */
	constructor(stationID, platform_length, number_of_tracks, exit_direction, exit_tile_pair)
	{
		_stationID = stationID;
		_platform_length = platform_length;
		_number_of_tracks = number_of_tracks;
		_exit_direction = exit_direction;
		_exit_tile_pair = exit_tile_pair;
	}
	/**
	 * @brief ToString
	 * @return string StationInfo
	 */
	function ToString()
	{
		return "StationID - " + _stationID + " StationName - " + AIStation.GetName(_stationID) + ", NumTracks - " + _number_of_tracks + 
		       ", PlatLength - " + _platform_length + " Direction - " + Direction.ToString(_exit_direction);
	} 
}

/**
 * @brief Class IndustryStationInfo
 */
class IndustryStationInfo extends StationInfo
{	
	_industryID = null;			/* industry id */
	_is_accepting = null;		/* is accepting industry */
	
	
	/**
	 * @brief constructor for IndustryStationInfo
	 * @param stationID station id
	 * @param platform_length platform length
	 * @param number_of_tracks number of tracks
	 * @param exit_direction exit direction (station poiting in direction of)
	 * @param exit_tile_pair exit tiles of station
	 * @param industryID industry id
	 * @param is_accepting true if station accepts cargo false if it produces cargo
	 */
	constructor(stationID, number_of_tracks, platform_length, exit_direction, exit_tile_pair, industryID, is_accepting) 
	{
		::StationInfo.constructor(stationID, number_of_tracks, platform_length, exit_direction, exit_tile_pair);
		_industryID = industryID;
		_is_accepting = is_accepting;
	}
	/**
	 * @brief ToString
	 * @return string IndustryStationInfo
	 */
	function ToString()
	{
		return ::StationInfo.ToString() + " " + ", IndustryID - " + _industryID + ", Accepting - " + _is_accepting;
	} 
	/**
	 * @brief auxiliary save function for game
	 * @return IndustryStationInfo in data table
	 */
	function Save() 
	{
		local data = {
			stationid = this._stationID,
			numberoftracks = this._number_of_tracks,
			platformlength = this._platform_length,
			exitdirection = this._exit_direction,
			exittilepair = this._exit_tile_pair,
			industryid = this._industryID,
			isaccepting = this._is_accepting
		}
		
		return data;
	}
	/**
	 * @brief auxiliary load function for game
	 * @param data data to load
	 * @return created IndustryStationInfo from data
	 */
	function Load(data) 
	{
		local stationID = data["stationid"];
		local number_of_tracks = data["numberoftracks"];
		local platform_length = data["platformlength"];
		local exit_direction = data["exitdirection"];
		local exit_tile_pair = data["exittilepair"];
		local industryID = data["industryid"];
		local is_accepting = data["isaccepting"];
		
		return IndustryStationInfo(stationID, number_of_tracks, platform_length, exit_direction, exit_tile_pair, industryID, is_accepting); 

		
	}
} 
/**
 * @brief class TownStationInfo
 */
class TownStationInfo extends StationInfo
{	
	_townID = null;		/* town id */
	
	/**
	 * @brief constructor for TownStationInfo
	 * @param stationID station id
	 * @param platform_length platform length
	 * @param number_of_tracks number of tracks
	 * @param exit_direction exit direction (station poiting in direction of)
	 * @param exit_tile_pair exit tiles of station
	 * @param townID town id
	 */
	constructor(stationID, number_of_tracks, platform_length, exit_direction, exit_tile_pair, townID) 
	{
		::StationInfo.constructor(stationID, number_of_tracks, platform_length, exit_direction, exit_tile_pair);
		_townID = townID;
	}
	
	/**
	 * @brief ToString
	 * @return string TownStationInfo
	 */
	function ToString()
	{
		return ::StationInfo.ToString() + " " + ", TownID - " + _townID;
	} 
	
	/**
	 * @brief auxiliary save function for game
	 * @return TownStationInfo in data table
	 */
	function Save() 
	{
		local data = {
			stationid = this._stationID,
			numberoftracks = this._number_of_tracks,
			platformlength = this._platform_length,
			exitdirection = this._exit_direction,
			exittilepair = this._exit_tile_pair,
			townid = this._townID
		}
		
		return data;
	}
	/**
	 * @brief auxiliary load function for game
	 * @param data data to load
	 * @return created TownStationInfo from data
	 */
	function Load(data) 
	{
		local stationID = data["stationid"];
		local number_of_tracks = data["numberoftracks"];
		local platform_length = data["platformlength"];
		local exit_direction = data["exitdirection"];
		local exit_tile_pair = data["exittilepair"];
		local townID = data["townid"];
		
		return TownStationInfo(stationID, number_of_tracks, platform_length, exit_direction, exit_tile_pair, townID);
		
	}
} 