class Industry
{
    constructor(id)
    {
        _id = id;
        _production = {};
    }

    _id = null;
    _all = {};
    _location = null;
    _production = null;

    static _logger = Log.GetLogger("Industry");
};


function Industry::Location()
{
    if (!_location)
        _location = AIIndustry.GetLocation(_id);
    return _location;
}



function Industry::_tostring()
{
    return AIIndustry.GetName(_id);
}



function Industry::EstimateProduction(cargo)
{
    return Production(cargo);
}



function Industry::All()
{
    local industries = AIIndustryList();
    foreach(i,_ in industries)
    {
        Industry.Get(i);
    }
    return Industry._all;
}



function Industry::Get(id)
{
    if ( !(id in Industry._all) )
    {
        local i = Industry(id);
        Industry._all[id] <- i;
        _logger.info("Creating industry", i);
    }
    return Industry._all[id];
}



function Industry::Accepting(cargo)
{
    return map(tableKeys(AIIndustryList_CargoAccepting(cargo)),
               function(i){ return Industry.Get(i); } );
}


function Industry::Id()
{
    return _id;
}


function Industry::IsValid()
{
    return AIIndustry.IsValidIndustry(_id) && AIIndustry.GetLocation(_id) == Location();
}



function Industry::Producing(cargo)
{
    return map(tableKeys(AIIndustryList_CargoProducing(cargo)),
               function(i){ return Industry.Get(i); } );
}


function Industry::ProductionHistory(cargo)
{
    if (!(cargo in _production))
	_production[cargo] <- [];
    return _production[cargo];
}


function Industry::Production(cargo,nMonths=3)
{
    local hist = ProductionHistory(cargo);

    local n = min(nMonths, hist.len());
    if (n==0)
        return 0;
    local sum = 0;
    for (local i=0; i<n ; i++ )
    {
        local idx = hist.len() - 1 - i;
        sum += hist[idx];
    }
    return sum / n;
}



function Industry::_cmp(other)
{
    return _id - other._id;
}



function Industry::UpdateStatistics()
{
    foreach (cargo,_ in AICargoList_IndustryProducing(_id))
    {
        if (!(cargo in _production))
            _production[cargo] <- [];
        _production[cargo].append(AIIndustry.GetLastMonthProduction(_id,cargo));
    }
}

        
function Industry::UpdateAllStatistics()
{
    foreach(id,ind in Industry.All())
    {
        ind.UpdateStatistics();
    }
}
