﻿class BorkAI extends AIInfo 
{
    function GetAuthor()      { return "marco.r"; }
    function GetName()        { return "BorkAI"; }
    function GetDescription() { return "A simple AI to have fun with"; }
    function GetVersion()     { return 23; }
    function GetDate()        { return "2016-05-03"; }
    function CreateInstance() { return "BorkAI"; }
    function GetShortName()   { return "BORK"; }
    function GetAPIVersion()  { return "1.2"; }
    function MinVersionToLoad() { return 19; }

    function GetSettings()
    {
	AddSetting({name = "Roadiness", description = "Tendency of the AI to build roads (the lower the value, the higher the road reuse)",
                    min_value = 0,
                    max_value = 100,
                    easy_value = 30, 
                    medium_value = 30, 
                    hard_value = 30, 
                    custom_value = 30, 
                    flags = CONFIG_INGAME});
	AddSetting({name = "Randomness", description = "Randomness factor",
                    min_value = 0,
                    max_value = 100,
                    easy_value = 90, 
                    medium_value = 70, 
                    hard_value = 50, 
                    custom_value = 70, 
                    flags = CONFIG_INGAME});
	AddSetting({name = "Debug", description = "Enable debug mode",
                    easy_value = 0, 
                    medium_value = 0, 
                    hard_value = 0, 
                    custom_value = 0, 
                    flags = CONFIG_INGAME | CONFIG_BOOLEAN});
	AddSetting({name = "enable_aircrafts", description = "Enable use of aircrafts",
		    easy_value = 1,
		    medium_value = 1,
		    hard_value = 1,
		    custom_value = 1,
		    flags = CONFIG_INGAME | CONFIG_BOOLEAN});
	AddSetting({name = "enable_trams", description = "Enable use of trams",
		    easy_value = 0,
		    medium_value = 0,
		    hard_value = 0,
		    custom_value = 0,
		    flags = CONFIG_INGAME | CONFIG_BOOLEAN});
	AddSetting({name = "Passengers and mail", description = "Enable the use of buses and mail trucks",
                    easy_value = 1, 
                    medium_value = 1, 
                    hard_value = 1, 
                    custom_value = 1, 
                    flags = CONFIG_INGAME | CONFIG_BOOLEAN});

	AddSetting({name = "log_level", description = "Main program log level",
                    min_value = 0,
                    max_value = 4,
                    easy_value = 2, 
                    medium_value = 2, 
                    hard_value = 2, 
                    custom_value = 2, 
                    flags = CONFIG_INGAME});
	AddSetting({name = "log_level_aircrafts", description = "Aircraft management log level",
                    min_value = 0,
                    max_value = 4,
                    easy_value = 2, 
                    medium_value = 2, 
                    hard_value = 2, 
                    custom_value = 2, 
                    flags = CONFIG_INGAME});
	AddSetting({name = "log_level_trucks", description = "Truck and bus management log level",
                    min_value = 0,
                    max_value = 4,
                    easy_value = 2, 
                    medium_value = 2, 
                    hard_value = 2, 
                    custom_value = 2, 
                    flags = CONFIG_INGAME});
	AddSetting({name = "log_level_trams", description = "Tram management log level",
                    min_value = 0,
                    max_value = 4,
                    easy_value = 2, 
                    medium_value = 2, 
                    hard_value = 2, 
                    custom_value = 2, 
                    flags = CONFIG_INGAME});

	_AddLogLabels();
    }
    
    function _AddLogLabels()
    {
	local settings = ["log_level", "log_level_aircrafts", "log_level_trucks", "log_level_trams"];
	foreach( setting in settings ) 
	{
	    AddLabels(setting, { 
		    _0 = "trace",
		    _1 = "debug",
		    _2 = "info",
		    _3 = "warning",
		    _4 = "error"
		});
	}		
    }
}

/* Tell the core we are an AI */
RegisterAI(BorkAI())
