class Airport extends Station
{
    function VehiclesPerDay();
    function GetTransport();
    function Destroy();
}

function numberOfRunways(airportType);
function numberOfTerminals(airportType);
function numberOfHelypads(airportType);

function Airport::GetTransport()
{
    return AirTransport();
}


function Airport::VehiclesPerDay()
{
    local airportType = AIAirport.GetAirportType(Location());
    local loadingRate = 1.0 * numberOfTerminals(airportType) / GetTransport().DaysAtStation();
    local takeoffRate = 1.0 *numberOfRunways(airportType) / AIR_TAKEOFF_DAYS ;
    return minf(loadingRate, takeoffRate);
}


function numberOfRunways(airportType) 
{
    switch(airportType)
    {
    case AIAirport.AT_HELIPORT:
    case AIAirport.AT_HELIDEPOT:
    case AIAirport.AT_HELISTATION:
	return 0;
    case AIAirport.AT_SMALL:
	return 2;
    case AIAirport.AT_COMMUTER:
    case AIAirport.AT_LARGE:
    case AIAirport.AT_METROPOLITAN:
	return 3;
    case AIAirport.AT_INTERNATIONAL:
	return 6;
    case AIAirport.AT_INTERCON:
	return 8;
    case AIAirport.AT_INVALID:
	log("ERROR",1,"canHandle: invalid airport:" + airportType);
	assert(false);
    default:
	log("ERROR",1,"canHandle: unknown airport:" + airportType);
	assert(false);
    }
}


function numberOfTerminals(airportType)
{
    switch(airportType)
    {
    case AIAirport.AT_HELIPORT:
    case AIAirport.AT_HELIDEPOT:
    case AIAirport.AT_HELISTATION:
	return 0;
    case AIAirport.AT_SMALL:
    case AIAirport.AT_COMMUTER:
    case AIAirport.AT_LARGE:
	return 1;
    case AIAirport.AT_METROPOLITAN:
    case AIAirport.AT_INTERNATIONAL:
	return 2;
    case AIAirport.AT_INTERCON:
	return 4;
    case AIAirport.AT_INVALID:
	log("ERROR",1,"Invalid airport:" + airportType);
	assert(false);
    default:
	log("ERROR",1,"Unknown airport:" + airportType);
	assert(false);
    }
}


function Airport::Destroy()
{
    // For now we never destroy airports.
    // First of all, because this way it's much easier to close routes
    // since we don't have to worry about waiting for aircraft to go
    // to hangars before destroying the airport.
    // Moreover hangars are not easy to build close to city, so for 
    // now we'll try to recycle them this way.
}