class Station 
{
    constructor(tile, frontTile, type, temporary)
    {
	this._tile = tile;
	this.frontTile = frontTile;
	this.type = type;
	this.temporary = temporary
	this.valid = true;
    }

    function Save();
    static function Load(table)
    {
        switch(table.type)
        {
        case AIStation.STATION_TRAIN:
            throw "Cannot load train stations!";
        case AIStation.STATION_DOCK:
            throw "Cannot load docks!";
        case AIStation.STATION_TRUCK_STOP:
        case AIStation.STATION_BUS_STOP:
            return BusStation(table.tile, table.frontTile, table.type, table.temporary )
        case AIStation.STATION_AIRPORT:
            return Airport(table.tile, table.frontTile, table.type, table.temporary );
        default:
            throw "Unknown station type found: " + table.type;
        }
    }

    function DestroyIfTemporary();
    function Destroy();
    function Location();
    /*
     * Return the maximum number of vehicles that can be serviced in a single day.
     * Should take into account all the features of the station (number of docks, entrances, rails, runways etc.)
     * but it is anyway a rough estimate
     */
    function VehiclesPerDay();
    function GetTransport();
    function _tostring();
    
    _tile = null;
    frontTile = null;
    type = null;
    // The station is temporary, i.e. built but not yet used in route
    // this variable is ... temporary :D until we do something smarter.
    temporary = null;
    valid = null;
}


function Station::Save()
{
    return {
	tile = this._tile,
	frontTile = this.frontTile,
	type = this.type,
	temporary = this.temporary,
	valid = this.valid
    };
}


function Station::Destroy()
{
    local removed = false;
    local n = 0;
    while(!removed && n++ < 10000)
    {
        removed = _RecDestroy();
    }
    if (n >= 10000 ) 
    {
	log("ERROR",1, "Unable to remove station" + this);
    }
}


function Station::DestroyIfTemporary()
{
    if (temporary)
    {
	Destroy();
    }
}


function Station::_RecDestroy()
{
    local removed = null;

    switch(type)
    {
    case AIStation.STATION_TRAIN:
	throw "Removal of train stations not handled yet";
	// removed = AIRail.RemoveRailStationTileRectangle(_position, position, false);
	break;
    case AIStation.STATION_TRUCK_STOP:
    case AIStation.STATION_BUS_STOP:
	removed = AIRoad.RemoveRoadStation(_tile);
	break;
    case AIStation.STATION_AIRPORT:
	removed = AIAirport.RemoveAirport(_tile);
	break;
    case AIStation.STATION_DOCK:
	throw "Removal of docks not handled yet";
    default:
	throw "Unknown station type";
    }
    if (removed) 
    {
	valid = false;
    }
    return removed;
}


function Station::Location()
{
    return _tile;
}


function Station::_tostring()
{
    return "[Station " + location(_tile) + "]";
}


require("bus_station.nut");
require("airport.nut");
