function distance(tile,tile2)
{
    return AITile.GetDistanceManhattanToTile(tile,tile2);
}

function nothing(x){}


function pop(table)
{
    foreach( key,value in table )
    {
	delete table[key];
	return key;
    }
}

/*
 * Return the torus around the tile of all the tiles that
 * have distance (in one axis) between minDistance and maxDistance
 * (included)
 */
function areaAround(tile, minDistance, maxDistance)
{
    local m = -minDistance;
    local n = minDistance;
    for (local i=(-maxDistance); i<=maxDistance; ++i)
    {
        for (local j=(-maxDistance); j<=maxDistance; ++j)
        {
            if ( i==0 && j> m && j < n )
                continue;
            if ( j==0 && i> m && i < n )
                continue; 
            yield tile + AIMap.GetTileIndex(i,j);
        }
    }




};

// Scan the area around the "center" tile
// expanding while the function "condition"
// returns true, collect the value of fun applied to the location
function scanArea( center, condition, fun, display = null)
{
    local seen = {};
    local todo = {};
    todo[center] <- true;
    while(todo.len())
    {
        local next = pop(todo);
        // AILog.Info("Next is " + location(next));
        if (!AIMap.IsValidTile(next))
        {
            // AILog.Info("Not a valid tile");
            continue;
        }
        if (next in seen)
        {
            // AILog.Info("Already saw it");
            continue;
        }
        if (!condition(next))
        {
            // AILog.Info("Doesn't satisfy condition");
            continue;
        }
        seen[next] <- true;
        foreach (dir in DIRECTIONS)
        {
            todo[next+dir] <- true;
        }
    }
    
    local result = {}
    local execMode = AIExecMode();
    foreach( x,_ in seen )
    {
        result[x] <- fun(x);
	if (display)
        {
            // AILog.Info( "Display:" + x + " -> " + display(result[x]));
            AISign.BuildSign(x, display(result[x]));
        }
    }
    return result;
}

    
        
