/**
   Using the given list of probabilities, select 
   one index
*/
function rouletteWheel(probabilities)
{
    local bounds = scanl(probabilities,op("+"),0);
    assert(bounds.len() == probabilities.len());
    
    
    local factor = 10000000 / bounds[ bounds.len()-1 ];
    
    bounds = map( bounds , function(x):(factor){return x*factor;});
    
    local total = bounds[ bounds.len()-1].tointeger();
    
    
    local chosen = AIBase.RandRange(total);

    for(local i=0; i<bounds.len(); ++i )
    {
        if (chosen <= bounds[i])
            return i;
    }
    
    
    return bounds[ bounds.len()-1 ];
}

function chanceRoulette(chance,nItems)
{
    local probs = [];
    local initialProb = 1.0;
    for ( local i=0; i<nItems; ++i )
    {
        probs.append(initialProb);
        initialProb = initialProb*chance;
    }
    return rouletteWheel(probs);
}

function shuffleTableKeys(table)
{
    local result = [];
    foreach( key,value in table )
        result.append(key);

    local n = result.len();
    for (local i= n-1; i >= 1; i-- )
    {
        local j = AIBase.RandRange(i+1);
        local tmp = result[i];
        result[i] = result[j];
        result[j] = tmp;
    }
    return result;
}

function shuffle(sequence)
{
    local result = [];
    foreach( x in sequence )
        result.append(x);

    local n = result.len();
    for (local i= n-1; i >= 1; i-- )
    {
        local j = AIBase.RandRange(i+1);
        local tmp = result[i];
        result[i] = result[j];
        result[j] = tmp;
    }
    return result;
}


function random_subset(sequence,n)
{
    local items = shuffle(sequence);
    local nelem = min(items.len(), n);
    return items.slice(0,nelem);
}